/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.elemental;

import com.lothrazar.cyclic.item.ItemBaseCyclic;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.ItemStackUtil;
import com.lothrazar.cyclic.util.LevelWorldUtil;
import com.lothrazar.cyclic.util.ShapeUtil;
import com.lothrazar.cyclic.util.SoundUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AntimatterEvaporatorWandItem
extends ItemBaseCyclic {
    private static final int SIZE = 4;
    private static final String NBT_MODE = "mode";
    public static final int COOLDOWN = 15;

    public AntimatterEvaporatorWandItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Direction face = context.m_43719_();
        ItemStack itemstack = context.m_43722_();
        EvaporateMode fluidMode = EvaporateMode.values()[itemstack.m_41784_().m_128451_(NBT_MODE)];
        List<BlockPos> area = ShapeUtil.cubeSquareBase(pos.m_121945_(face), 4, 1);
        switch (fluidMode) {
            case GENERIC: {
                break;
            }
            case LAVA: {
                break;
            }
            case WATER: {
                break;
            }
        }
        int countSuccess = 0;
        boolean tryHere = false;
        for (BlockPos posTarget : area) {
            BlockState blockHere = world.m_8055_(posTarget);
            FluidState fluidHere = blockHere.m_60819_();
            if (fluidHere == null) continue;
            tryHere = false;
            if (fluidMode == EvaporateMode.GENERIC && fluidHere.m_76152_() != null && fluidHere.m_76152_() != Fluids.f_76191_) {
                tryHere = true;
            } else if (fluidMode == EvaporateMode.WATER && fluidHere.m_205070_(FluidTags.f_13131_)) {
                tryHere = true;
            } else if (fluidMode == EvaporateMode.LAVA && fluidHere.m_205070_(FluidTags.f_13132_)) {
                tryHere = true;
            }
            if (!tryHere || !LevelWorldUtil.removeFlowingLiquid(world, posTarget, true)) continue;
            ++countSuccess;
        }
        if (countSuccess > 0) {
            Player player = context.m_43723_();
            player.m_6674_(context.m_43724_());
            ItemStackUtil.damageItem((LivingEntity)player, itemstack);
            if (world.f_46443_) {
                SoundUtil.playSound(world, pos, (SoundEvent)SoundRegistry.PSCHEW_FIRE.get());
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)AntimatterEvaporatorWandItem.getModeTooltip(stack).m_130940_(ChatFormatting.AQUA));
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        stack.m_41784_().m_128405_(NBT_MODE, EvaporateMode.WATER.ordinal());
        super.m_7836_(stack, worldIn, playerIn);
    }

    private static MutableComponent getModeTooltip(ItemStack stack) {
        EvaporateMode mode = EvaporateMode.values()[stack.m_41784_().m_128451_(NBT_MODE)];
        return Component.m_237110_((String)"item.cyclic.antimatter_wand.tooltip0", (Object[])new Object[]{Component.m_237115_((String)String.format("item.cyclic.antimatter_wand.mode.%s", mode.m_7912_()))});
    }

    public static void toggleMode(Player player, ItemStack stack) {
        if (player.m_36335_().m_41519_(stack.m_41720_())) {
            return;
        }
        EvaporateMode mode = EvaporateMode.values()[stack.m_41784_().m_128451_(NBT_MODE)];
        stack.m_41784_().m_128405_(NBT_MODE, mode.getNext().ordinal());
        player.m_36335_().m_41524_(stack.m_41720_(), 15);
        if (player.m_9236_().f_46443_) {
            player.m_5661_((Component)AntimatterEvaporatorWandItem.getModeTooltip(stack), true);
            SoundUtil.playSound((Entity)player, (SoundEvent)SoundRegistry.TOOL_MODE.get());
        }
    }

    public static enum EvaporateMode implements StringRepresentable
    {
        WATER,
        LAVA,
        GENERIC;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public EvaporateMode getNext() {
            switch (this) {
                case WATER: {
                    return LAVA;
                }
                case LAVA: {
                    return GENERIC;
                }
                case GENERIC: {
                    return WATER;
                }
            }
            return WATER;
        }
    }
}

