/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import com.lothrazar.cyclic.data.Model3D;
import com.lothrazar.cyclic.render.FakeBlockRenderTypes;
import com.lothrazar.cyclic.render.RenderResizableCuboid;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final int FULL_LIGHT = 0xF000F0;

    private static void renderCube(Matrix4f matrix, VertexConsumer builder, BlockPos pos, Color color, float alpha) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float startX = 0.0f;
        float startY = 0.0f;
        float startZ = -1.0f;
        float endX = 1.0f;
        float endY = 1.0f;
        float endZ = 0.0f;
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, endX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, startY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, endZ).m_85950_(red, green, blue, alpha).m_5752_();
        builder.m_252986_(matrix, startX, endY, startZ).m_85950_(red, green, blue, alpha).m_5752_();
    }

    private static void renderModelBrightnessColorQuads(PoseStack.Pose matrixEntry, VertexConsumer builder, float red, float green, float blue, float alpha, List<BakedQuad> quads, int combinedLights, int combinedOverlay) {
        for (BakedQuad bakedquad : quads) {
            float b;
            float g;
            float r;
            if (bakedquad.m_111304_()) {
                r = red * 1.0f;
                g = green * 1.0f;
                b = blue * 1.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            boolean readExistingColor = false;
            builder.putBulkData(matrixEntry, bakedquad, r, g, b, alpha, combinedLights, combinedOverlay, readExistingColor);
        }
    }

    public static void renderObject(Model3D object, PoseStack matrix, VertexConsumer buffer, int argb, int light) {
        if (object != null) {
            RenderResizableCuboid.INSTANCE.renderCube(object, matrix, buffer, argb, light);
        }
    }

    public static int calculateGlowLight(int light, FluidStack fluid) {
        return fluid.isEmpty() ? light : RenderUtils.calculateGlowLight(light, fluid.getFluid().getFluidType().getLightLevel());
    }

    public static int calculateGlowLight(int light, int glow) {
        if (glow >= 15) {
            return 0xF000F0;
        }
        int blockLight = LightTexture.m_109883_((int)light);
        int skyLight = LightTexture.m_109894_((int)light);
        return LightTexture.m_109885_((int)Math.max(blockLight, glow), (int)Math.max(skyLight, glow));
    }

    public static int getColorARGB(FluidStack fluidStack, float fluidScale) {
        if (fluidStack.isEmpty()) {
            return -1;
        }
        return RenderUtils.getColorARGB(fluidStack);
    }

    private static int getColorARGB(FluidStack fluidStack) {
        IClientFluidTypeExtensions fluidAttributes = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        return fluidAttributes.getTintColor(fluidStack);
    }

    public static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)(color >> 24 & 0xFF) / 255.0f;
    }

    public static void renderAsBlock(Level level, BlockPos centerPos, List<BlockPos> shape, PoseStack matrix, ItemStack stack, float alpha, float scale) {
        BlockState renderBlockState = Block.m_49814_((Item)stack.m_41720_()).m_49966_();
        RenderUtils.renderAsBlock(level, centerPos, shape, matrix, renderBlockState, alpha, scale);
    }

    public static void renderAsBlock(Level world, BlockPos centerPos, List<BlockPos> shape, PoseStack matrix, BlockState renderBlockState, float alpha, float scale) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.FAKE_BLOCK);
        BlockRenderDispatcher dispatcher = mc.m_91289_();
        matrix.m_85836_();
        matrix.m_252880_((float)(-centerPos.m_123341_()), (float)(-centerPos.m_123342_()), (float)(-centerPos.m_123343_()));
        for (BlockPos coordinate : shape) {
            float x = coordinate.m_123341_();
            float y = coordinate.m_123342_();
            float z = coordinate.m_123343_();
            matrix.m_85836_();
            matrix.m_252880_(x, y, z);
            matrix.m_252880_(-5.0E-4f, -5.0E-4f, -5.0E-4f);
            matrix.m_85841_(scale, scale, scale);
            BakedModel ibakedmodel = dispatcher.m_110910_(renderBlockState);
            BlockColors blockColors = Minecraft.m_91087_().m_91298_();
            int color = blockColors.m_92577_(renderBlockState, (BlockAndTintGetter)world, coordinate, 0);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (renderBlockState.m_60799_() == RenderShape.MODEL) {
                int combinedLights = 0xF00000;
                int combinedOverlay = 655360;
                for (Direction direction : Direction.values()) {
                    RenderUtils.renderModelBrightnessColorQuads(matrix.m_85850_(), builder, red, green, blue, alpha, ibakedmodel.getQuads(renderBlockState, direction, world.f_46441_, ibakedmodel.getModelData((BlockAndTintGetter)world, centerPos, renderBlockState, null), FakeBlockRenderTypes.FAKE_BLOCK), combinedLights, combinedOverlay);
                }
            }
            matrix.m_85849_();
        }
        matrix.m_85849_();
    }

    public static void renderOutline(BlockPos view, BlockPos pos, PoseStack matrix, float scale, Color color) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        coords.add(pos);
        RenderUtils.renderOutline(view, coords, matrix, scale, color);
    }

    public static void renderOutline(BlockPos view, List<BlockPos> coords, PoseStack matrix, float scale, Color color) {
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        matrix.m_85836_();
        matrix.m_252880_((float)(-view.m_123341_()), (float)(-view.m_123342_()), (float)(-view.m_123343_()));
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.SOLID_COLOUR);
        for (BlockPos e : coords) {
            if (e == null) continue;
            matrix.m_85836_();
            float ctr = (1.0f - scale) / 2.0f;
            matrix.m_252880_((float)e.m_123341_() + ctr, (float)e.m_123342_() + ctr, (float)e.m_123343_() + ctr);
            matrix.m_252880_(-0.005f, -0.005f, -0.005f);
            matrix.m_85841_(scale, scale, scale);
            matrix.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            Matrix4f positionMatrix = matrix.m_85850_().m_252922_();
            RenderUtils.renderCube(positionMatrix, builder, e, color, 0.125f);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        buffer.m_109912_(FakeBlockRenderTypes.SOLID_COLOUR);
    }

    public static BlockHitResult getLookingAt(Player player, int range) {
        return (BlockHitResult)player.m_19907_((double)range, 0.0f, false);
    }

    public static void renderColourCubes(RenderLevelStageEvent evt, Map<BlockPos, Color> coords, float alpha) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        float scale = 1.01f;
        Minecraft mc = Minecraft.m_91087_();
        MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
        Vec3 view = mc.f_91063_.m_109153_().m_90583_();
        PoseStack matrix = evt.getPoseStack();
        matrix.m_85836_();
        matrix.m_85837_(-view.m_7096_(), -view.m_7098_(), -view.m_7094_());
        VertexConsumer builder = buffer.m_6299_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
        for (BlockPos posCurr : coords.keySet()) {
            matrix.m_85836_();
            matrix.m_252880_((float)posCurr.m_123341_(), (float)posCurr.m_123342_(), (float)posCurr.m_123343_());
            matrix.m_252880_(-0.005f, -0.005f, -0.005f);
            matrix.m_85841_(scale, scale, scale);
            matrix.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            RenderUtils.renderCube(matrix.m_85850_().m_252922_(), builder, posCurr, coords.get(posCurr), alpha);
            matrix.m_85849_();
        }
        matrix.m_85849_();
        RenderSystem.disableDepthTest();
        buffer.m_109912_(FakeBlockRenderTypes.TRANSPARENT_COLOUR);
    }

    public static void createBox(PoseStack poseStack, BlockPos pos) {
        poseStack.m_85836_();
        RenderUtils.createBox(Minecraft.m_91087_().m_91269_().m_110104_(), poseStack, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 1.0f);
        poseStack.m_85849_();
    }

    private static void createBox(MultiBufferSource.BufferSource bufferSource, PoseStack poseStack, float x, float y, float z, float offset) {
        long c = System.currentTimeMillis() / 15L % 360L;
        float[] color = RenderUtils.getHSBtoRGBF((float)c / 360.0f, 1.0f, 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPosition = mc.f_91063_.m_109153_().m_90583_();
        Vec3 vec = new Vec3((double)x, (double)y, (double)z).m_82546_(cameraPosition);
        if (vec.m_82554_(Vec3.f_82478_) > 200.0) {
            vec = vec.m_82541_().m_82490_(200.0);
            x = (float)((double)x + vec.f_82479_);
            y = (float)((double)y + vec.f_82480_);
            z = (float)((double)z + vec.f_82481_);
        }
        RenderSystem.disableDepthTest();
        VertexConsumer vertexConsumer = bufferSource.m_6299_(FakeBlockRenderTypes.TOMB_LINES);
        poseStack.m_85837_(-cameraPosition.f_82479_, -cameraPosition.f_82480_, -cameraPosition.f_82481_);
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y + offset, z).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x + offset, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        vertexConsumer.m_252986_(pose, x, y + offset, z + offset).m_85950_(color[0], color[1], color[2], 1.0f).m_5752_();
        bufferSource.m_109912_(FakeBlockRenderTypes.TOMB_LINES);
        RenderSystem.enableDepthTest();
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
    }
}

