/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.antipotion;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.antipotion.TileAntiBeacon;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.util.BlockstatesUtil;
import com.lothrazar.library.util.EntityUtil;
import com.lothrazar.library.util.StringParseUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockAntiBeacon
extends BlockCyclic {
    private static final float[] COLOR = new float[]{1.0f, 1.0f, 1.0f};

    public BlockAntiBeacon(BlockBehaviour.Properties properties) {
        super(properties.m_60977_().m_60978_(0.7f).m_60955_());
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return COLOR;
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAntiBeacon(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockAntiBeacon.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TileRegistry.ANTI_BEACON.get()), (BlockEntityTicker)(world.f_46443_ ? TileAntiBeacon::clientTick : TileAntiBeacon::serverTick));
    }

    public void m_6807_(BlockState bs, Level world, BlockPos pos, BlockState bsIn, boolean p_56815_) {
        if (!bsIn.m_60713_(bs.m_60734_())) {
            BlockAntiBeacon.absorbPotions(world, pos);
        }
    }

    public static void absorbPotions(Level world, BlockPos pos) {
        List all = world.m_45976_(LivingEntity.class, EntityUtil.makeBoundingBox((BlockPos)pos, (int)((Integer)TileAntiBeacon.RADIUS.get()), (int)3));
        for (LivingEntity e : all) {
            BlockAntiBeacon.cureAllRelevant(e);
        }
    }

    private static void cureAllRelevant(LivingEntity e) {
        ArrayList<MobEffect> cureMe = new ArrayList<MobEffect>();
        for (MobEffect mobEffect : e.m_21221_().keySet()) {
            if (!BlockAntiBeacon.doesConfigBlockEffect(mobEffect)) continue;
            cureMe.add(mobEffect);
        }
        for (MobEffect curedEffect : cureMe) {
            ModCyclic.LOGGER.info("[potion cured] " + curedEffect);
            e.m_21195_(curedEffect);
        }
    }

    private static boolean doesConfigBlockEffect(MobEffect mobEffect) {
        if (((Boolean)TileAntiBeacon.HARMFUL_POTIONS.get()).booleanValue() && mobEffect.m_19483_() == MobEffectCategory.HARMFUL) {
            return true;
        }
        ResourceLocation potionId = ForgeRegistries.MOB_EFFECTS.getKey((Object)mobEffect);
        return StringParseUtil.isInList((List)((List)TileAntiBeacon.POTIONS.get()), (ResourceLocation)potionId);
    }

    public void isPotionApplicable(MobEffectEvent.Applicable event) {
        if (event.getEffectInstance() == null) {
            return;
        }
        if (BlockAntiBeacon.doesConfigBlockEffect(event.getEffectInstance().m_19544_())) {
            boolean isPowered = false;
            ArrayList blocks = BlockstatesUtil.findBlocks((Level)event.getEntity().m_20193_(), (BlockPos)event.getEntity().m_20183_(), (Block)this, (int)((Integer)TileAntiBeacon.RADIUS.get()), (boolean)false);
            if (blocks != null && blocks.size() > 0) {
                ModCyclic.LOGGER.info("[potion blocked] " + event.getEffectInstance());
                event.setResult(Event.Result.DENY);
            }
        }
    }
}

