/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.batteryclay;

import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.cap.item.CapabilityProviderEnergyStack;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;

public class ItemBlockClayBattery
extends BlockItem {
    public static final String ENERGYTTMAX = "energyttmax";
    public static final String ENERGYTT = "energytt";

    public ItemBlockClayBattery(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public boolean m_142522_(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        return storage != null && storage.getEnergyStored() > 0;
    }

    public int m_142158_(ItemStack stack) {
        float current = 0.0f;
        float max = 0.0f;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (storage != null) {
            current = storage.getEnergyStored();
            max = storage.getMaxEnergyStored();
        } else if (stack.m_41782_() && stack.m_41783_().m_128441_(ENERGYTT)) {
            current = stack.m_41783_().m_128451_(ENERGYTT);
            max = stack.m_41783_().m_128451_(ENERGYTTMAX);
        }
        return max == 0.0f ? 0 : Math.round(13.0f * current / max);
    }

    public int m_142159_(ItemStack stack) {
        return 12192009;
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        int current = 0;
        int energyttmax = 0;
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (storage != null) {
            current = storage.getEnergyStored();
            energyttmax = storage.getMaxEnergyStored();
            tooltip.add((Component)Component.m_237115_((String)(current + "/" + energyttmax)).m_130940_(ChatFormatting.RED));
        } else if (stack.m_41782_() && stack.m_41783_().m_128441_(ENERGYTT)) {
            current = stack.m_41783_().m_128451_(ENERGYTT);
            energyttmax = stack.m_41783_().m_128451_(ENERGYTTMAX);
            tooltip.add((Component)Component.m_237115_((String)(current + "/" + energyttmax)).m_130940_(ChatFormatting.BLUE));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new CapabilityProviderEnergyStack(16000);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
        if (storage != null) {
            nbt.m_128405_(ENERGYTT, storage.getEnergyStored());
            nbt.m_128405_(ENERGYTTMAX, storage.getMaxEnergyStored());
        }
        return nbt;
    }

    public void readShareTag(ItemStack stack, CompoundTag nbt) {
        if (nbt != null) {
            CompoundTag stackTag = stack.m_41784_();
            int serverEnergyValue = nbt.m_128451_(ENERGYTT);
            stackTag.m_128405_(ENERGYTT, serverEnergyValue);
            stackTag.m_128405_(ENERGYTTMAX, nbt.m_128451_(ENERGYTTMAX));
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
            if (storage instanceof CustomEnergyStorage) {
                CustomEnergyStorage energy = (CustomEnergyStorage)storage;
                energy.setEnergy(serverEnergyValue);
            }
        }
        super.readShareTag(stack, nbt);
    }
}

