/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.collectfluid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.collectfluid.ContainerFluidCollect;
import com.lothrazar.cyclic.capabilities.block.FluidTankBase;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.CustomEnergyStorage;
import com.lothrazar.library.util.ShapeUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFluidCollect
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX_HEIGHT = 64;
    public static final int MAX_SIZE = 12;
    public static final int CAPACITY = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    FluidTankBase tank;
    private final LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);
    private int shapeIndex = 0;
    private int size = 8;
    private int height = 4;
    BlockPos targetPos = null;
    static final int MAX = 64000;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return Block.m_49814_((Item)stack.m_41720_()) != Blocks.f_50016_;
        }
    };
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);

    public TileFluidCollect(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.COLLECTOR_FLUID.get(), pos, state);
        this.tank = new FluidTankBase(this, 64000, p -> true);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileFluidCollect e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileFluidCollect e) {
        e.tick();
    }

    public void tick() {
        FluidStack fstack;
        int result;
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        Integer cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_41619_() || Block.m_49814_((Item)stack.m_41720_()) == Blocks.f_50016_) {
            return;
        }
        this.setLitProperty(true);
        List<BlockPos> shape = this.getShapeFilled();
        if (shape.size() == 0) {
            return;
        }
        this.incrementShapePtr(shape);
        this.targetPos = shape.get(this.shapeIndex);
        FluidState fluidState = this.f_58857_.m_6425_(this.targetPos);
        if (fluidState.m_76170_() && (result = this.tank.fill(fstack = new FluidStack(fluidState.m_76152_(), 1000), IFluidHandler.FluidAction.SIMULATE)) == 1000 && this.f_58857_.m_46597_(this.targetPos, Block.m_49814_((Item)stack.m_41720_()).m_49966_())) {
            stack.m_41774_(1);
            this.tank.fill(fstack, IFluidHandler.FluidAction.EXECUTE);
            this.energy.extractEnergy(cost.intValue(), false);
        }
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public AABB getRenderBoundingBox() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    private BlockPos getTargetCenter() {
        return this.getCurrentFacingPos(this.size + 1);
    }

    public List<BlockPos> getShapeHollow() {
        BlockPos ctr = this.getTargetCenter();
        List shape = ShapeUtil.squareHorizontalHollow((BlockPos)ctr.m_6625_(this.height), (int)this.size);
        shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)this.height);
        if (this.targetPos != null) {
            shape.add(this.targetPos);
        }
        return shape;
    }

    public List<BlockPos> getShapeFilled() {
        BlockPos ctr = this.getTargetCenter();
        List shape = ShapeUtil.squareHorizontalFull((BlockPos)ctr.m_6625_(this.height), (int)this.size);
        shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)(this.height - 1));
        return shape;
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.COLLECTOR_FLUID.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerFluidCollect(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCap.cast();
        }
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.shapeIndex = tag.m_128451_("shapeIndex");
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        tag.m_128405_("shapeIndex", this.shapeIndex);
        super.m_183515_(tag);
    }

    private void incrementShapePtr(List<BlockPos> shape) {
        ++this.shapeIndex;
        if (this.shapeIndex < 0 || this.shapeIndex >= shape.size()) {
            this.shapeIndex = 0;
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.setNeedsRedstone(value);
                break;
            }
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
                break;
            }
            case HEIGHT: {
                this.height = Math.min(value, 64);
                break;
            }
            case SIZE: {
                this.size = Math.min(value, 12);
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case HEIGHT: {
                return this.height;
            }
            case SIZE: {
                return this.size;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE,
        RENDER,
        SIZE,
        HEIGHT;

    }
}

