/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.enderitemshelf;

import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.enderitemshelf.TileItemShelf;
import com.lothrazar.cyclic.block.endershelf.BlockEnderShelf;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.library.util.BlockstatesUtil;
import com.lothrazar.library.util.ItemStackUtil;
import com.lothrazar.library.util.SoundUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockItemShelf
extends BlockCyclic {
    public BlockItemShelf(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(0.8f).m_60955_());
    }

    @Override
    public void registerClient() {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileItemShelf(pos, state);
    }

    @Override
    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            worldIn.m_46747_(pos);
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        TileItemShelf shelf = this.getTileEntity(world, pos);
        if (heldItem.m_204117_(DataTags.WRENCH)) {
            shelf.toggleShowText();
            player.m_6674_(hand);
            return InteractionResult.PASS;
        }
        Direction face = hit.m_82434_();
        Vec3 hitVec = hit.m_82450_();
        int slot = BlockEnderShelf.getSlotFromHitVec(pos, face, hitVec);
        if (hit.m_82434_() == state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            ItemStack shelfStack = shelf.inventory.getStackInSlot(slot);
            if (shelfStack.m_41619_() || heldItem.m_41720_() == shelfStack.m_41720_()) {
                boolean oldEmpty = shelfStack.m_41619_();
                ItemStack remaining = shelf.inventory.insertItem(slot, heldItem, false);
                if (remaining.m_41619_() || remaining.m_41613_() != shelfStack.m_41613_()) {
                    player.m_21008_(hand, remaining);
                    player.m_6674_(hand);
                    SoundUtil.playSound((Entity)player, (SoundEvent)((SoundEvent)SoundRegistry.CRACKLE.get()), (float)(oldEmpty ? 0.3f : 0.1f), (float)0.3f);
                    return InteractionResult.CONSUME;
                }
            }
            if (heldItem.m_41619_()) {
                int q = player.m_6047_() ? 1 : 64;
                ItemStack retrieved = shelf.inventory.extractItem(slot, q, false);
                player.m_21008_(hand, retrieved);
                player.m_6674_(hand);
            }
            if (!shelfStack.m_41619_() && !heldItem.m_41619_()) {
                ItemStack forShelf = heldItem.m_41777_();
                ItemStack forPlayer = shelf.inventory.extractItem(slot, 64, false);
                player.m_21008_(hand, forPlayer);
                player.m_6674_(hand);
                shelf.inventory.insertItem(slot, forShelf, false);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public TileItemShelf getTileEntity(Level world, BlockPos pos) {
        return (TileItemShelf)world.m_7702_(pos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)BlockstatesUtil.getFacingFromEntityHorizontal((BlockPos)pos, (LivingEntity)entity)), 2);
        }
        BlockEntity tileentity = world.m_7702_(pos);
        TileItemShelf shelf = (TileItemShelf)tileentity;
        if (stack.m_41783_() != null) {
            shelf.inventory.deserializeNBT(stack.m_41783_());
        }
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity tileentity, ItemStack stackToolUsed) {
        super.m_6240_(world, player, pos, state, tileentity, stackToolUsed);
        ItemStack newStack = new ItemStack((ItemLike)this);
        if (tileentity instanceof TileItemShelf) {
            TileItemShelf shelf = (TileItemShelf)tileentity;
            CompoundTag tileData = shelf.inventory.serializeNBT();
            newStack.m_41751_(tileData);
        }
        ItemStackUtil.dropItemStackMotionless((Level)world, (BlockPos)pos, (ItemStack)newStack);
    }
}

