/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.fishing;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.fishing.ContainerFisher;
import com.lothrazar.cyclic.data.DataTags;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.util.ItemStackUtil;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileFisher
extends TileBlockEntityCyclic
implements MenuProvider {
    public static ForgeConfigSpec.IntValue RADIUS;
    public static ForgeConfigSpec.DoubleValue CHANCE;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_204117_(DataTags.FISHING_RODS);
        }
    };
    LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileFisher(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FISHER.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileFisher e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileFisher e) {
        e.tick();
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.FISHER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerFisher(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        int z;
        int y;
        int x;
        BlockPos center;
        if (this.requiresRedstone() && !this.isPowered()) {
            return;
        }
        int radius = (Integer)RADIUS.get();
        ItemStack stack = this.inventory.getStackInSlot(0);
        if (stack.m_204117_(DataTags.FISHING_RODS) && TileFisher.isWater(this.f_58857_, center = new BlockPos(x = this.f_58858_.m_123341_() + this.f_58857_.f_46441_.m_188503_(radius * 2) - radius, y = this.f_58858_.m_123342_(), z = this.f_58858_.m_123343_() + this.f_58857_.f_46441_.m_188503_(radius * 2) - radius))) {
            try {
                this.doFishing(stack, center);
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Fishing Block: Loot table failed", e);
            }
        }
    }

    public static boolean isWater(Level level, BlockPos center) {
        return level.m_8055_(center).m_60734_() == Blocks.f_49990_;
    }

    private void doFishing(ItemStack fishingRod, BlockPos center) {
        Level world = this.m_58904_();
        RandomSource rand = world.f_46441_;
        if (rand.m_188500_() < (Double)CHANCE.get() && world instanceof ServerLevel) {
            LootDataManager manager = this.f_58857_.m_7654_().m_278653_();
            if (manager == null) {
                return;
            }
            LootTable table = (LootTable)manager.m_278789_(LootDataType.f_278413_, BuiltInLootTables.f_78720_);
            if (table == null) {
                return;
            }
            int luck = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44953_, (ItemStack)fishingRod) + 1;
            LootParams lootContext = new LootParams.Builder((ServerLevel)world).m_287239_((float)luck).m_287286_(LootContextParams.f_81460_, (Object)new Vec3((double)center.m_123341_(), (double)center.m_123342_(), (double)center.m_123343_())).m_287286_(LootContextParams.f_81463_, (Object)fishingRod).m_287235_(LootContextParamSets.f_81414_);
            ObjectArrayList lootDrops = table.m_287195_(lootContext);
            if (lootDrops != null && lootDrops.size() > 0) {
                ItemStackUtil.drop((Level)world, (BlockPos)center, (List)lootDrops);
                if (fishingRod.m_41763_()) {
                    int mending = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44962_, (ItemStack)fishingRod);
                    if (mending == 0) {
                        ItemStackUtil.damageItem(null, (ItemStack)fishingRod);
                    } else if (rand.m_188500_() < 0.25) {
                        ItemStackUtil.damageItem(null, (ItemStack)fishingRod);
                    } else if (rand.m_188500_() < 0.66 && fishingRod.m_41773_() > 0) {
                        fishingRod.m_41721_(fishingRod.m_41773_() - rand.m_216339_(2, 5));
                    }
                }
            }
        }
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
        }
        return 0;
    }

    static enum Fields {
        REDSTONE;

    }
}

