/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.shapebuilder;

import com.lothrazar.cyclic.block.shapebuilder.BuildStructureType;
import com.lothrazar.cyclic.block.shapebuilder.ContainerStructure;
import com.lothrazar.cyclic.block.shapebuilder.TileStructure;
import com.lothrazar.cyclic.gui.ButtonMachine;
import com.lothrazar.cyclic.gui.ButtonMachineField;
import com.lothrazar.cyclic.gui.GuiSliderInteger;
import com.lothrazar.cyclic.gui.ScreenBase;
import com.lothrazar.cyclic.gui.TextureEnum;
import com.lothrazar.cyclic.net.PacketTileData;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.TextureRegistry;
import com.lothrazar.library.gui.EnergyBar;
import com.lothrazar.library.util.ChatUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;

public class ScreenStructure
extends ScreenBase<ContainerStructure> {
    private EnergyBar energy;
    private List<ButtonMachine> shapeBtuns;
    public ButtonMachineField btnRedstone;
    private ButtonMachineField btnRender;

    public ScreenStructure(ContainerStructure screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
        this.f_97727_ = 256;
    }

    public void m_7856_() {
        super.m_7856_();
        this.energy = new EnergyBar(this.f_96547_, 64000);
        this.energy.guiLeft = this.f_97735_;
        this.energy.guiTop = this.f_97736_;
        int x = this.f_97735_ + 6;
        int y = this.f_97736_ + 6;
        this.btnRedstone = (ButtonMachineField)this.m_142416_((GuiEventListener)new ButtonMachineField(x, y, TileStructure.Fields.REDSTONE.ordinal(), ((ContainerStructure)this.f_97732_).tile.m_58899_()));
        this.btnRender = (ButtonMachineField)this.m_142416_((GuiEventListener)new ButtonMachineField(x + 20, y, TileStructure.Fields.RENDER.ordinal(), ((ContainerStructure)this.f_97732_).tile.m_58899_(), TextureEnum.RENDER_HIDE, TextureEnum.RENDER_SHOW, "gui.cyclic.render"));
        int w = 160;
        int h = 20;
        int f = TileStructure.Fields.HEIGHT.ordinal();
        x = this.f_97735_ + 8;
        y = this.f_97736_ + 82;
        GuiSliderInteger durationslider = (GuiSliderInteger)this.m_142416_((GuiEventListener)new GuiSliderInteger(x, y, w, h, f, ((ContainerStructure)this.f_97732_).tile.m_58899_(), 1, 100, ((ContainerStructure)this.f_97732_).tile.getField(f)));
        durationslider.setTooltip("buildertype.height.tooltip");
        f = TileStructure.Fields.SIZE.ordinal();
        GuiSliderInteger sizeslider = (GuiSliderInteger)this.m_142416_((GuiEventListener)new GuiSliderInteger(x, y += 21, w, h, f, ((ContainerStructure)this.f_97732_).tile.m_58899_(), 1, 64, ((ContainerStructure)this.f_97732_).tile.getField(f)));
        sizeslider.setTooltip("buildertype.size.tooltip");
        TileStructure.Fields fld = TileStructure.Fields.BUILDTYPE;
        int numInRow = 0;
        x = this.f_97735_ + 8;
        y = this.f_97736_ + 40;
        int bsize = 20;
        this.shapeBtuns = new ArrayList<ButtonMachine>();
        for (BuildStructureType shape : BuildStructureType.values()) {
            if (++numInRow == 7) {
                x = this.f_97735_ + 8;
                y += bsize;
            }
            String shapeName = ChatUtil.lang((String)("buildertype." + shape.name().toLowerCase()));
            ButtonMachine btnShape = (ButtonMachine)this.m_142416_((GuiEventListener)new ButtonMachine(x, y, bsize, bsize, shapeName.substring(0, 2), p -> PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(fld.ordinal(), shape.ordinal(), ((ContainerStructure)this.f_97732_).tile.m_58899_()))));
            btnShape.setTooltip(shapeName);
            x += bsize;
            btnShape.setTileField(shape.ordinal());
            this.shapeBtuns.add(btnShape);
        }
    }

    public void m_88315_(GuiGraphics ms, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(ms);
        super.m_88315_(ms, mouseX, mouseY, partialTicks);
        this.m_280072_(ms, mouseX, mouseY);
        this.energy.renderHoveredToolTip(ms, mouseX, mouseY, ((ContainerStructure)this.f_97732_).getEnergy());
    }

    protected void m_280003_(GuiGraphics ms, int mouseX, int mouseY) {
        this.btnRedstone.onValueUpdate(((ContainerStructure)this.f_97732_).tile);
        this.btnRender.onValueUpdate(((ContainerStructure)this.f_97732_).tile);
        this.drawButtonTooltips(ms, mouseX, mouseY);
        this.drawName(ms, this.f_96539_.getString());
        this.updateDisabledButtons();
    }

    private void updateDisabledButtons() {
        int shape = ((ContainerStructure)this.f_97732_).tile.getField(TileStructure.Fields.BUILDTYPE.ordinal());
        for (ButtonMachine b : this.shapeBtuns) {
            b.f_93623_ = b.getTileField() != shape;
        }
    }

    protected void m_7286_(GuiGraphics ms, float partialTicks, int mouseX, int mouseY) {
        this.drawBackground(ms, TextureRegistry.INVENTORY_LARGE_PLAIN);
        this.energy.draw(ms, (float)((ContainerStructure)this.f_97732_).getEnergy());
        this.drawSlot(ms, 60, 20);
        this.drawSlot(ms, 7, 131, TextureRegistry.SLOT_SHAPE, 18);
        this.drawSlot(ms, 151, 131, TextureRegistry.SLOT_GPS, 18);
    }
}

