/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundmuff;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.soundmuff.SoundVolumeControlled;
import com.lothrazar.library.util.BlockstatesUtil;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundmufflerBlock
extends BlockCyclic {
    private static final int VOL_REDUCE_PER_BLOCK = 2;
    public static ForgeConfigSpec.IntValue RADIUS;

    public SoundmufflerBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f).m_60918_(SoundType.f_56756_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (event.getSound() == null || event.getSound() instanceof TickableSoundInstance || clientWorld == null) {
            return;
        }
        SoundInstance sound = event.getSound();
        boolean isPowered = false;
        ArrayList blocks = BlockstatesUtil.findBlocks((Level)clientWorld, (BlockPos)new BlockPos((int)sound.m_7772_(), (int)sound.m_7780_(), (int)sound.m_7778_()), (Block)this, (int)((Integer)RADIUS.get()), (boolean)false);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            float pct = 0.33333334f;
            float newVolume = (float)(Math.min(0.3333333432674408, 1.0) / (double)blocks.size());
            newSound.setVolume(newVolume);
            event.setSound((SoundInstance)newSound);
            ModCyclic.LOGGER.info("sound muffled; size= " + blocks.size());
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error trying to detect volume of sound " + sound, e);
        }
    }
}

