/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundrecord;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.soundrecord.ContainerSoundRecorder;
import com.lothrazar.cyclic.item.datacard.SoundCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.ItemStackHandlerWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileSoundRecorder
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX_SOUNDS = 10;
    private static final String SOUNDAT = "soundat";
    private static final String IGNORED = "ignored";
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ItemRegistry.SOUND_DATA.get();
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(1);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private NonNullList<String> sounds = NonNullList.m_122780_((int)10, (Object)"");
    private List<String> ignored = new ArrayList<String>();

    public TileSoundRecorder(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.SOUND_RECORDER.get(), pos, state);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.SOUND_RECORDER.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerSoundRecorder(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        int i;
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        for (i = 0; i < 10; ++i) {
            if (!tag.m_128441_(SOUNDAT + i)) continue;
            this.sounds.set(i, (Object)tag.m_128461_(SOUNDAT + i));
        }
        for (i = 0; i < 1000; ++i) {
            if (!tag.m_128441_(IGNORED + i)) continue;
            this.ignored.add(tag.m_128461_(IGNORED + i));
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        int i;
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        for (i = 0; i < 10; ++i) {
            tag.m_128359_(SOUNDAT + i, (String)this.sounds.get(i));
        }
        for (i = 0; i < this.ignored.size(); ++i) {
            tag.m_128359_(IGNORED + i, this.ignored.get(i));
        }
        super.m_183515_(tag);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case CLEARALL: {
                this.clearSounds();
                break;
            }
            case IGNORE: {
                this.ignoreSound(value);
                break;
            }
            case SAVE: {
                this.saveSoundToCard(value);
            }
        }
    }

    private void saveSoundToCard(int value) {
        String igme = (String)this.sounds.get(value);
        if (!this.inputSlots.getStackInSlot(0).m_41619_()) {
            SoundCard.saveSound(this.inputSlots.getStackInSlot(0), igme);
        }
    }

    public void ignoreSound(int value) {
        String igme = (String)this.sounds.get(value);
        if (!this.ignored.contains(igme)) {
            this.ignored.add(igme);
        }
        this.sounds.set(value, (Object)"");
    }

    @Override
    public void setFieldString(int field, String value) {
        if (field < 10) {
            this.sounds.set(field, (Object)value);
        }
    }

    @Override
    public String getFieldString(int field) {
        if (field < 10) {
            return (String)this.sounds.get(field);
        }
        return "";
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public void clearSounds() {
        this.sounds = NonNullList.m_122780_((int)10, (Object)"");
    }

    public boolean onSoundHeard(String soundIn) {
        if (soundIn != null && !this.sounds.contains((Object)soundIn) && !this.ignored.contains(soundIn)) {
            int found = -1;
            for (int i = 0; i < 10; ++i) {
                if (!((String)this.sounds.get(i)).isEmpty()) continue;
                found = i;
                break;
            }
            if (found > -1) {
                this.sounds.set(found, (Object)soundIn);
                return true;
            }
        }
        return false;
    }

    static enum Fields {
        CLEARALL,
        IGNORE,
        SAVE;

    }
}

