/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.tank;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.tank.TileTank;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.cap.item.FluidHandlerCapabilityStack;
import com.lothrazar.library.util.ItemStackUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class BlockFluidTank
extends BlockCyclic {
    public static final BooleanProperty TANK_ABOVE = BooleanProperty.m_61465_((String)"above");
    public static final BooleanProperty TANK_BELOW = BooleanProperty.m_61465_((String)"below");

    public BlockFluidTank(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.2f).m_60955_());
        this.setHasFluidInteract();
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player.m_6047_() || player.m_21120_(hand).m_41720_() != this.m_5456_() || hit.m_82434_() != Direction.UP && hit.m_82434_() != Direction.DOWN)) {
            return InteractionResult.PASS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    public float m_7749_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 1.0f;
    }

    public boolean m_6104_(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TANK_ABOVE, TANK_BELOW});
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        boolean tileAbove = world.m_7702_(pos.m_7494_()) instanceof TileTank;
        boolean tileBelow = world.m_7702_(pos.m_7495_()) instanceof TileTank;
        return (BlockState)((BlockState)state.m_61124_((Property)TANK_ABOVE, (Comparable)Boolean.valueOf(tileAbove))).m_61124_((Property)TANK_BELOW, (Comparable)Boolean.valueOf(tileBelow));
    }

    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileTank(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return BlockFluidTank.createTickerHelper(type, (BlockEntityType)((BlockEntityType)TileRegistry.TANK.get()), (BlockEntityTicker)(world.f_46443_ ? TileTank::clientTick : TileTank::serverTick));
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return new ArrayList<ItemStack>();
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        try {
            IFluidHandler storageTile;
            IFluidHandlerItem storage = (IFluidHandlerItem)stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null);
            BlockEntity container = world.m_7702_(pos);
            if (storage != null && container != null && (storageTile = (IFluidHandler)container.getCapability(ForgeCapabilities.FLUID_HANDLER, null).orElse(null)) != null) {
                storageTile.fill(storage.getFluidInTank(0), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error during fill from item ", e);
        }
        state = (BlockState)((BlockState)state.m_61124_((Property)TANK_ABOVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TANK_BELOW, (Comparable)Boolean.valueOf(false));
        world.m_46597_(pos, state);
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, BlockEntity ent, ItemStack stackTool) {
        IFluidHandler fluidInStack;
        super.m_6240_(world, player, pos, state, ent, stackTool);
        ItemStack tankStack = new ItemStack((ItemLike)this);
        if (ent != null && (fluidInStack = (IFluidHandler)tankStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null).orElse(null)) != null && ent instanceof TileTank) {
            TileTank ttank = (TileTank)ent;
            FluidStack fs = ttank.tank.getFluid();
            ((FluidHandlerCapabilityStack)fluidInStack).setFluid(fs);
        }
        ItemStackUtil.dropItemStackMotionless((Level)world, (BlockPos)pos, (ItemStack)tankStack);
    }
}

