/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.redstone;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.wireless.redstone.ContainerTransmit;
import com.lothrazar.cyclic.block.wireless.redstone.TileWirelessRec;
import com.lothrazar.cyclic.data.PreviewOutlineType;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.BlockRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.library.core.BlockPosDim;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessTransmit
extends TileBlockEntityCyclic
implements MenuProvider {
    private static final String REDSTONE_ID = "redstone_id";
    ItemStackHandler inventory = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }
    };
    private UUID id;

    public TileWirelessTransmit(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.WIRELESS_TRANSMITTER.get(), pos, state);
    }

    public Component m_5446_() {
        return ((Block)BlockRegistry.WIRELESS_ITEM.get()).m_49954_();
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerTransmit(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.id = tag.m_128403_(REDSTONE_ID) ? tag.m_128342_(REDSTONE_ID) : UUID.randomUUID();
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        if (this.id == null) {
            this.id = UUID.randomUUID();
        }
        tag.m_128362_(REDSTONE_ID, this.id);
        super.m_183515_(tag);
    }

    private void toggleTarget(BlockPosDim dimPos) {
        BlockPos targetPos = dimPos.getPos();
        ServerLevel serverLevel = dimPos.getTargetLevel(this.f_58857_);
        if (serverLevel == null) {
            ModCyclic.LOGGER.info("Dimension not found " + dimPos.getDimension());
            return;
        }
        if (!serverLevel.m_46749_(targetPos)) {
            ModCyclic.LOGGER.info("DimPos is unloaded" + dimPos);
            return;
        }
        boolean isPowered = this.f_58857_.m_276867_(this.f_58858_);
        BlockEntity blockEntity = serverLevel.m_7702_(targetPos);
        if (blockEntity instanceof TileWirelessRec) {
            TileWirelessRec receiver = (TileWirelessRec)blockEntity;
            if (isPowered) {
                receiver.putPowerSender(this.id);
            } else {
                receiver.removePowerSender(this.id);
            }
        }
        if (this.f_58857_.m_46749_(this.f_58858_) && this.f_58857_.m_8055_(this.f_58858_).m_60734_() == this.m_58900_().m_60734_()) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessTransmit e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessTransmit e) {
    }

    public void tick() {
        for (int s = 0; s < this.inventory.getSlots(); ++s) {
            BlockPosDim targetPos = this.getTargetInSlot(s);
            if (targetPos == null) continue;
            this.toggleTarget(targetPos);
        }
    }

    BlockPosDim getTargetInSlot(int s) {
        ItemStack stack = this.inventory.getStackInSlot(s);
        return LocationGpsCard.getPosition(stack);
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case RENDER: {
                this.render = value % PreviewOutlineType.values().length;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER;

    }
}

