/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.util.HarvestUtil;
import com.lothrazar.library.enchant.EnchantmentFlib;
import com.lothrazar.library.util.ItemStackUtil;
import com.lothrazar.library.util.ShapeUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GrowthEnchant
extends EnchantmentFlib {
    public static final double ODDS_ROTATE = 0.04;
    public static final String ID = "growth";
    public static ForgeConfigSpec.BooleanValue CFG;
    public static ForgeConfigSpec.IntValue RADIUSFACTOR;

    public GrowthEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... slots) {
        super(rarityIn, typeIn, slots);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled() && super.isAllowedOnBooks();
    }

    public boolean m_6081_(ItemStack stack) {
        return this.isEnabled() && super.m_6081_(stack) && stack.m_41720_() instanceof HoeItem;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public int m_6586_() {
        return 3;
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingTickEvent event) {
        Player p;
        if (!this.isEnabled()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && ((p = (Player)entity).m_5833_() || !p.m_6084_())) {
            return;
        }
        int level = this.getCurrentLevelTool(entity.m_21120_(InteractionHand.MAIN_HAND));
        if (level > 0 && !entity.m_9236_().f_46443_) {
            if (entity.m_9236_().f_46441_.m_188500_() > 0.04 / (double)level) {
                return;
            }
            int growthLimit = level * 2 + (entity.m_9236_().m_46471_() ? 4 : 1);
            int grown = 0;
            List shape = ShapeUtil.squareHorizontalFull((BlockPos)entity.m_20183_().m_7495_(), (int)(level + (Integer)RADIUSFACTOR.get()));
            shape = ShapeUtil.repeatShapeByHeight((List)shape, (int)2);
            Collections.shuffle(shape);
            for (int i = 0; i < shape.size() && grown < growthLimit; ++i) {
                BlockPos pos = (BlockPos)shape.get(i);
                BlockState target = entity.m_9236_().m_8055_(pos);
                Block block = target.m_60734_();
                if (block instanceof CropBlock) {
                    CropBlock igrowable = (CropBlock)block;
                    igrowable.m_52263_(entity.m_9236_(), pos, target);
                    ++grown;
                    continue;
                }
                IntegerProperty propAge = HarvestUtil.getAgeProp(target);
                if (propAge == null) continue;
                int maxAge = (Integer)Collections.max(propAge.m_6908_());
                Integer currentAge = (Integer)target.m_61143_((Property)propAge);
                if (currentAge >= maxAge || !entity.m_9236_().m_46597_(pos, (BlockState)target.m_61124_((Property)propAge, (Comparable)Integer.valueOf(currentAge + 1)))) continue;
                ++grown;
            }
            if (grown > 0) {
                ItemStackUtil.damageItem((LivingEntity)entity, (ItemStack)entity.m_21120_(InteractionHand.MAIN_HAND));
            }
        }
    }
}

