/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.internal;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiDebugRendering;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRenderPass;
import com.seibel.distanthorizons.api.enums.rendering.EDhApiRendererMode;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDeferredRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelLoadEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiLevelUnloadEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.logging.SpamReducedLogger;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.renderer.TestRenderer;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.objects.Pair;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.DhClientServerWorld;
import com.seibel.distanthorizons.core.world.DhClientWorld;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.ModInfo;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ClientApi {
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean prefLoggerEnabled = false;
    public static final ClientApi INSTANCE = new ClientApi();
    public static final TestRenderer TEST_RENDERER = new TestRenderer();
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    public static final long SPAM_LOGGER_FLUSH_NS = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
    private boolean configOverrideReminderPrinted = false;
    private boolean lowMemoryWarningPrinted = false;
    private final Queue<String> chatMessageQueueForNextFrame = new LinkedBlockingQueue<String>();
    public boolean rendererDisabledBecauseOfExceptions = false;
    private long lastFlushNanoTime = 0L;
    private boolean isServerCommunicationEnabled = false;
    private boolean serverNetworkingIsMalformed = false;
    public final HashSet<IClientLevelWrapper> waitingClientLevels = new HashSet();
    public final HashMap<Pair<IClientLevelWrapper, DhChunkPos>, IChunkWrapper> waitingChunkByClientLevelAndPos = new HashMap();
    private boolean renderingCancelledForThisFrame;

    private ClientApi() {
    }

    public synchronized void onClientOnlyConnected() {
        boolean connectedToServer = MC.clientConnectedToDedicatedServer();
        boolean connectedToReplay = MC.connectedToReplay();
        if (connectedToServer || connectedToReplay) {
            if (connectedToServer) {
                LOGGER.info("Client on ClientOnly mode connecting.");
            } else {
                LOGGER.info("Replay on ClientServer mode connecting.");
                if (Config.Client.Advanced.Logging.showReplayWarningOnStartup.get().booleanValue()) {
                    MC.sendChatMessage("\u00a76Distant Horizons: Replay detected.\u00a7r");
                    MC.sendChatMessage("DH may behave strangely or have missing functionality.");
                    MC.sendChatMessage("In order to use pre-generated LODs, put your DH database(s) in:");
                    MC.sendChatMessage("\u00a77.Minecraft" + File.separator + "Distant_Horizons_server_data" + File.separator + "REPLAY" + File.separator + "DIMENSION_NAME\u00a7r");
                    MC.sendChatMessage("This can be disabled in DH's config under Advanced -> Logging.");
                    MC.sendChatMessage("");
                }
            }
            SharedApi.setDhWorld(new DhClientWorld());
            LOGGER.info("Loading [" + this.waitingClientLevels.size() + "] waiting client level wrappers.");
            for (IClientLevelWrapper level : this.waitingClientLevels) {
                this.clientLevelLoadEvent(level);
            }
            this.waitingClientLevels.clear();
        }
    }

    public synchronized void onClientOnlyDisconnected() {
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        if (world != null) {
            LOGGER.info("Client on ClientOnly mode disconnecting.");
            world.close();
            SharedApi.setDhWorld(null);
        }
        this.isServerCommunicationEnabled = false;
        this.serverNetworkingIsMalformed = false;
        KEYED_CLIENT_LEVEL_MANAGER.setUseOverrideWrapper(false);
        KEYED_CLIENT_LEVEL_MANAGER.setServerKeyedLevel(null);
        this.waitingChunkByClientLevelAndPos.clear();
        this.waitingClientLevels.clear();
    }

    public void clientLevelUnloadEvent(@Nullable IClientLevelWrapper level) {
        try {
            if (level == null) {
                return;
            }
            LOGGER.info("Unloading client level [" + level + "]-[" + level.getDimensionType().getDimensionName() + "].");
            AbstractDhWorld world = SharedApi.getAbstractDhWorld();
            if (world != null) {
                world.unloadLevel(level);
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelUnloadEvent.class, new DhApiLevelUnloadEvent.EventParam(level));
            } else {
                this.waitingClientLevels.remove(level);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelUnloadEvent(), error: " + e.getMessage(), (Throwable)e);
        }
    }

    public void clientLevelLoadEvent(@Nullable IClientLevelWrapper level) {
        this.clientLevelLoadEvent(level, false);
    }

    public void multiverseClientLevelLoadEvent(@Nullable IClientLevelWrapper level) {
        this.clientLevelLoadEvent(level, true);
    }

    private void clientLevelLoadEvent(@Nullable IClientLevelWrapper level, boolean isServerCommunication) {
        try {
            if (this.isServerCommunicationEnabled && !isServerCommunication) {
                LOGGER.info("Server supports communication, deferring loading.");
                return;
            }
            if (level == null) {
                return;
            }
            LOGGER.info("Loading " + (isServerCommunication ? "Multiverse" : "") + " client level [" + level + "]-[" + level.getDimensionType().getDimensionName() + "].");
            AbstractDhWorld world = SharedApi.getAbstractDhWorld();
            if (world != null) {
                world.getOrLoadLevel(level);
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiLevelLoadEvent.class, new DhApiLevelLoadEvent.EventParam(level));
                this.loadWaitingChunksForLevel(level);
            } else {
                this.waitingClientLevels.add(level);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientLevelLoadEvent(), error: " + e.getMessage(), (Throwable)e);
        }
    }

    private void loadWaitingChunksForLevel(IClientLevelWrapper level) {
        HashSet<Pair<IClientLevelWrapper, DhChunkPos>> keysToRemove = new HashSet<Pair<IClientLevelWrapper, DhChunkPos>>();
        for (Pair<IClientLevelWrapper, DhChunkPos> levelChunkPair : this.waitingChunkByClientLevelAndPos.keySet()) {
            IClientLevelWrapper levelWrapper = (IClientLevelWrapper)levelChunkPair.first;
            if (!levelWrapper.equals(level)) continue;
            IChunkWrapper chunkWrapper = this.waitingChunkByClientLevelAndPos.get(levelChunkPair);
            SharedApi.INSTANCE.chunkLoadEvent(chunkWrapper, levelWrapper);
            keysToRemove.add(levelChunkPair);
        }
        LOGGER.info("Loaded [" + keysToRemove.size() + "] waiting chunk wrappers.");
        for (Pair<IClientLevelWrapper, DhChunkPos> keyToRemove : keysToRemove) {
            this.waitingChunkByClientLevelAndPos.remove(keyToRemove);
        }
    }

    public void rendererShutdownEvent() {
        LOGGER.info("Renderer shutting down.");
        IProfilerWrapper profiler = MC.getProfiler();
        profiler.push("DH-RendererShutdown");
        profiler.pop();
    }

    public void rendererStartupEvent() {
        LOGGER.info("Renderer starting up.");
        IProfilerWrapper profiler = MC.getProfiler();
        profiler.push("DH-RendererStartup");
        GLProxy.getInstance();
        profiler.pop();
    }

    public void clientTickEvent() {
        IProfilerWrapper profiler = MC.getProfiler();
        profiler.push("DH-ClientTick");
        try {
            boolean doFlush;
            boolean bl = doFlush = System.nanoTime() - this.lastFlushNanoTime >= SPAM_LOGGER_FLUSH_NS;
            if (doFlush) {
                this.lastFlushNanoTime = System.nanoTime();
                SpamReducedLogger.flushAll();
            }
            ConfigBasedLogger.updateAll();
            ConfigBasedSpamLogger.updateAll(doFlush);
            IDhClientWorld clientWorld = SharedApi.getIDhClientWorld();
            if (clientWorld != null) {
                clientWorld.clientTick();
                if (!(clientWorld instanceof DhClientServerWorld)) {
                    SharedApi.worldGenTick(clientWorld::doWorldGen);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error in ClientApi.clientTickEvent(), error: " + e.getMessage(), (Throwable)e);
        }
        profiler.pop();
    }

    public void renderLods(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        this.renderLodLayer(levelWrapper, mcModelViewMatrix, mcProjectionMatrix, partialTicks, false);
    }

    public void renderDeferredLods(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks) {
        this.renderLodLayer(levelWrapper, mcModelViewMatrix, mcProjectionMatrix, partialTicks, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLodLayer(IClientLevelWrapper levelWrapper, Mat4f mcModelViewMatrix, Mat4f mcProjectionMatrix, float partialTicks, boolean renderingDeferredLayer) {
        this.sendQueuedChatMessages();
        IProfilerWrapper profiler = MC.getProfiler();
        profiler.pop();
        profiler.push("DH-RenderLevel");
        EDhApiRenderPass renderPass = DhApiRenderProxy.INSTANCE.getDeferTransparentRendering() ? (renderingDeferredLayer ? EDhApiRenderPass.TRANSPARENT : EDhApiRenderPass.OPAQUE) : EDhApiRenderPass.OPAQUE_AND_TRANSPARENT;
        DhApiRenderParam renderEventParam = new DhApiRenderParam(renderPass, partialTicks, RenderUtil.getNearClipPlaneDistanceInBlocks(partialTicks), RenderUtil.getFarClipPlaneDistanceInBlocks(), mcProjectionMatrix, mcModelViewMatrix, RenderUtil.createLodProjectionMatrix(mcProjectionMatrix, partialTicks), RenderUtil.createLodModelViewMatrix(mcModelViewMatrix), levelWrapper.getMinHeight());
        try {
            if (!RenderUtil.shouldLodsRender(levelWrapper)) {
                return;
            }
            IDhClientWorld dhClientWorld = SharedApi.getIDhClientWorld();
            if (dhClientWorld == null) {
                return;
            }
            IDhClientLevel level = dhClientWorld.getOrLoadClientLevel(levelWrapper);
            if (this.rendererDisabledBecauseOfExceptions) {
                return;
            }
            if (!renderingDeferredLayer) {
                if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEFAULT) {
                    this.renderingCancelledForThisFrame = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderEvent.class, renderEventParam);
                    if (!this.renderingCancelledForThisFrame) {
                        level.render(renderEventParam, profiler);
                    }
                    if (!DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                    }
                } else if (Config.Client.Advanced.Debugging.rendererMode.get() == EDhApiRendererMode.DEBUG) {
                    profiler.push("Render Debug");
                    TEST_RENDERER.render();
                    profiler.pop();
                }
            } else {
                boolean renderingCancelled = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDeferredRenderEvent.class, renderEventParam);
                if (!renderingCancelled) {
                    level.renderDeferred(renderEventParam, profiler);
                }
                if (DhApi.Delayed.renderProxy.getDeferTransparentRendering()) {
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterRenderEvent.class, null);
                }
            }
        }
        catch (Exception e) {
            this.rendererDisabledBecauseOfExceptions = true;
            LOGGER.error("Unexpected Renderer error in render pass [" + (Object)((Object)renderPass) + "]. Error: " + e.getMessage(), (Throwable)e);
            MC.sendChatMessage("\u00a74\u00a7l\u00a7uERROR: Distant Horizons renderer has encountered an exception!");
            MC.sendChatMessage("\u00a74Renderer is now disabled to prevent further issues.");
            MC.sendChatMessage("\u00a74Please restart your game to re-enable Distant Horizons' LOD rendering.");
            MC.sendChatMessage("\u00a74Exception detail: " + e);
        }
        finally {
            try {
                GLProxy.getInstance().runRenderThreadTasks();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue running render thread tasks.", (Throwable)e);
            }
            profiler.pop();
            profiler.push("terrain");
        }
    }

    public void keyPressedEvent(int glfwKey) {
        if (!Config.Client.Advanced.Debugging.enableDebugKeybindings.get().booleanValue()) {
            return;
        }
        if (glfwKey == 297) {
            Config.Client.Advanced.Debugging.debugRendering.set(EDhApiDebugRendering.next(Config.Client.Advanced.Debugging.debugRendering.get()));
            MC.sendChatMessage("F8: Set debug mode to " + (Object)((Object)Config.Client.Advanced.Debugging.debugRendering.get()));
        } else if (glfwKey == 295) {
            Config.Client.Advanced.Debugging.rendererMode.set(EDhApiRendererMode.next(Config.Client.Advanced.Debugging.rendererMode.get()));
            MC.sendChatMessage("F6: Set rendering to " + (Object)((Object)Config.Client.Advanced.Debugging.rendererMode.get()));
        } else if (glfwKey == 80) {
            prefLoggerEnabled = !prefLoggerEnabled;
            MC.sendChatMessage("P: Debug Pref Logger is " + (prefLoggerEnabled ? "enabled" : "disabled"));
        }
    }

    private void sendQueuedChatMessages() {
        String message;
        if (ModInfo.IS_DEV_BUILD && !this.configOverrideReminderPrinted && MC.playerExists()) {
            this.configOverrideReminderPrinted = true;
            message = "\u00a72Distant Horizons: nightly/unstable build, version: [2.2.0-a].\u00a7r\nIssues may occur with this version.\nHere be dragons!\n";
            MC.sendChatMessage(message);
        }
        if (!this.lowMemoryWarningPrinted && Config.Client.Advanced.Logging.showLowMemoryWarningOnStartup.get().booleanValue()) {
            this.lowMemoryWarningPrinted = true;
            long minimumRecommendedMemoryInBytes = 4000000000L;
            long maxMemoryInBytes = Runtime.getRuntime().maxMemory();
            if (maxMemoryInBytes < minimumRecommendedMemoryInBytes) {
                String message2 = "\u00a76Distant Horizons: Low memory detected.\u00a7r \nStuttering or low FPS may occur. \nPlease increase Minecraft's available memory to 4 gigabytes. \nThis warning can be disabled in DH's config under Advanced -> Logging. \n";
                MC.sendChatMessage(message2);
            }
        }
        while (!this.chatMessageQueueForNextFrame.isEmpty()) {
            message = this.chatMessageQueueForNextFrame.poll();
            if (message == null) {
                message = "";
            }
            MC.sendChatMessage(message);
        }
    }

    public void showChatMessageNextFrame(String chatMessage) {
        this.chatMessageQueueForNextFrame.add(chatMessage);
    }
}

