/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.render;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnQuadView;
import com.seibel.distanthorizons.core.dataObjects.transformers.FullDataToRenderDataTransformer;
import com.seibel.distanthorizons.core.file.DataSourcePool;
import com.seibel.distanthorizons.core.file.IDataSource;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.Logger;

public class ColumnRenderSource
implements IDataSource<IDhClientLevel> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final boolean DO_SAFETY_CHECKS = ModInfo.IS_DEV_BUILD;
    public static final byte SECTION_SIZE_OFFSET = 6;
    public static final int SECTION_SIZE = BitShiftUtil.powerOfTwo(6);
    public static final DataSourcePool<ColumnRenderSource, IDhClientLevel> DATA_SOURCE_POOL = new DataSourcePool(ColumnRenderSource::createEmptyRenderSource, null);
    public int verticalDataCount;
    public long pos;
    public int yOffset;
    public LongArrayList renderDataContainer;
    public final DebugSourceFlag[] debugSourceFlags;
    private boolean isEmpty = true;
    public AtomicLong localVersion = new AtomicLong(0L);

    public static ColumnRenderSource getPooledRenderSource(long pos, int maxVerticalSize, int yOffset, boolean clearData) {
        ColumnRenderSource renderSource = DATA_SOURCE_POOL.getPooledSource(pos);
        renderSource.pos = pos;
        renderSource.verticalDataCount = maxVerticalSize;
        renderSource.yOffset = yOffset;
        int dataArraySize = SECTION_SIZE * SECTION_SIZE * maxVerticalSize;
        renderSource.renderDataContainer.ensureCapacity(dataArraySize);
        while (renderSource.renderDataContainer.size() < dataArraySize) {
            renderSource.renderDataContainer.add(0L);
        }
        if (clearData) {
            Arrays.fill(renderSource.renderDataContainer.elements(), 0L);
            Arrays.fill((Object[])renderSource.debugSourceFlags, null);
        }
        return renderSource;
    }

    private static ColumnRenderSource createEmptyRenderSource(long sectionPos) {
        return new ColumnRenderSource(sectionPos, 0, 0);
    }

    private ColumnRenderSource(long pos, int maxVerticalSize, int yOffset) {
        this.verticalDataCount = maxVerticalSize;
        this.renderDataContainer = new LongArrayList(new long[SECTION_SIZE * SECTION_SIZE * this.verticalDataCount]);
        this.debugSourceFlags = new DebugSourceFlag[SECTION_SIZE * SECTION_SIZE];
        this.pos = pos;
        this.yOffset = yOffset;
    }

    public long getDataPoint(int posX, int posZ, int verticalIndex) {
        return this.renderDataContainer.getLong(posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount + verticalIndex);
    }

    public ColumnArrayView getVerticalDataPointView(int posX, int posZ) {
        return new ColumnArrayView(this.renderDataContainer, this.verticalDataCount, posX * SECTION_SIZE * this.verticalDataCount + posZ * this.verticalDataCount, this.verticalDataCount);
    }

    public ColumnQuadView getFullQuadView() {
        return this.getQuadViewOverRange(0, 0, SECTION_SIZE, SECTION_SIZE);
    }

    public ColumnQuadView getQuadViewOverRange(int quadX, int quadZ, int quadXSize, int quadZSize) {
        return new ColumnQuadView(this.renderDataContainer, SECTION_SIZE, this.verticalDataCount, quadX, quadZ, quadXSize, quadZSize);
    }

    @Override
    public boolean update(FullDataSourceV2 inputFullDataSource, IDhClientLevel level) {
        String errorMessagePrefix = "Unable to complete update for RenderSource pos: [" + this.pos + "] and pos: [" + inputFullDataSource.getPos() + "]. Error:";
        boolean dataChanged = false;
        if (DhSectionPos.getDetailLevel(inputFullDataSource.getPos()) == DhSectionPos.getDetailLevel(this.pos)) {
            try {
                if (Thread.interrupted()) {
                    LOGGER.warn(errorMessagePrefix + "write interrupted.");
                    return false;
                }
                DhBlockPos2D centerBlockPos = DhSectionPos.getCenterBlockPos(inputFullDataSource.getPos());
                int halfBlockWidth = DhSectionPos.getBlockWidth(inputFullDataSource.getPos()) / 2;
                DhBlockPos2D minBlockPos = new DhBlockPos2D(centerBlockPos.x - halfBlockWidth, centerBlockPos.z - halfBlockWidth);
                for (int x = 0; x < 64; ++x) {
                    for (int z = 0; z < 64; ++z) {
                        ColumnArrayView columnArrayView = this.getVerticalDataPointView(x, z);
                        int columnHash = columnArrayView.getDataHash();
                        LongArrayList dataColumn = inputFullDataSource.get(x, z);
                        EDhApiWorldGenerationStep worldGenStep = inputFullDataSource.getWorldGenStepAtRelativePos(x, z);
                        if (dataColumn == null || worldGenStep == EDhApiWorldGenerationStep.EMPTY) continue;
                        FullDataToRenderDataTransformer.updateOrReplaceRenderDataViewColumnWithFullDataColumn(level, inputFullDataSource.mapping, minBlockPos.x + x, minBlockPos.z + z, columnArrayView, dataColumn);
                        dataChanged |= columnHash != columnArrayView.getDataHash();
                        this.fillDebugFlag(x, z, 1, 1, DebugSourceFlag.DIRECT);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(errorMessagePrefix + e.getMessage(), (Throwable)e);
            }
        }
        if (dataChanged) {
            this.localVersion.incrementAndGet();
            this.markNotEmpty();
        }
        return dataChanged;
    }

    @Override
    public Long getPos() {
        return this.pos;
    }

    @Override
    public Long getKey() {
        return this.pos;
    }

    @Override
    public String getKeyDisplayString() {
        return DhSectionPos.toString(this.pos);
    }

    @Override
    public byte getDataDetailLevel() {
        return (byte)(DhSectionPos.getDetailLevel(this.pos) - 6);
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public void markNotEmpty() {
        this.isEmpty = false;
    }

    public boolean hasNonVoidDataPoints() {
        if (this.isEmpty) {
            return false;
        }
        for (int x = 0; x < SECTION_SIZE; ++x) {
            for (int z = 0; z < SECTION_SIZE; ++z) {
                ColumnArrayView columnArrayView = this.getVerticalDataPointView(x, z);
                for (int i = 0; i < columnArrayView.size; ++i) {
                    long dataPoint = columnArrayView.get(i);
                    if (RenderDataPointUtil.isVoid(dataPoint)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void fillDebugFlag(int xStart, int zStart, int xWidth, int zWidth, DebugSourceFlag flag) {
        for (int x = xStart; x < xStart + xWidth; ++x) {
            for (int z = zStart; z < zStart + zWidth; ++z) {
                this.debugSourceFlags[x * ColumnRenderSource.SECTION_SIZE + z] = flag;
            }
        }
    }

    public DebugSourceFlag debugGetFlag(int ox, int oz) {
        return this.debugSourceFlags[ox * SECTION_SIZE + oz];
    }

    public String toString() {
        String LINE_DELIMITER = "\n";
        String DATA_DELIMITER = " ";
        String SUBDATA_DELIMITER = ",";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DhSectionPos.toString(this.pos));
        stringBuilder.append(LINE_DELIMITER);
        int size = 1;
        for (int z = 0; z < size; ++z) {
            for (int x = 0; x < size; ++x) {
                for (int y = 0; y < this.verticalDataCount; ++y) {
                    stringBuilder.append(Long.toHexString(this.getDataPoint(x, z, y)));
                    if (y == this.verticalDataCount - 1) continue;
                    stringBuilder.append(SUBDATA_DELIMITER);
                }
                if (x == size - 1) continue;
                stringBuilder.append(DATA_DELIMITER);
            }
            if (z == size - 1) continue;
            stringBuilder.append(LINE_DELIMITER);
        }
        return stringBuilder.toString();
    }

    @Override
    public void close() throws Exception {
        DATA_SOURCE_POOL.returnPooledDataSource(this);
    }

    public static enum DebugSourceFlag {
        FULL(ColorUtil.BLUE),
        DIRECT(ColorUtil.WHITE),
        FILE(ColorUtil.BROWN);

        public final int color;

        private DebugSourceFlag(int color) {
            this.color = color;
        }
    }
}

