/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects.transformers;

import com.seibel.distanthorizons.api.enums.config.EDhApiWorldCompressionMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.api.objects.data.DhApiChunk;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class LodDataBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IBlockStateWrapper AIR = SingletonInjector.INSTANCE.get(IWrapperFactory.class).getAirBlockStateWrapper();
    private static boolean getTopErrorLogged = false;

    public static FullDataSourceV2 createGeneratedDataSource(IChunkWrapper chunkWrapper) {
        if (!LodDataBuilder.canGenerateLodFromChunk(chunkWrapper)) {
            return null;
        }
        int sectionPosX = LodDataBuilder.getXOrZSectionPosFromChunkPos(chunkWrapper.getChunkPos().x);
        int sectionPosZ = LodDataBuilder.getXOrZSectionPosFromChunkPos(chunkWrapper.getChunkPos().z);
        long pos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        FullDataSourceV2 dataSource = FullDataSourceV2.createEmpty(pos);
        dataSource.isEmpty = false;
        int chunkOffsetX = chunkWrapper.getChunkPos().x;
        if (chunkWrapper.getChunkPos().x < 0) {
            if ((chunkOffsetX %= 4) != 0) {
                chunkOffsetX += 4;
            }
        } else {
            chunkOffsetX %= 4;
        }
        chunkOffsetX *= 16;
        int chunkOffsetZ = chunkWrapper.getChunkPos().z;
        if (chunkWrapper.getChunkPos().z < 0) {
            if ((chunkOffsetZ %= 4) != 0) {
                chunkOffsetZ += 4;
            }
        } else {
            chunkOffsetZ %= 4;
        }
        chunkOffsetZ *= 16;
        EDhApiWorldCompressionMode worldCompressionMode = Config.Client.Advanced.LodBuilding.worldCompression.get();
        boolean ignoreHiddenBlocks = worldCompressionMode != EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS;
        try {
            int minBuildHeight = chunkWrapper.getMinNonEmptyHeight();
            for (int relBlockX = 0; relBlockX < 16; ++relBlockX) {
                for (int relBlockZ = 0; relBlockZ < 16; ++relBlockZ) {
                    byte skyLight;
                    byte blockLight;
                    LongArrayList longs = new LongArrayList(chunkWrapper.getHeight() / 4);
                    int lastY = chunkWrapper.getMaxBuildHeight();
                    IBiomeWrapper biome = chunkWrapper.getBiome(relBlockX, lastY, relBlockZ);
                    IBlockStateWrapper blockState = AIR;
                    int mappedId = dataSource.mapping.addIfNotPresentAndGetId(biome, blockState);
                    if (lastY < chunkWrapper.getMaxBuildHeight()) {
                        blockLight = (byte)chunkWrapper.getBlockLight(relBlockX, lastY + 1, relBlockZ);
                        skyLight = (byte)chunkWrapper.getSkyLight(relBlockX, lastY + 1, relBlockZ);
                    } else {
                        blockLight = 0;
                        skyLight = 15;
                    }
                    int y = chunkWrapper.getLightBlockingHeightMapValue(relBlockX, relBlockZ);
                    IBlockStateWrapper topBlockState = chunkWrapper.getBlockState(relBlockX, y, relBlockZ);
                    while (!topBlockState.isAir() && y < chunkWrapper.getMaxBuildHeight()) {
                        try {
                            topBlockState = chunkWrapper.getBlockState(relBlockX, ++y, relBlockZ);
                        }
                        catch (Exception e) {
                            if (!getTopErrorLogged) {
                                LOGGER.warn("Unexpected issue in LodDataBuilder, future errors won't be logged. Chunk [" + chunkWrapper.getChunkPos() + "] with max height: [" + chunkWrapper.getMaxBuildHeight() + "] had issue getting block at pos [" + relBlockX + "," + y + "," + relBlockZ + "] error: " + e.getMessage(), (Throwable)e);
                                getTopErrorLogged = true;
                            }
                            --y;
                            break;
                        }
                    }
                    while (y >= minBuildHeight) {
                        IBiomeWrapper newBiome = chunkWrapper.getBiome(relBlockX, y, relBlockZ);
                        IBlockStateWrapper newBlockState = chunkWrapper.getBlockState(relBlockX, y, relBlockZ);
                        byte newBlockLight = (byte)chunkWrapper.getBlockLight(relBlockX, y + 1, relBlockZ);
                        byte newSkyLight = (byte)chunkWrapper.getSkyLight(relBlockX, y + 1, relBlockZ);
                        if (!(newBiome.equals(biome) && newBlockState.equals(blockState) || ignoreHiddenBlocks && !blockState.isAir() && !LodDataBuilder.blockVisible(chunkWrapper, relBlockX, y, relBlockZ))) {
                            longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getMinBuildHeight(), blockLight, skyLight));
                            biome = newBiome;
                            blockState = newBlockState;
                            mappedId = dataSource.mapping.addIfNotPresentAndGetId(biome, blockState);
                            blockLight = newBlockLight;
                            skyLight = newSkyLight;
                            lastY = y;
                        }
                        --y;
                    }
                    longs.add(FullDataPointUtil.encode(mappedId, lastY - y, y + 1 - chunkWrapper.getMinBuildHeight(), blockLight, skyLight));
                    dataSource.setSingleColumn(longs, relBlockX + chunkOffsetX, relBlockZ + chunkOffsetZ, EDhApiWorldGenerationStep.LIGHT, worldCompressionMode);
                }
            }
        }
        catch (DataCorruptedException e) {
            LOGGER.error("Unable to convert chunk at pos [" + chunkWrapper.getChunkPos() + "] to an LOD. Error: " + e.getMessage(), (Throwable)e);
            return null;
        }
        LodUtil.assertTrue(!dataSource.isEmpty);
        return dataSource;
    }

    private static boolean blockVisible(IChunkWrapper chunkWrapper, int relBlockX, int blockY, int relBlockZ) {
        DhBlockPos originalBlockPos = new DhBlockPos(relBlockX, blockY, relBlockZ);
        DhBlockPos testBlockPos = new DhBlockPos(relBlockX, blockY, relBlockZ);
        if (LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.UP, originalBlockPos, testBlockPos)) {
            return true;
        }
        if (LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.DOWN, originalBlockPos, testBlockPos)) {
            return true;
        }
        if (LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.NORTH, originalBlockPos, testBlockPos)) {
            return true;
        }
        if (LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.SOUTH, originalBlockPos, testBlockPos)) {
            return true;
        }
        if (LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.EAST, originalBlockPos, testBlockPos)) {
            return true;
        }
        return LodDataBuilder.blockInDirectionVisible(chunkWrapper, EDhDirection.WEST, originalBlockPos, testBlockPos);
    }

    private static boolean blockInDirectionVisible(IChunkWrapper chunkWrapper, EDhDirection direction, DhBlockPos originalBlockPos, DhBlockPos testBlockPos) {
        originalBlockPos.mutateOffset(direction, testBlockPos);
        if (testBlockPos.x < 0 || testBlockPos.x >= 16) {
            return true;
        }
        if (testBlockPos.z < 0 || testBlockPos.z >= 16) {
            return true;
        }
        if (testBlockPos.y < chunkWrapper.getMinBuildHeight() || testBlockPos.y > chunkWrapper.getMaxBuildHeight()) {
            return true;
        }
        IBlockStateWrapper blockState = chunkWrapper.getBlockState(testBlockPos);
        return blockState.isAir() || blockState.getOpacity() != 16;
    }

    public static FullDataSourceV2 createFromApiChunkData(DhApiChunk apiChunk, boolean runAdditionalValidation) throws ClassCastException, DataCorruptedException, IllegalArgumentException {
        int sectionPosX = LodDataBuilder.getXOrZSectionPosFromChunkPos(apiChunk.chunkPosX);
        int sectionPosZ = LodDataBuilder.getXOrZSectionPosFromChunkPos(apiChunk.chunkPosZ);
        long pos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        int relSourceBlockX = Math.floorMod(apiChunk.chunkPosX, 4) * 16;
        int relSourceBlockZ = Math.floorMod(apiChunk.chunkPosZ, 4) * 16;
        FullDataSourceV2 dataSource = FullDataSourceV2.createEmpty(pos);
        for (int relBlockZ = 0; relBlockZ < 16; ++relBlockZ) {
            for (int relBlockX = 0; relBlockX < 16; ++relBlockX) {
                List<DhApiTerrainDataPoint> columnDataPoints = apiChunk.getDataPoints(relBlockX, relBlockZ);
                if (runAdditionalValidation) {
                    LodDataBuilder.validateOrThrowDataColumn(columnDataPoints);
                }
                int size = columnDataPoints != null ? columnDataPoints.size() : 0;
                LongArrayList packedDataPoints = new LongArrayList(new long[size]);
                for (int index = 0; index < size; ++index) {
                    DhApiTerrainDataPoint dataPoint = columnDataPoints.get(index);
                    int id = dataSource.mapping.addIfNotPresentAndGetId((IBiomeWrapper)dataPoint.biomeWrapper, (IBlockStateWrapper)dataPoint.blockStateWrapper);
                    packedDataPoints.set(index, FullDataPointUtil.encode(id, dataPoint.topYBlockPos - dataPoint.bottomYBlockPos, dataPoint.bottomYBlockPos - apiChunk.bottomYBlockPos, (byte)dataPoint.blockLightLevel, (byte)dataPoint.skyLightLevel));
                }
                dataSource.setSingleColumn(packedDataPoints, relBlockX + relSourceBlockX, relBlockZ + relSourceBlockZ, EDhApiWorldGenerationStep.LIGHT, EDhApiWorldCompressionMode.MERGE_SAME_BLOCKS);
                dataSource.isEmpty = false;
            }
        }
        return dataSource;
    }

    private static void validateOrThrowDataColumn(List<DhApiTerrainDataPoint> dataPoints) throws IllegalArgumentException {
        if (dataPoints.size() > 1) {
            DhApiTerrainDataPoint first = dataPoints.get(0);
            DhApiTerrainDataPoint last = dataPoints.get(dataPoints.size() - 1);
            if (first.bottomYBlockPos < last.bottomYBlockPos) {
                Collections.reverse(dataPoints);
            }
        }
        int lastBottomYPos = Integer.MIN_VALUE;
        for (int i = 0; i < dataPoints.size(); ++i) {
            DhApiTerrainDataPoint dataPoint = dataPoints.get(i);
            if (dataPoint == null) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] is null DhApiTerrainDataPoints are not allowed. If you want to represent empty terrain, please use AIR.");
            }
            if (dataPoint.detailLevel != 0) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] has the wrong detail level [" + dataPoint.detailLevel + "], all data points must be block sized; IE their detail level must be [0].");
            }
            int bottomYPos = dataPoint.bottomYBlockPos;
            int topYPos = dataPoint.topYBlockPos;
            int height = dataPoint.topYBlockPos - dataPoint.bottomYBlockPos;
            if (bottomYPos > topYPos) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] is upside down. Top Pos: [" + topYPos + "], bottom pos: [" + bottomYPos + "].");
            }
            if (height <= 0 || height >= 4096) {
                throw new IllegalArgumentException("Datapoint: [" + i + "] has invalid height. Height must be in the range [1 - " + 4096 + "] (inclusive).");
            }
            if (lastBottomYPos > topYPos) {
                throw new IllegalArgumentException("DhApiTerrainDataPoint [" + i + "] is overlapping with the last datapoint, this top Y: [" + topYPos + "], lastBottomYPos: [" + lastBottomYPos + "].");
            }
            if (topYPos != lastBottomYPos && lastBottomYPos != Integer.MIN_VALUE) {
                throw new IllegalArgumentException("DhApiTerrainDataPoint [" + i + "] has a gap between it and index [" + (i - 1) + "]. Empty spaces should be filled by air, otherwise DH's downsampling won't calculate lighting correctly.");
            }
            lastBottomYPos = bottomYPos;
        }
    }

    public static boolean canGenerateLodFromChunk(IChunkWrapper chunk) {
        return chunk != null && chunk.isLightCorrect();
    }

    public static int getXOrZSectionPosFromChunkPos(int chunkXOrZPos) {
        int sectionPos = chunkXOrZPos;
        sectionPos = sectionPos < 0 ? (sectionPos + 1) / 4 - 1 : sectionPos / 4;
        return sectionPos;
    }
}

