/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.generation;

import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.ArrayList;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class AdjacentChunkHolder {
    final IChunkWrapper[] chunkArray = new IChunkWrapper[9];

    public AdjacentChunkHolder(IChunkWrapper centerWrapper) {
        this.chunkArray[4] = centerWrapper;
    }

    public AdjacentChunkHolder(IChunkWrapper centerWrapper, @NotNull ArrayList<IChunkWrapper> nearbyChunkList) {
        this.chunkArray[4] = centerWrapper;
        DhChunkPos centerChunkPos = centerWrapper.getChunkPos();
        HashSet<DhChunkPos> requestedAdjacentPositions = new HashSet<DhChunkPos>(9);
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                DhChunkPos adjacentPos = new DhChunkPos(centerChunkPos.x + xOffset, centerChunkPos.z + zOffset);
                requestedAdjacentPositions.add(adjacentPos);
            }
        }
        for (int chunkIndex = 0; chunkIndex < nearbyChunkList.size(); ++chunkIndex) {
            IChunkWrapper chunk = nearbyChunkList.get(chunkIndex);
            if (chunk != null && requestedAdjacentPositions.contains(chunk.getChunkPos())) {
                requestedAdjacentPositions.remove(chunk.getChunkPos());
                this.add(chunk);
            }
            if (requestedAdjacentPositions.isEmpty()) break;
        }
    }

    public void add(IChunkWrapper centerWrapper) {
        DhChunkPos centerPos = this.chunkArray[4].getChunkPos();
        DhChunkPos offsetPos = centerWrapper.getChunkPos();
        int offsetX = offsetPos.x - centerPos.x;
        if (offsetX < -1 || offsetX > 1) {
            return;
        }
        int offsetZ = offsetPos.z - centerPos.z;
        if (offsetZ < -1 || offsetZ > 1) {
            return;
        }
        this.chunkArray[4 + offsetX + offsetZ + (offsetZ << 1)] = centerWrapper;
    }

    public IChunkWrapper getByBlockPos(int blockX, int blockZ) {
        int chunkX = BitShiftUtil.divideByPowerOfTwo(blockX, 4);
        int chunkZ = BitShiftUtil.divideByPowerOfTwo(blockZ, 4);
        IChunkWrapper centerChunk = this.chunkArray[4];
        DhChunkPos centerPos = centerChunk.getChunkPos();
        if (centerPos.x == chunkX && centerPos.z == chunkZ) {
            return centerChunk;
        }
        int offsetX = chunkX - centerPos.x;
        if (offsetX < -1 || offsetX > 1) {
            return null;
        }
        int offsetZ = chunkZ - centerPos.z;
        if (offsetZ < -1 || offsetZ > 1) {
            return null;
        }
        return this.chunkArray[4 + offsetX + offsetZ + (offsetZ << 1)];
    }
}

