/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiChunkModifiedEvent;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.DelayedFullDataSourceSaveCache;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.renderer.generic.BeaconRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.CloudRenderHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.dto.ChunkHashDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.sql.repo.ChunkHashRepo;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.io.File;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDhLevel
implements IDhLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    @Nullable
    public ChunkHashRepo chunkHashRepo;
    @Nullable
    public BeaconBeamRepo beaconBeamRepo;
    protected final DelayedFullDataSourceSaveCache delayedFullDataSourceSaveCache = new DelayedFullDataSourceSaveCache(this::onDataSourceSave, 2000);
    protected final ConcurrentHashMap<Long, HashSet<DhChunkPos>> updatedChunkPosSetBySectionPos = new ConcurrentHashMap();
    protected final ConcurrentHashMap<DhChunkPos, Integer> updatedChunkHashesByChunkPos = new ConcurrentHashMap();
    @Nullable
    protected CloudRenderHandler cloudRenderHandler;
    protected BeaconRenderHandler beaconRenderHandler;

    protected AbstractDhLevel() {
    }

    protected void createAndSetSupportingRepos(File databaseFile) {
        ChunkHashRepo newChunkHashRepo = null;
        try {
            newChunkHashRepo = new ChunkHashRepo("jdbc:sqlite", databaseFile);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create [ChunkHashRepo], error: [" + e.getMessage() + "].", (Throwable)e);
        }
        this.chunkHashRepo = newChunkHashRepo;
        BeaconBeamRepo newBeaconBeamRepo = null;
        try {
            newBeaconBeamRepo = new BeaconBeamRepo("jdbc:sqlite", databaseFile);
        }
        catch (SQLException e) {
            LOGGER.error("Unable to create [BeaconBeamRepo], error: [" + e.getMessage() + "].", (Throwable)e);
        }
        this.beaconBeamRepo = newBeaconBeamRepo;
    }

    protected void runRepoReliantSetup() {
        GenericObjectRenderer genericRenderer = this.getGenericRenderer();
        if (genericRenderer != null) {
            if (!this.getLevelWrapper().hasCeiling() && !this.getLevelWrapper().getDimensionType().isTheEnd()) {
                this.cloudRenderHandler = new CloudRenderHandler(this, genericRenderer);
            }
            if (this.beaconBeamRepo != null) {
                this.beaconRenderHandler = new BeaconRenderHandler(this.beaconBeamRepo, genericRenderer);
            }
        }
    }

    @Override
    public int getUnsavedDataSourceCount() {
        return this.delayedFullDataSourceSaveCache.getUnsavedCount();
    }

    @Override
    public void updateChunkAsync(IChunkWrapper chunkWrapper, int chunkHash) {
        FullDataSourceV2 dataSource = FullDataSourceV2.createFromChunk(chunkWrapper);
        if (dataSource == null) {
            return;
        }
        this.updatedChunkPosSetBySectionPos.compute(dataSource.getPos(), (dataSourcePos, chunkPosSet) -> {
            if (chunkPosSet == null) {
                chunkPosSet = new HashSet<DhChunkPos>();
            }
            chunkPosSet.add(chunkWrapper.getChunkPos());
            return chunkPosSet;
        });
        this.updatedChunkHashesByChunkPos.put(chunkWrapper.getChunkPos(), chunkHash);
        this.delayedFullDataSourceSaveCache.queueDataSourceForUpdateAndSave(dataSource);
    }

    private void onDataSourceSave(FullDataSourceV2 fullDataSource) {
        this.updateDataSourcesAsync(fullDataSource).thenRun(() -> {
            HashSet<DhChunkPos> updatedChunkPosSet = this.updatedChunkPosSetBySectionPos.remove(fullDataSource.getPos());
            if (updatedChunkPosSet != null) {
                for (DhChunkPos chunkPos : updatedChunkPosSet) {
                    Integer chunkHash = this.updatedChunkHashesByChunkPos.remove(chunkPos);
                    if (this.chunkHashRepo != null && chunkHash != null) {
                        this.chunkHashRepo.save(new ChunkHashDTO(chunkPos, chunkHash));
                    }
                    ApiEventInjector.INSTANCE.fireAllEvents(DhApiChunkModifiedEvent.class, new DhApiChunkModifiedEvent.EventParam(this.getLevelWrapper(), chunkPos.x, chunkPos.z));
                }
            }
        });
    }

    @Override
    public int getChunkHash(DhChunkPos pos) {
        if (this.chunkHashRepo == null) {
            return 0;
        }
        ChunkHashDTO dto = (ChunkHashDTO)this.chunkHashRepo.getByKey(pos);
        return dto != null ? dto.chunkHash : 0;
    }

    @Override
    public void setBeaconBeamsForChunk(DhChunkPos chunkPos, List<BeaconBeamDTO> newBeamList) {
        if (this.beaconRenderHandler != null) {
            this.beaconRenderHandler.setBeaconBeamsForChunk(chunkPos, newBeamList);
        }
    }

    @Override
    public void loadBeaconBeamsInPos(long pos) {
        if (this.beaconRenderHandler != null) {
            this.beaconRenderHandler.loadBeaconBeamsInPos(pos);
        }
    }

    @Override
    public void unloadBeaconBeamsInPos(long pos) {
        if (this.beaconRenderHandler != null) {
            this.beaconRenderHandler.unloadBeaconBeamsInPos(pos);
        }
    }

    @Override
    public void close() {
        if (this.chunkHashRepo != null) {
            this.chunkHashRepo.close();
        }
        if (this.beaconBeamRepo != null) {
            this.beaconBeamRepo.close();
        }
    }
}

