/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.fullDatafile.RemoteFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.structure.AbstractSaveStructure;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.repo.FullDataSourceV2Repo;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DhClientLevel
extends AbstractDhLevel
implements IDhClientLevel {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public final ClientLevelModule clientside;
    public final IClientLevelWrapper levelWrapper;
    public final AbstractSaveStructure saveStructure;
    public final RemoteFullDataSourceProvider dataFileHandler;

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper) {
        this(saveStructure, clientLevelWrapper, null, true);
    }

    public DhClientLevel(AbstractSaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable File fullDataSaveDirOverride, boolean enableRendering) {
        this.levelWrapper = clientLevelWrapper;
        this.levelWrapper.setParentLevel(this);
        this.saveStructure = saveStructure;
        this.dataFileHandler = new RemoteFullDataSourceProvider(this, saveStructure, fullDataSaveDirOverride);
        this.clientside = new ClientLevelModule(this);
        this.createAndSetSupportingRepos(((FullDataSourceV2Repo)this.dataFileHandler.repo).databaseFile);
        this.runRepoReliantSetup();
        if (enableRendering) {
            this.clientside.startRenderer(clientLevelWrapper);
            LOGGER.info("Started DHLevel for " + this.levelWrapper + " with saves at " + this.saveStructure);
        }
    }

    @Override
    public void clientTick() {
        try {
            this.clientside.clientTick();
        }
        catch (Exception e) {
            LOGGER.error("Unexpected clientTick Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void render(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.render(renderEventParam, profiler);
    }

    @Override
    public void renderDeferred(DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.clientside.renderDeferred(renderEventParam, profiler);
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper block) {
        return this.levelWrapper.getBlockColor(pos, biome, block);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    public ILevelWrapper getLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientside.updateDataSourcesAsync(data);
    }

    @Override
    public int getMinY() {
        return this.levelWrapper.getMinHeight();
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.levelWrapper.getDimensionType().getDimensionName();
        boolean rendering = this.clientside.isRendering();
        messageList.add("[" + dimName + "] rendering: " + (rendering ? "yes" : "no"));
        boolean migrationErrored = this.dataFileHandler.getMigrationStoppedWithError();
        if (!migrationErrored) {
            long migrationCount;
            long legacyDeletionCount = this.dataFileHandler.getLegacyDeletionCount();
            if (legacyDeletionCount > 0L) {
                messageList.add("  Migrating - Deleting #: " + legacyDeletionCount);
            }
            if ((migrationCount = this.dataFileHandler.getTotalMigrationCount()) > 0L) {
                messageList.add("  Migrating - Conversion #: " + migrationCount);
            }
        } else {
            messageList.add("  Migration Failed");
        }
    }

    @Override
    public void close() {
        this.levelWrapper.setParentLevel(null);
        this.clientside.close();
        super.close();
        this.dataFileHandler.close();
        LOGGER.info("Closed [" + DhClientLevel.class.getSimpleName() + "] for [" + this.levelWrapper + "]");
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.dataFileHandler;
    }

    @Override
    public AbstractSaveStructure getSaveStructure() {
        return this.saveStructure;
    }

    @Override
    public boolean hasSkyLight() {
        return this.levelWrapper.hasSkyLight();
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return this.clientside.genericRenderer;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
        return renderState != null ? renderState.renderBufferHandler : null;
    }
}

