/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;

public class DhChunkPos {
    public final int x;
    public final int z;
    public final int hashCode;

    public DhChunkPos(int x, int z) {
        this.x = x;
        this.z = z;
        this.hashCode = this.x * 7309 + this.z;
    }

    public DhChunkPos(DhBlockPos blockPos) {
        this(blockPos.x >> 4, blockPos.z >> 4);
    }

    public DhChunkPos(DhBlockPos2D blockPos) {
        this(blockPos.x >> 4, blockPos.z >> 4);
    }

    public DhChunkPos(long packed) {
        this(DhChunkPos.getXFromPackedLong(packed), DhChunkPos.getZFromPackedLong(packed));
    }

    public DhBlockPos center() {
        return new DhBlockPos(8 + this.x << 4, 0, 8 + this.z << 4);
    }

    public DhBlockPos corner() {
        return new DhBlockPos(this.x << 4, 0, this.z << 4);
    }

    public static long toLong(int x, int z) {
        return ((long)x & 0xFFFFFFFFL) << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static int getXFromPackedLong(long chunkPos) {
        return (int)(chunkPos >> 32);
    }

    private static int getZFromPackedLong(long chunkPos) {
        return (int)(chunkPos & 0xFFFFFFFFL);
    }

    public int getMinBlockX() {
        return this.x << 4;
    }

    public int getMinBlockZ() {
        return this.z << 4;
    }

    public DhBlockPos2D getMinBlockPos() {
        return new DhBlockPos2D(this.x << 4, this.z << 4);
    }

    public boolean contains(DhBlockPos pos) {
        int minBlockX = this.getMinBlockX();
        int minBlockZ = this.getMinBlockZ();
        int maxBlockX = minBlockX + 16;
        int maxBlockZ = minBlockZ + 16;
        return minBlockX <= pos.x && pos.x <= maxBlockX && minBlockZ <= pos.z && pos.z <= maxBlockZ;
    }

    public long getLong() {
        return DhChunkPos.toLong(this.x, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DhChunkPos that = (DhChunkPos)obj;
        return this.x == that.x && this.z == that.z;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "C[" + this.x + "," + this.z + "]";
    }

    public static void _DebugCheckPacker(int x, int z, long expected) {
        long packed = DhChunkPos.toLong(x, z);
        if (packed != expected) {
            throw new IllegalArgumentException("Packed values don't match: " + packed + " != " + expected);
        }
        DhChunkPos pos = new DhChunkPos(packed);
        if (pos.x != x || pos.z != z) {
            throw new IllegalArgumentException("Values after decode don't match: " + pos + " != " + x + ", " + z);
        }
    }

    public static boolean isChunkPosBetween(DhChunkPos minChunkPos, DhChunkPos testPos, DhChunkPos maxChunkPos) {
        int minChunkX = Math.min(minChunkPos.x, maxChunkPos.x);
        int minChunkZ = Math.min(minChunkPos.z, maxChunkPos.z);
        int maxChunkX = Math.max(minChunkPos.x, maxChunkPos.x);
        int maxChunkZ = Math.max(minChunkPos.z, maxChunkPos.z);
        return minChunkX <= testPos.x && testPos.x <= maxChunkX && minChunkZ <= testPos.z && testPos.z <= maxChunkZ;
    }
}

