/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderableBoxGroup;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3d;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBox;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBoxGroupShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.repo.BeaconBeamRepo;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BeaconRenderHandler {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final int BEAM_TOP_Y = 6000;
    private final BeaconBeamRepo beaconBeamRepo;
    private final IDhApiRenderableBoxGroup beaconBoxGroup;
    private final HashSet<DhBlockPos> beaconBlockPosSet = new HashSet();

    public BeaconRenderHandler(@NotNull BeaconBeamRepo beaconBeamRepo, @NotNull GenericObjectRenderer renderer) {
        this.beaconBeamRepo = beaconBeamRepo;
        this.beaconBoxGroup = GenericRenderObjectFactory.INSTANCE.createAbsolutePositionedGroup("DistantHorizons:Beacons", new ArrayList<DhApiRenderableBox>(0));
        this.beaconBoxGroup.setBlockLight(15);
        this.beaconBoxGroup.setSkyLight(15);
        this.beaconBoxGroup.setSsaoEnabled(false);
        this.beaconBoxGroup.setShading(DhApiRenderableBoxGroupShading.getUnshaded());
        this.beaconBoxGroup.setPreRenderFunc(renderEventParam -> this.beaconBoxGroup.setActive(Config.Client.Advanced.Graphics.GenericRendering.enableBeaconRendering.get()));
        renderer.add(this.beaconBoxGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBeaconBeamsForChunk(DhChunkPos chunkPos, List<BeaconBeamDTO> newBeamList) {
        BeaconRenderHandler beaconRenderHandler = this;
        synchronized (beaconRenderHandler) {
            HashSet<DhBlockPos> allPosSet = new HashSet<DhBlockPos>();
            HashMap<DhBlockPos, BeaconBeamDTO> newBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(newBeamList.size());
            for (int i = 0; i < newBeamList.size(); ++i) {
                BeaconBeamDTO beam = newBeamList.get(i);
                newBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(chunkPos);
            HashMap<DhBlockPos, BeaconBeamDTO> existingBeamByPos = new HashMap<DhBlockPos, BeaconBeamDTO>(existingBeamList.size());
            for (int i = 0; i < existingBeamList.size(); ++i) {
                BeaconBeamDTO beam = existingBeamList.get(i);
                existingBeamByPos.put(beam.blockPos, beam);
                allPosSet.add(beam.blockPos);
            }
            for (DhBlockPos beaconPos : allPosSet) {
                if (!chunkPos.contains(beaconPos)) continue;
                BeaconBeamDTO existingBeam = (BeaconBeamDTO)existingBeamByPos.get(beaconPos);
                BeaconBeamDTO newBeam = (BeaconBeamDTO)newBeamByPos.get(beaconPos);
                if (existingBeam != null && newBeam != null) {
                    if (existingBeam.color.equals(newBeam.color)) continue;
                    this.beaconBeamRepo.save(newBeam);
                    this.updateBeaconColor(newBeam);
                    continue;
                }
                if (existingBeam == null && newBeam != null) {
                    this.beaconBeamRepo.save(newBeam);
                    this.startRenderingBeacon(newBeam);
                    continue;
                }
                if (existingBeam == null || newBeam != null) continue;
                this.beaconBeamRepo.deleteWithKey(beaconPos);
                this.stopRenderingBeaconAtPos(beaconPos);
            }
        }
    }

    public void loadBeaconBeamsInPos(long pos) {
        List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(pos);
        for (int i = 0; i < existingBeamList.size(); ++i) {
            BeaconBeamDTO newBeam = existingBeamList.get(i);
            this.startRenderingBeacon(newBeam);
        }
    }

    public void unloadBeaconBeamsInPos(long pos) {
        List<BeaconBeamDTO> existingBeamList = this.beaconBeamRepo.getAllBeamsForPos(pos);
        for (int i = 0; i < existingBeamList.size(); ++i) {
            BeaconBeamDTO beam = existingBeamList.get(i);
            this.stopRenderingBeaconAtPos(beam.blockPos);
        }
    }

    private void startRenderingBeacon(BeaconBeamDTO beacon) {
        if (this.beaconBlockPosSet.add(beacon.blockPos)) {
            DhApiRenderableBox beaconBox = new DhApiRenderableBox(new DhApiVec3d(beacon.blockPos.x, beacon.blockPos.y + 1, beacon.blockPos.z), new DhApiVec3d(beacon.blockPos.x + 1, 6000.0, beacon.blockPos.z + 1), beacon.color, EDhApiBlockMaterial.ILLUMINATED);
            this.beaconBoxGroup.add(beaconBox);
            this.beaconBoxGroup.triggerBoxChange();
        }
    }

    private void stopRenderingBeaconAtPos(DhBlockPos beaconPos) {
        if (this.beaconBlockPosSet.remove(beaconPos)) {
            this.beaconBoxGroup.removeIf(box -> box.minPos.x == (double)beaconPos.x && box.minPos.y == (double)(beaconPos.y + 1) && box.minPos.z == (double)beaconPos.z);
            this.beaconBoxGroup.triggerBoxChange();
        }
    }

    private void updateBeaconColor(BeaconBeamDTO newBeam) {
        DhBlockPos pos = newBeam.blockPos;
        for (int i = 0; i < this.beaconBoxGroup.size(); ++i) {
            DhApiRenderableBox box = (DhApiRenderableBox)this.beaconBoxGroup.get(i);
            if (box.minPos.x != (double)pos.x || box.minPos.y != (double)(pos.y + 1) || box.minPos.z != (double)pos.z) continue;
            box.color = newBeam.color;
            this.beaconBoxGroup.triggerBoxChange();
            break;
        }
    }
}

