/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.shaders;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiFogColorMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.render.fog.LodFogConfig;
import com.seibel.distanthorizons.core.render.glObject.GLState;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.LodRenderer;
import com.seibel.distanthorizons.core.render.renderer.ScreenQuad;
import com.seibel.distanthorizons.core.render.renderer.shaders.AbstractShaderRenderer;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.wrapperInterfaces.IVersionConstants;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.awt.Color;
import org.lwjgl.opengl.GL32;

public class FogShader
extends AbstractShaderRenderer {
    public static FogShader INSTANCE = new FogShader(LodFogConfig.generateFogConfig());
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IVersionConstants VERSION_CONSTANTS = SingletonInjector.INSTANCE.get(IVersionConstants.class);
    public int frameBuffer;
    private final LodFogConfig fogConfig;
    private Mat4f inverseMvmProjMatrix;
    public int uFogColor;
    public int uFogScale;
    public int uFogVerticalScale;
    public int uNearFogStart;
    public int uNearFogLength;
    public int uFullFogMode;
    public int uInvMvmProj;
    public int uDepthMap;

    public FogShader(LodFogConfig fogConfig) {
        this.fogConfig = fogConfig;
    }

    @Override
    public void onInit() {
        this.shader = new ShaderProgram(() -> Shader.loadFile("shaders/normal.vert", false, new StringBuilder()).toString(), () -> this.fogConfig.loadAndProcessFragShader("shaders/fog/fog.frag", false).toString(), "fragColor", new String[]{"vPosition"});
        this.uDepthMap = this.shader.getUniformLocation("uDepthMap");
        this.uInvMvmProj = this.shader.getUniformLocation("uInvMvmProj");
        this.uFogScale = this.shader.tryGetUniformLocation("uFogScale");
        this.uFogVerticalScale = this.shader.tryGetUniformLocation("uFogVerticalScale");
        this.uFogColor = this.shader.tryGetUniformLocation("uFogColor");
        this.uFullFogMode = this.shader.tryGetUniformLocation("uFullFogMode");
        this.uNearFogStart = this.shader.tryGetUniformLocation("uNearFogStart");
        this.uNearFogLength = this.shader.tryGetUniformLocation("uNearFogLength");
    }

    @Override
    protected void onApplyUniforms(float partialTicks) {
        if (this.inverseMvmProjMatrix != null) {
            this.shader.setUniform(this.uInvMvmProj, this.inverseMvmProjMatrix);
        }
        int lodDrawDistance = Config.Client.Advanced.Graphics.Quality.lodChunkRenderDistanceRadius.get() * 16;
        if (this.uFullFogMode != -1) {
            this.shader.setUniform(this.uFullFogMode, MC_RENDER.isFogStateSpecial() ? 1 : 0);
        }
        if (this.uFogColor != -1) {
            this.shader.setUniform(this.uFogColor, MC_RENDER.isFogStateSpecial() ? this.getSpecialFogColor(partialTicks) : this.getFogColor(partialTicks));
        }
        float nearFogStart = (VERSION_CONSTANTS.isVanillaRenderedChunkSquare() ? (float)Math.sqrt(2.0) : 1.0f) / (float)lodDrawDistance;
        if (this.uNearFogStart != -1) {
            this.shader.setUniform(this.uNearFogStart, nearFogStart);
        }
        if (this.uNearFogLength != -1) {
            this.shader.setUniform(this.uNearFogLength, 0.0f);
        }
        if (this.uFogScale != -1) {
            this.shader.setUniform(this.uFogScale, 1.0f / (float)lodDrawDistance);
        }
        if (this.uFogVerticalScale != -1) {
            this.shader.setUniform(this.uFogVerticalScale, 1.0f / (float)MC.getWrappedClientLevel().getMaxHeight());
        }
    }

    private Color getFogColor(float partialTicks) {
        Color fogColor = Config.Client.Advanced.Graphics.Fog.colorMode.get() == EDhApiFogColorMode.USE_SKY_COLOR ? MC_RENDER.getSkyColor() : MC_RENDER.getFogColor(partialTicks);
        return fogColor;
    }

    private Color getSpecialFogColor(float partialTicks) {
        return MC_RENDER.getSpecialFogColor(partialTicks);
    }

    public void setProjectionMatrix(Mat4f projectionMatrix) {
        this.inverseMvmProjMatrix = new Mat4f(projectionMatrix);
        this.inverseMvmProjMatrix.invert();
    }

    @Override
    protected void onRender() {
        GLState state = new GLState();
        GL32.glBindFramebuffer((int)36160, (int)this.frameBuffer);
        GL32.glDisable((int)3089);
        GL32.glDisable((int)2929);
        GL32.glDisable((int)3042);
        GL32.glActiveTexture((int)33984);
        GL32.glBindTexture((int)3553, (int)LodRenderer.getActiveDepthTextureId());
        GL32.glUniform1i((int)this.uDepthMap, (int)0);
        ScreenQuad.INSTANCE.render();
        state.restore();
    }
}

