/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.repo;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.sql.repo.AbstractDhRepo;
import java.awt.Color;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class BeaconBeamRepo
extends AbstractDhRepo<DhBlockPos, BeaconBeamDTO> {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    public BeaconBeamRepo(String databaseType, File databaseFile) throws SQLException {
        super(databaseType, databaseFile, BeaconBeamDTO.class);
    }

    @Override
    public String getTableName() {
        return "BeaconBeam";
    }

    @Override
    public String createWhereStatement(DhBlockPos pos) {
        return "BlockPosX = " + pos.x + " AND BlockPosY = " + pos.y + " AND BlockPosZ = " + pos.z;
    }

    @Override
    public BeaconBeamDTO convertDictionaryToDto(Map<String, Object> objectMap) throws ClassCastException {
        int posX = (Integer)objectMap.get("BlockPosX");
        int posY = (Integer)objectMap.get("BlockPosY");
        int posZ = (Integer)objectMap.get("BlockPosZ");
        int red = (Integer)objectMap.get("ColorR");
        int green = (Integer)objectMap.get("ColorG");
        int blue = (Integer)objectMap.get("ColorB");
        BeaconBeamDTO dto = new BeaconBeamDTO(new DhBlockPos(posX, posY, posZ), new Color(red, green, blue));
        return dto;
    }

    @Override
    public PreparedStatement createInsertStatement(BeaconBeamDTO dto) throws SQLException {
        String sql = "INSERT INTO " + this.getTableName() + " (\n   BlockPosX, BlockPosY, BlockPosZ, \n   ColorR, ColorG, ColorB, \n   LastModifiedUnixDateTime, CreatedUnixDateTime) \nVALUES( \n    ?, ?, ?, \n    ?, ?, ?, \n    ?, ? \n);";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.blockPos.x);
        statement.setObject(i++, dto.blockPos.y);
        statement.setObject(i++, dto.blockPos.z);
        statement.setObject(i++, dto.color.getRed());
        statement.setObject(i++, dto.color.getGreen());
        statement.setObject(i++, dto.color.getBlue());
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, System.currentTimeMillis());
        return statement;
    }

    @Override
    public PreparedStatement createUpdateStatement(BeaconBeamDTO dto) throws SQLException {
        String sql = "UPDATE " + this.getTableName() + " \nSET \n    ColorR = ?, ColorG = ?, ColorB = ?,  \n    LastModifiedUnixDateTime = ? \nWHERE BlockPosX = ? AND BlockPosY = ? AND BlockPosZ = ?";
        PreparedStatement statement = this.createPreparedStatement(sql);
        int i = 1;
        statement.setObject(i++, dto.color.getRed());
        statement.setObject(i++, dto.color.getGreen());
        statement.setObject(i++, dto.color.getBlue());
        statement.setObject(i++, System.currentTimeMillis());
        statement.setObject(i++, dto.blockPos.x);
        statement.setObject(i++, dto.blockPos.y);
        statement.setObject(i++, dto.blockPos.z);
        return statement;
    }

    public List<BeaconBeamDTO> getAllBeamsForPos(DhChunkPos chunkPos) {
        int minBlockX = chunkPos.getMinBlockX();
        int minBlockZ = chunkPos.getMinBlockZ();
        int maxBlockX = minBlockX + 16;
        int maxBlockZ = minBlockZ + 16;
        return this.getAllBeamsInBlockPosRange(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
    }

    public List<BeaconBeamDTO> getAllBeamsForPos(long pos) {
        int minBlockX = DhSectionPos.getMinCornerBlockX(pos);
        int minBlockZ = DhSectionPos.getMinCornerBlockZ(pos);
        int maxBlockX = minBlockX + DhSectionPos.getBlockWidth(pos);
        int maxBlockZ = minBlockZ + DhSectionPos.getBlockWidth(pos);
        return this.getAllBeamsInBlockPosRange(minBlockX, minBlockZ, maxBlockX, maxBlockZ);
    }

    public List<BeaconBeamDTO> getAllBeamsInBlockPosRange(int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        List<Map<String, Object>> objectMapList = this.queryDictionary("SELECT * FROM " + this.getTableName() + " WHERE " + minBlockX + " <= BlockPosX AND BlockPosX <= " + maxBlockX + " AND " + minBlockZ + " <= BlockPosZ AND BlockPosZ <= " + maxBlockZ);
        ArrayList<BeaconBeamDTO> beamList = new ArrayList<BeaconBeamDTO>();
        for (Map<String, Object> objectMap : objectMapList) {
            beamList.add((BeaconBeamDTO)this.convertDictionaryToDto((Map)objectMap));
        }
        return beamList;
    }
}

