/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.wrapperInterfaces.chunk;

import com.seibel.distanthorizons.core.generation.AdjacentChunkHolder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.sql.dto.BeaconBeamDTO;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.ModInfo;
import com.seibel.distanthorizons.coreapi.interfaces.dependencyInjection.IBindable;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public interface IChunkWrapper
extends IBindable {
    public static final boolean RUN_RELATIVE_POS_INDEX_VALIDATION = ModInfo.IS_DEV_BUILD;

    public DhChunkPos getChunkPos();

    default public int getHeight() {
        return this.getMaxBuildHeight() - this.getMinBuildHeight();
    }

    public int getMinBuildHeight();

    public int getMaxBuildHeight();

    public int getMinNonEmptyHeight();

    public int getMaxNonEmptyHeight();

    public int getSolidHeightMapValue(int var1, int var2);

    public int getLightBlockingHeightMapValue(int var1, int var2);

    public int getMaxBlockX();

    public int getMaxBlockZ();

    public int getMinBlockX();

    public int getMinBlockZ();

    public void setIsDhLightCorrect(boolean var1);

    public void setUseDhLighting(boolean var1);

    public boolean isLightCorrect();

    public int getDhSkyLight(int var1, int var2, int var3);

    public void setDhSkyLight(int var1, int var2, int var3, int var4);

    public void clearDhSkyLighting();

    public int getDhBlockLight(int var1, int var2, int var3);

    public void setDhBlockLight(int var1, int var2, int var3, int var4);

    public void clearDhBlockLighting();

    public int getBlockLight(int var1, int var2, int var3);

    public int getSkyLight(int var1, int var2, int var3);

    public ArrayList<DhBlockPos> getBlockLightPosList();

    default public boolean blockPosInsideChunk(DhBlockPos blockPos) {
        return this.blockPosInsideChunk(blockPos.x, blockPos.y, blockPos.z);
    }

    default public boolean blockPosInsideChunk(int x, int y, int z) {
        return x >= this.getMinBlockX() && x <= this.getMaxBlockX() && y >= this.getMinBuildHeight() && y < this.getMaxBuildHeight() && z >= this.getMinBlockZ() && z <= this.getMaxBlockZ();
    }

    default public boolean blockPosInsideChunk(DhBlockPos2D blockPos) {
        return blockPos.x >= this.getMinBlockX() && blockPos.x <= this.getMaxBlockX() && blockPos.z >= this.getMinBlockZ() && blockPos.z <= this.getMaxBlockZ();
    }

    public boolean doNearbyChunksExist();

    public String toString();

    default public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return this.getBlockState(pos.x, pos.y, pos.z);
    }

    public IBlockStateWrapper getBlockState(int var1, int var2, int var3);

    public IBiomeWrapper getBiome(int var1, int var2, int var3);

    public boolean isStillValid();

    default public void throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(int x, int y, int z) throws IndexOutOfBoundsException {
        if (!RUN_RELATIVE_POS_INDEX_VALIDATION) {
            return;
        }
        int minHeight = this.getMinBuildHeight();
        int maxHeight = this.getMaxBuildHeight() + 1;
        if (x < 0 || x >= 16 || z < 0 || z >= 16 || y < minHeight || y > maxHeight) {
            String errorMessage = "Relative position [" + x + "," + y + "," + z + "] out of bounds. \nX/Z must be between 0 and 15 (inclusive) \nY must be between [" + minHeight + "] and [" + maxHeight + "] (inclusive).";
            throw new IndexOutOfBoundsException(errorMessage);
        }
    }

    @Deprecated
    default public boolean bakeDhLightingUsingMcLightingEngine(ILevelWrapper levelWrapper) throws IllegalStateException {
        if (!this.isLightCorrect()) {
            return false;
        }
        boolean lightingFound = false;
        boolean skyLightingFound = !levelWrapper.hasSkyLight();
        for (int relX = 0; relX < 16; ++relX) {
            for (int relZ = 0; relZ < 16; ++relZ) {
                for (int y = this.getMinBuildHeight(); y < this.getMaxBuildHeight(); ++y) {
                    int skyLight = this.getSkyLight(relX, y, relZ);
                    this.setDhSkyLight(relX, y, relZ, skyLight);
                    int blockLight = this.getBlockLight(relX, y, relZ);
                    this.setDhBlockLight(relX, y, relZ, blockLight);
                    if (!(lightingFound || skyLight == 15 && blockLight == 0)) {
                        lightingFound = true;
                    }
                    if (skyLightingFound || skyLight == 0) continue;
                    skyLightingFound = true;
                }
            }
        }
        if (!(lightingFound && skyLightingFound && this.isLightCorrect() && this.getSkyLight(0, 0, 0) == this.getDhSkyLight(0, 0, 0) && this.getBlockLight(0, 0, 0) == this.getDhBlockLight(0, 0, 0))) {
            return false;
        }
        this.setIsDhLightCorrect(true);
        this.setUseDhLighting(true);
        return true;
    }

    default public int relativeBlockPosToIndex(int xRel, int y, int zRel) {
        int yRel = y - this.getMinBuildHeight();
        return zRel * 16 * this.getHeight() + yRel * 16 + xRel;
    }

    default public DhBlockPos indexToRelativeBlockPos(int index) {
        int zRel = index / (16 * this.getHeight());
        int y = (index -= zRel * 16 * this.getHeight()) / 16;
        int yRel = y + this.getMinBuildHeight();
        int xRel = index % 16;
        return new DhBlockPos(xRel, yRel, zRel);
    }

    default public int roughHashCode() {
        int hash = 31;
        int primeMultiplier = 227;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                hash = hash * primeMultiplier + Integer.hashCode(this.getLightBlockingHeightMapValue(x, z));
            }
        }
        return hash;
    }

    default public int getBlockBiomeHashCode() {
        int z;
        int x;
        int hash = 31;
        int primeBlockMultiplier = 227;
        int primeBiomeMultiplier = 701;
        int primeHeightMultiplier = 137;
        int minBuildHeight = this.getMaxNonEmptyHeight();
        int maxBuildHeight = this.getMinNonEmptyHeight();
        for (x = 0; x < 16; x += 2) {
            for (z = 0; z < 16; z += 2) {
                for (int y = minBuildHeight; y < maxBuildHeight; y += 8) {
                    hash = hash * primeBlockMultiplier + this.getBlockState(x, y, z).hashCode();
                    hash = hash * primeBiomeMultiplier + this.getBiome(x, y, z).hashCode();
                    hash = hash * primeHeightMultiplier + y;
                }
            }
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int lightBlockingY = this.getLightBlockingHeightMapValue(x, z);
                hash = hash * primeBlockMultiplier + this.getBlockState(x, lightBlockingY, z).hashCode();
                hash = hash * primeBiomeMultiplier + this.getBiome(x, lightBlockingY, z).hashCode();
                hash = hash * primeHeightMultiplier + lightBlockingY;
                int solidY = this.getSolidHeightMapValue(x, z);
                if (solidY == lightBlockingY) continue;
                hash = hash * primeBlockMultiplier + this.getBlockState(x, solidY, z).hashCode();
                hash = hash * primeBiomeMultiplier + this.getBiome(x, solidY, z).hashCode();
                hash = hash * primeHeightMultiplier + solidY;
            }
        }
        return hash;
    }

    default public List<BeaconBeamDTO> getAllActiveBeacons(ArrayList<IChunkWrapper> neighbourChunkList) {
        ArrayList<BeaconBeamDTO> beaconBeamList = new ArrayList<BeaconBeamDTO>();
        AdjacentChunkHolder adjacentChunkHolder = new AdjacentChunkHolder(this, neighbourChunkList);
        ArrayList<DhBlockPos> blockPosList = this.getBlockLightPosList();
        for (int i = 0; i < blockPosList.size(); ++i) {
            Color beaconColor;
            DhBlockPos pos = blockPosList.get(i);
            DhBlockPos relPos = pos.convertToChunkRelativePos();
            IBlockStateWrapper block = this.getBlockState(relPos);
            if (!block.isBeaconBlock() || (beaconColor = IChunkWrapper.getBeaconColor(pos, adjacentChunkHolder)) == null) continue;
            BeaconBeamDTO beam = new BeaconBeamDTO(blockPosList.get(i), beaconColor);
            beaconBeamList.add(beam);
        }
        return beaconBeamList;
    }

    @Nullable
    public static Color getBeaconColor(DhBlockPos beaconPos, AdjacentChunkHolder chunkHolder) {
        DhBlockPos beaconRelPos = beaconPos.convertToChunkRelativePos();
        DhBlockPos baseRelPos = new DhBlockPos(0, beaconRelPos.y - 1, 0);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                IBlockStateWrapper block;
                baseRelPos.x = beaconRelPos.x + x;
                baseRelPos.z = beaconRelPos.z + z;
                baseRelPos.mutateToChunkRelativePos(baseRelPos);
                IChunkWrapper chunk = chunkHolder.getByBlockPos(beaconPos.x + x, beaconPos.z + z);
                if (chunk == null || (block = chunk.getBlockState(baseRelPos.x, baseRelPos.y, baseRelPos.z)).isBeaconBaseBlock()) continue;
                return null;
            }
        }
        int red = 0;
        int green = 0;
        int blue = 0;
        boolean glassBlockFound = false;
        IChunkWrapper centerChunk = chunkHolder.getByBlockPos(beaconPos.x, beaconPos.z);
        int maxY = centerChunk.getMaxNonEmptyHeight();
        for (int y = beaconRelPos.y + 1; y <= maxY; ++y) {
            IBlockStateWrapper block = centerChunk.getBlockState(beaconRelPos.x, y, beaconRelPos.z);
            if (!block.isAir() && block.getOpacity() == 16) {
                return null;
            }
            if (!block.isGlassBlock() || block.getMapColor().equals(Color.BLACK)) continue;
            red += block.getMapColor().getRed();
            green += block.getMapColor().getGreen();
            blue += block.getMapColor().getBlue();
            if (glassBlockFound) {
                red /= 2;
                green /= 2;
                blue /= 2;
            }
            glassBlockFound = true;
        }
        return glassBlockFound ? new Color(red, green, blue) : Color.WHITE;
    }
}

