/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.fabric.testing;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGeneratorReturnType;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBiomeWrapper;
import com.seibel.distanthorizons.api.interfaces.block.IDhApiBlockStateWrapper;
import com.seibel.distanthorizons.api.interfaces.override.worldGenerator.AbstractDhApiChunkWorldGenerator;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.data.DhApiChunk;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import java.util.ArrayList;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_2338;
import net.minecraft.class_2818;
import net.minecraft.class_3218;

public class TestWorldGenerator
extends AbstractDhApiChunkWorldGenerator {
    private final class_3218 level;
    private final IDhApiLevelWrapper levelWrapper;

    public TestWorldGenerator(class_3218 level) {
        this.level = level;
        this.levelWrapper = ServerLevelWrapper.getWrapper(level);
    }

    @Override
    public EDhApiWorldGeneratorReturnType getReturnType() {
        return EDhApiWorldGeneratorReturnType.API_CHUNKS;
    }

    @Override
    public boolean runApiChunkValidation() {
        return true;
    }

    @Override
    public Object[] generateChunk(int chunkX, int chunkZ, EDhApiDistantGeneratorMode eDhApiDistantGeneratorMode) {
        class_2818 chunk = this.level.method_8497(chunkX, chunkZ);
        return new Object[]{chunk, this.level};
    }

    @Override
    public DhApiChunk generateApiChunk(int chunkPosX, int chunkPosZ, EDhApiDistantGeneratorMode generatorMode) {
        class_2818 chunk = this.level.method_8497(chunkPosX, chunkPosZ);
        int minBuildHeight = this.level.method_31607();
        int maxBuildHeight = this.level.method_31600();
        DhApiChunk apiChunk = DhApiChunk.create(chunkPosX, chunkPosZ, minBuildHeight, maxBuildHeight);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                ArrayList<DhApiTerrainDataPoint> dataPoints = new ArrayList<DhApiTerrainDataPoint>();
                IDhApiBlockStateWrapper block = null;
                IDhApiBiomeWrapper biome = null;
                for (int y = minBuildHeight; y < maxBuildHeight; ++y) {
                    block = DhApi.Delayed.wrapperFactory.getBlockStateWrapper(new Object[]{chunk.method_8320(new class_2338(x, y, z))}, this.levelWrapper);
                    biome = DhApi.Delayed.wrapperFactory.getBiomeWrapper(new Object[]{chunk.method_16359(x, y, z)}, this.levelWrapper);
                    dataPoints.add(DhApiTerrainDataPoint.create((byte)0, 0, 15, y, y + 1, block, biome));
                }
                apiChunk.setDataPoints(x, z, dataPoints);
            }
        }
        return apiChunk;
    }

    @Override
    public void preGeneratorTaskStart() {
    }

    @Override
    public void close() {
    }
}

