/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftSharedWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft.ProfilerWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_128;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class MinecraftClientWrapper
implements IMinecraftClientWrapper,
IMinecraftSharedWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static final class_310 MINECRAFT = class_310.method_1551();
    public static final MinecraftClientWrapper INSTANCE = new MinecraftClientWrapper();
    private class_1011 lightMap = null;
    private ProfilerWrapper profilerWrapper;

    private MinecraftClientWrapper() {
    }

    @Override
    public void clearFrameObjectCache() {
        this.lightMap = null;
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.AdvancedGraphics.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftClientWrapper.MINECRAFT.field_1687 != null) {
                    class_2350 mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftClientWrapper.MINECRAFT.field_1687.method_24852(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }

    @Override
    public boolean hasSinglePlayerServer() {
        return MINECRAFT.method_1496();
    }

    @Override
    public boolean clientConnectedToDedicatedServer() {
        return MINECRAFT.method_1558() != null && !this.hasSinglePlayerServer();
    }

    @Override
    public boolean connectedToReplay() {
        return !MINECRAFT.method_1496() && MINECRAFT.method_1558() == null;
    }

    @Override
    public String getCurrentServerName() {
        if (this.connectedToReplay()) {
            return "REPLAY";
        }
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3752 : "NULL";
    }

    @Override
    public String getCurrentServerIp() {
        if (this.connectedToReplay()) {
            return "";
        }
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3761 : "NA";
    }

    @Override
    public String getCurrentServerVersion() {
        class_642 server = MINECRAFT.method_1558();
        return server != null ? server.field_3760.getString() : "UNKOWN";
    }

    public class_746 getPlayer() {
        return MinecraftClientWrapper.MINECRAFT.field_1724;
    }

    @Override
    public boolean playerExists() {
        return MinecraftClientWrapper.MINECRAFT.field_1724 != null;
    }

    @Override
    public UUID getPlayerUUID() {
        return this.getPlayer().method_5667();
    }

    @Override
    public DhBlockPos getPlayerBlockPos() {
        class_2338 playerPos = this.getPlayer().method_24515();
        return new DhBlockPos(playerPos.method_10263(), playerPos.method_10264(), playerPos.method_10260());
    }

    @Override
    public DhChunkPos getPlayerChunkPos() {
        class_1923 playerPos = this.getPlayer().method_31476();
        return new DhChunkPos(playerPos.field_9181, playerPos.field_9180);
    }

    @Override
    @Nullable
    public IClientLevelWrapper getWrappedClientLevel() {
        if (MinecraftClientWrapper.MINECRAFT.field_1687 == null) {
            return null;
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(MinecraftClientWrapper.MINECRAFT.field_1687);
    }

    @Override
    public IProfilerWrapper getProfiler() {
        if (this.profilerWrapper == null) {
            this.profilerWrapper = new ProfilerWrapper(MINECRAFT.method_16011());
        } else if (MINECRAFT.method_16011() != this.profilerWrapper.profiler) {
            this.profilerWrapper.profiler = MINECRAFT.method_16011();
        }
        return this.profilerWrapper;
    }

    @Override
    public ArrayList<ILevelWrapper> getAllServerWorlds() {
        ArrayList<ILevelWrapper> worlds = new ArrayList<ILevelWrapper>();
        Iterable serverWorlds = MINECRAFT.method_1576().method_3738();
        for (class_3218 world : serverWorlds) {
            worlds.add(ServerLevelWrapper.getWrapper(world));
        }
        return worlds;
    }

    @Override
    public void sendChatMessage(String string) {
        class_746 player = this.getPlayer();
        if (player == null) {
            return;
        }
        player.method_43496((class_2561)class_2561.method_43471((String)string));
    }

    @Override
    public void crashMinecraft(String errorMessage, Throwable exception) {
        LOGGER.error("Distant Horizons had the following error: [" + errorMessage + "]. Crashing Minecraft...", exception);
        class_128 report = new class_128(errorMessage, exception);
        class_310.method_1565((class_128)report);
    }

    @Override
    public Object getOptionsObject() {
        return MinecraftClientWrapper.MINECRAFT.field_1690;
    }

    @Override
    public boolean isDedicatedServer() {
        return false;
    }

    @Override
    public File getInstallationDirectory() {
        return MinecraftClientWrapper.MINECRAFT.field_1697;
    }

    @Override
    public void executeOnRenderThread(Runnable runnable) {
        MINECRAFT.execute(runnable);
    }
}

