/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common;

import com.mojang.brigadier.CommandDispatcher;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterDhInitEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeDhInitEvent;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.config.ConfigBase;
import com.seibel.distanthorizons.core.config.eventHandlers.presets.ThreadPresetConfigEventHandler;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.jar.ModJarInfo;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IModChecker;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import java.util.function.Supplier;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.DependencySetup;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftDedicatedServerWrapper;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import org.apache.logging.log4j.Logger;

public abstract class AbstractModInitializer {
    protected static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private CommandDispatcher<CommandSourceStack> commandDispatcher;

    protected abstract void createInitialBindings();

    protected abstract IEventProxy createClientProxy();

    protected abstract IEventProxy createServerProxy(boolean var1);

    protected abstract void initializeModCompat();

    protected abstract void subscribeRegisterCommandsEvent(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    protected abstract void subscribeClientStartedEvent(Runnable var1);

    protected abstract void subscribeServerStartingEvent(Consumer<MinecraftServer> var1);

    protected abstract void runDelayedSetup();

    public void onInitializeClient() {
        DependencySetup.createClientBindings();
        LOGGER.info("Initializing Distant Horizons");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.printModInfo(true);
        this.createClientProxy().registerEvents();
        this.createServerProxy(false).registerEvents();
        this.initializeModCompat();
        LOGGER.info("Distant Horizons Initialized");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.initConfig();
        this.subscribeClientStartedEvent(this::postInit);
    }

    public void onInitializeServer() {
        DependencySetup.createServerBindings();
        LOGGER.info("Initializing Distant Horizons");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeDhInitEvent.class, null);
        this.startup();
        this.printModInfo(false);
        ThreadPresetConfigEventHandler.INSTANCE.toString();
        this.createServerProxy(true).registerEvents();
        LOGGER.info("Distant Horizons Initialized");
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterDhInitEvent.class, null);
        this.subscribeRegisterCommandsEvent(dispatcher -> {
            this.commandDispatcher = dispatcher;
        });
        this.subscribeServerStartingEvent(server -> {
            MinecraftDedicatedServerWrapper.INSTANCE.dedicatedServer = (DedicatedServer)server;
            this.initConfig();
            this.postInit();
            this.initCommands();
            LOGGER.info("Dedicated server initialized at " + String.valueOf(server.m_6237_()));
        });
    }

    private void startup() {
        DependencySetup.createSharedBindings();
        SharedApi.init();
        this.createInitialBindings();
    }

    private void printModInfo(boolean printGitInfo) {
        LOGGER.info("Distant Horizons, Version: 2.2.0-a");
        if (printGitInfo) {
            LOGGER.info("DH Branch: " + ModJarInfo.Git_Branch);
            LOGGER.info("DH Commit: " + ModJarInfo.Git_Commit);
            LOGGER.info("DH Jar Build Source: " + ModJarInfo.Build_Source);
        }
    }

    protected <T extends IModAccessor> void tryCreateModCompatAccessor(String modId, Class<? super T> accessorClass, Supplier<T> accessorConstructor) {
        IModChecker modChecker = SingletonInjector.INSTANCE.get(IModChecker.class);
        if (modChecker.isModLoaded(modId)) {
            ModAccessorInjector.INSTANCE.bind(accessorClass, (IModAccessor)accessorConstructor.get());
        }
    }

    private void initConfig() {
        ConfigBase.INSTANCE = new ConfigBase("distanthorizons", "DistantHorizons", Config.class, 2);
        Config.completeDelayedSetup();
    }

    private void postInit() {
        LOGGER.info("Post-Initializing Mod");
        this.runDelayedSetup();
        LOGGER.info("Mod Post-Initialized");
    }

    private void initCommands() {
    }

    public static interface IEventProxy {
        public void registerEvents();
    }
}

