/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import java.util.function.LongConsumer;

public class DhSectionPos {
    public static final byte SECTION_MINIMUM_DETAIL_LEVEL = 6;
    public static final byte SECTION_BLOCK_DETAIL_LEVEL = 6;
    public static final byte SECTION_CHUNK_DETAIL_LEVEL = 10;
    public static final byte SECTION_REGION_DETAIL_LEVEL = 15;
    public static final int DETAIL_LEVEL_WIDTH = 8;
    public static final int X_POS_WIDTH = 28;
    public static final int Z_POS_WIDTH = 28;
    public static final int X_POS_MISSING_WIDTH = 4;
    public static final int Z_POS_MISSING_WIDTH = 4;
    public static final int DETAIL_LEVEL_OFFSET = 0;
    public static final int POS_X_OFFSET = 8;
    public static final int POS_Z_OFFSET = 36;
    public static final long DETAIL_LEVEL_MASK = 127L;
    public static final int POS_X_MASK = (int)Math.pow(2.0, 28.0) - 1;
    public static final int POS_Z_MASK = (int)Math.pow(2.0, 28.0) - 1;

    private DhSectionPos() {
    }

    public static long encode(byte detailLevel, int x, int z) {
        long data = 0L;
        data |= (long)detailLevel & 0x7FL;
        data |= (long)(x & POS_X_MASK) << 8;
        return data |= (long)(z & POS_Z_MASK) << 36;
    }

    public static long encodeContaining(byte outputSectionDetailLevel, DhBlockPos pos) {
        int sectionPosX = DhSectionPos.getXOrZSectionPosFromChunkOrBlockPos(pos.getX(), false);
        int sectionPosZ = DhSectionPos.getXOrZSectionPosFromChunkOrBlockPos(pos.getZ(), false);
        long blockPos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        return DhSectionPos.convertToDetailLevel(blockPos, outputSectionDetailLevel);
    }

    public static long encodeContaining(byte outputSectionDetailLevel, DhChunkPos pos) {
        int sectionPosX = DhSectionPos.getXOrZSectionPosFromChunkOrBlockPos(pos.getX(), true);
        int sectionPosZ = DhSectionPos.getXOrZSectionPosFromChunkOrBlockPos(pos.getZ(), true);
        long blockPos = DhSectionPos.encode((byte)6, sectionPosX, sectionPosZ);
        return DhSectionPos.convertToDetailLevel(blockPos, outputSectionDetailLevel);
    }

    private static int getXOrZSectionPosFromChunkOrBlockPos(int chunkXOrZPos, boolean isChunkPos) {
        int sectionPos = chunkXOrZPos;
        int fullDataSourceWidth = isChunkPos ? 4 : 64;
        sectionPos = sectionPos < 0 ? (sectionPos + 1) / fullDataSourceWidth - 1 : sectionPos / fullDataSourceWidth;
        return sectionPos;
    }

    public static long convertToDetailLevel(long pos, byte newDetailLevel) {
        byte detailLevel = DhSectionPos.getDetailLevel(pos);
        int x = DhSectionPos.getX(pos);
        int z = DhSectionPos.getZ(pos);
        if (newDetailLevel >= detailLevel) {
            x = Math.floorDiv(x, BitShiftUtil.powerOfTwo(newDetailLevel - detailLevel));
            z = Math.floorDiv(z, BitShiftUtil.powerOfTwo(newDetailLevel - detailLevel));
        } else {
            x *= BitShiftUtil.powerOfTwo(detailLevel - newDetailLevel);
            z *= BitShiftUtil.powerOfTwo(detailLevel - newDetailLevel);
        }
        return DhSectionPos.encode(newDetailLevel, x, z);
    }

    public static byte getDetailLevel(long pos) {
        return (byte)(pos >> 0 & 0x7FL);
    }

    public static int getX(long pos) {
        int x = (int)(pos >> 8 & (long)POS_X_MASK);
        x = x << 4 >> 4;
        return x;
    }

    public static int getZ(long pos) {
        int Z = (int)(pos >> 36 & (long)POS_Z_MASK);
        Z = Z << 4 >> 4;
        return Z;
    }

    public static int getMinCornerBlockX(long pos) {
        int halfBlockWidth = DhSectionPos.getDetailLevel(pos) != 1 ? DhSectionPos.getBlockWidth(pos) / 2 : 0;
        return DhSectionPos.getCenterBlockPosX(pos) - halfBlockWidth;
    }

    public static int getMinCornerBlockZ(long pos) {
        int halfBlockWidth = DhSectionPos.getDetailLevel(pos) != 1 ? DhSectionPos.getBlockWidth(pos) / 2 : 0;
        return DhSectionPos.getCenterBlockPosZ(pos) - halfBlockWidth;
    }

    public static int getWidthCountForLowerDetailedSection(long pos, byte returnDetailLevel) {
        byte detailLevel = DhSectionPos.getDetailLevel(pos);
        LodUtil.assertTrue(returnDetailLevel <= detailLevel, "returnDetailLevel must be less than sectionDetail");
        byte offset = (byte)(detailLevel - returnDetailLevel);
        return BitShiftUtil.powerOfTwo(offset);
    }

    public static int getBlockWidth(long pos) {
        return BitShiftUtil.powerOfTwo(DhSectionPos.getDetailLevel(pos));
    }

    public static DhBlockPos2D getCenterBlockPos(long pos) {
        return new DhBlockPos2D(DhSectionPos.getCenterBlockPosX(pos), DhSectionPos.getCenterBlockPosZ(pos));
    }

    public static int getCenterBlockPosX(long pos) {
        return DhSectionPos.getCenterBlockPosXOrZ(pos, true);
    }

    public static int getCenterBlockPosZ(long pos) {
        return DhSectionPos.getCenterBlockPosXOrZ(pos, false);
    }

    private static int getCenterBlockPosXOrZ(long pos, boolean returnX) {
        int centerBlockPos;
        byte detailLevel = DhSectionPos.getDetailLevel(pos);
        int x = DhSectionPos.getX(pos);
        int z = DhSectionPos.getZ(pos);
        int n = centerBlockPos = returnX ? x : z;
        if (detailLevel == 0) {
            return centerBlockPos;
        }
        int positionOffset = 0;
        if (detailLevel != 1) {
            positionOffset = BitShiftUtil.powerOfTwo(detailLevel - 1);
        }
        return centerBlockPos * BitShiftUtil.powerOfTwo(detailLevel) + positionOffset;
    }

    public static int getManhattanBlockDistance(long pos, DhBlockPos2D blockPos) {
        return Math.abs(DhSectionPos.getCenterBlockPosX(pos) - blockPos.x) + Math.abs(DhSectionPos.getCenterBlockPosZ(pos) - blockPos.z);
    }

    public static long getChildByIndex(long pos, int child0to3) throws IllegalArgumentException, IllegalStateException {
        byte detailLevel = DhSectionPos.getDetailLevel(pos);
        int x = DhSectionPos.getX(pos);
        int z = DhSectionPos.getZ(pos);
        if (child0to3 < 0 || child0to3 > 3) {
            throw new IllegalArgumentException("child0to3 must be between 0 and 3");
        }
        if (detailLevel <= 0) {
            throw new IllegalStateException("section detail must be greater than 0");
        }
        return DhSectionPos.encode((byte)(detailLevel - 1), x * 2 + (child0to3 & 1), z * 2 + BitShiftUtil.half(child0to3 & 2));
    }

    public static int getChildIndexOfParent(long pos) {
        return (DhSectionPos.getX(pos) & 1) + BitShiftUtil.square(DhSectionPos.getZ(pos) & 1);
    }

    public static long getParentPos(long pos) {
        return DhSectionPos.encode((byte)(DhSectionPos.getDetailLevel(pos) + 1), BitShiftUtil.half(DhSectionPos.getX(pos)), BitShiftUtil.half(DhSectionPos.getZ(pos)));
    }

    public static long getAdjacentPos(long pos, EDhDirection dir) throws IllegalArgumentException {
        if (dir == EDhDirection.UP || dir == EDhDirection.DOWN) {
            throw new IllegalArgumentException("getAdjacentPos can't be UP or DOWN, direction given: [" + dir.name() + "].");
        }
        return DhSectionPos.encode(DhSectionPos.getDetailLevel(pos), DhSectionPos.getX(pos) + dir.getNormal().x, DhSectionPos.getZ(pos) + dir.getNormal().z);
    }

    @Deprecated
    public static DhLodPos getSectionBBoxPos(long pos) {
        return new DhLodPos(DhSectionPos.getDetailLevel(pos), DhSectionPos.getX(pos), DhSectionPos.getZ(pos));
    }

    public static boolean contains(long aPos, long bPos) {
        int aMinX = DhSectionPos.getMinCornerBlockX(aPos);
        int aMinZ = DhSectionPos.getMinCornerBlockZ(aPos);
        int bMinX = DhSectionPos.getMinCornerBlockX(bPos);
        int bMinZ = DhSectionPos.getMinCornerBlockZ(bPos);
        int aBlockWidth = DhSectionPos.getBlockWidth(aPos) - 1;
        int aMaxX = aMinX + aBlockWidth;
        int aMaxZ = aMinZ + aBlockWidth;
        return aMinX <= bMinX && bMinX <= aMaxX && aMinZ <= bMinZ && bMinZ <= aMaxZ;
    }

    public static void forEachChild(long pos, LongConsumer callback) throws IllegalArgumentException, IllegalStateException {
        for (int i = 0; i < 4; ++i) {
            callback.accept(DhSectionPos.getChildByIndex(pos, i));
        }
    }

    public static void forEachChildDownToDetailLevel(long pos, byte minSectionDetailLevel, ICancelablePrimitiveLongConsumer callback) throws IllegalArgumentException, IllegalStateException {
        boolean stop = callback.accept(pos);
        if (stop || minSectionDetailLevel == DhSectionPos.getDetailLevel(pos)) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            DhSectionPos.forEachChildDownToDetailLevel(DhSectionPos.getChildByIndex(pos, i), minSectionDetailLevel, callback);
        }
    }

    public static void forEachChildAtDetailLevel(long pos, byte sectionDetailLevel, LongConsumer callback) throws IllegalArgumentException, IllegalStateException {
        if (sectionDetailLevel == DhSectionPos.getDetailLevel(pos)) {
            callback.accept(pos);
            return;
        }
        for (int i = 0; i < 4; ++i) {
            DhSectionPos.forEachChildAtDetailLevel(DhSectionPos.getChildByIndex(pos, i), sectionDetailLevel, callback);
        }
    }

    public static void forEachPosUpToDetailLevel(long pos, byte maxSectionDetailLevel, LongConsumer callback) {
        callback.accept(pos);
        if (maxSectionDetailLevel == DhSectionPos.getDetailLevel(pos)) {
            return;
        }
        DhSectionPos.forEachPosUpToDetailLevel(DhSectionPos.getParentPos(pos), maxSectionDetailLevel, callback);
    }

    public static String toString(long pos) {
        return DhSectionPos.getDetailLevel(pos) + "*" + DhSectionPos.getX(pos) + "," + DhSectionPos.getZ(pos);
    }

    public static int hashCode(long pos) {
        return Long.hashCode(pos);
    }

    @FunctionalInterface
    public static interface ICancelablePrimitiveLongConsumer {
        public boolean accept(long var1);
    }
}

