/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.config.init;

import io.github.bumblesoftware.fastload.config.init.DefaultConfig;
import io.github.bumblesoftware.fastload.config.init.FLMath;
import io.github.bumblesoftware.fastload.init.FastLoad;
import io.github.bumblesoftware.fastload.util.MinMaxHolder;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class FLConfig {
    private static final Properties properties = new Properties();
    private static final Path path = FabricLoader.getInstance().getConfigDir().resolve("Fastload".toLowerCase() + ".properties");

    public static void loadClass() {
    }

    protected static int getChunkTryLimit() {
        return FLConfig.getInt(DefaultConfig.propertyKeys.tryLimit(), DefaultConfig.getTryLimit(), DefaultConfig.getTryLimitBound());
    }

    protected static int getRawChunkPregenRadius() {
        return FLConfig.getInt(DefaultConfig.propertyKeys.pregen(), DefaultConfig.getPregenRadius(), DefaultConfig.getRawRadiusBound());
    }

    protected static int getRawPreRenderRadius() {
        return FLConfig.getInt(DefaultConfig.propertyKeys.render(), DefaultConfig.getRenderRadius(), DefaultConfig.getRawRadiusBound());
    }

    protected static boolean getCloseLoadingScreenUnsafely() {
        return FLConfig.getBoolean(DefaultConfig.propertyKeys.unsafeClose(), DefaultConfig.getCloseUnsafely());
    }

    protected static boolean getRawDebug() {
        return FLConfig.getBoolean(DefaultConfig.propertyKeys.debug(), DefaultConfig.getDebug());
    }

    private static void logError(String key) {
        FastLoad.LOGGER.error("Failed to parse variable '" + key + "' in Fastload's config, generating a new one!");
    }

    private static void write() {
        try (OutputStream out = Files.newOutputStream(path, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            properties.store(out, "Fastload Configuration File");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (BufferedWriter comment = Files.newBufferedWriter(path, StandardOpenOption.APPEND, StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
            comment.write("\n# Definitions");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.propertyKeys.tryLimit()) + " = how many times in a row should the same count of loaded chunks be ignored before we cancel pre-rendering.");
            comment.write("\n# Min = 1, Max = 1000. Set 1000 for infinity");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.propertyKeys.unsafeClose()) + " = should skip 'Joining World', and 'Downloading Terrain'. Potentially can result in joining world before chunks are properly loaded");
            comment.write("\n# Enabled = true, Disabled = false");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.propertyKeys.debug()) + " = debug (log) all things happening in fastload to aid in diagnosing issues.");
            comment.write("\n# Enabled = true, Disabled = false");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.propertyKeys.render()) + " = how many chunks are loaded until 'building terrain' is completed. Adjusts with FOV to decide how many chunks are visible");
            comment.write("\n# Min = 0, Max = 32 or your render distance, Whichever is smaller. Set 0 to disable.");
            comment.write("\n#");
            comment.write("\n# " + FLConfig.writable(DefaultConfig.propertyKeys.pregen()) + " = how many chunks (from 441 Loading) are pre-generated until the server starts");
            comment.write("\n# Min = 0, Max = 32. Set 0 to only pregen 1 chunk.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String writable(String key) {
        return "'" + key.toLowerCase() + "'";
    }

    private static int getInt(String key, int def, MinMaxHolder holder) {
        try {
            int i = FLMath.parseMinMax(Integer.parseInt(properties.getProperty(key)), holder);
            properties.setProperty(key, String.valueOf(i));
            return i;
        }
        catch (NumberFormatException e) {
            FLConfig.logError(key);
            properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    private static boolean parseBoolean(String string) {
        if (string == null) {
            throw new NumberFormatException("null");
        }
        if (string.trim().equalsIgnoreCase("true")) {
            return true;
        }
        if (string.trim().equalsIgnoreCase("false")) {
            return false;
        }
        throw new NumberFormatException(string);
    }

    private static boolean getBoolean(String key, boolean def) {
        try {
            boolean b = FLConfig.parseBoolean(properties.getProperty(key));
            properties.setProperty(key, String.valueOf(b));
            return b;
        }
        catch (NumberFormatException e) {
            FLConfig.logError(key);
            properties.setProperty(key, String.valueOf(def));
            return def;
        }
    }

    public static void storeProperty(String key, String value) {
        properties.setProperty(key, value);
        System.out.println(key + ":" + value);
    }

    public static void writeToDisk() {
        FLConfig.write();
    }

    static {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(path, StandardOpenOption.CREATE);){
                properties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        FLConfig.getChunkTryLimit();
        FLConfig.getRawChunkPregenRadius();
        FLConfig.getRawPreRenderRadius();
        FLConfig.getCloseLoadingScreenUnsafely();
        FLConfig.getRawDebug();
        FLConfig.write();
    }
}

