/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.config.init;

import io.github.bumblesoftware.fastload.config.init.DefaultConfig;
import io.github.bumblesoftware.fastload.config.init.FLConfig;
import io.github.bumblesoftware.fastload.util.MinMaxHolder;
import java.util.function.Supplier;
import net.minecraft.class_310;

public class FLMath {
    private static final double PI = Math.PI;
    private static final Supplier<Double> RENDER_DISTANCE = () -> class_310.method_1551().field_1769 != null ? Math.min(class_310.method_1551().field_1769.method_34812(), (double)FLMath.getRadiusBoundMax()) : (double)FLMath.getRadiusBoundMax();

    public static int getChunkTryLimit() {
        return FLMath.parseMinMax(FLConfig.getChunkTryLimit(), DefaultConfig.getTryLimitBound());
    }

    public static Boolean getDebug() {
        return FLConfig.getRawDebug();
    }

    public static int getRadiusBoundMax() {
        return DefaultConfig.getRawRadiusBound().max();
    }

    public static MinMaxHolder getRadiusBound() {
        return DefaultConfig.getRawRadiusBound();
    }

    public static MinMaxHolder getChunkTryLimitBound() {
        return DefaultConfig.getTryLimitBound();
    }

    private static int getRenderDistance() {
        return RENDER_DISTANCE.get().intValue();
    }

    protected static int parseMinMax(int toProcess, int max, int min) {
        return Math.max(Math.min(toProcess, max), min);
    }

    protected static int parseMinMax(int toProcess, MinMaxHolder maxMin) {
        return Math.max(Math.min(toProcess, maxMin.max()), maxMin.min());
    }

    private static int getSquareArea(boolean worldProgressTracker, int toCalc, boolean raw) {
        int i = toCalc * 2;
        if (!raw) {
            ++i;
        }
        if (worldProgressTracker) {
            ++i;
            ++i;
        }
        if (i == 0) {
            i = 1;
        }
        return i * i;
    }

    public static Double getCircleArea(int radius) {
        return Math.PI * (double)radius * (double)radius;
    }

    public static Integer getPreRenderRadius() {
        return FLMath.parseMinMax(FLConfig.getRawPreRenderRadius(), Math.min(FLMath.getRenderDistance(), FLMath.getRadiusBoundMax()), 0);
    }

    public static Integer getPreRenderRadius(boolean raw) {
        if (raw) {
            return Math.max(FLConfig.getRawPreRenderRadius(), FLMath.getRadiusBound().min());
        }
        return FLMath.getPreRenderRadius();
    }

    public static int getPregenRadius(boolean raw) {
        if (raw) {
            return FLMath.parseMinMax(FLConfig.getRawChunkPregenRadius(), FLMath.getRadiusBound());
        }
        return FLMath.parseMinMax(FLConfig.getRawChunkPregenRadius(), FLMath.getRadiusBound()) + 1;
    }

    public static int getPregenRadius() {
        return FLMath.getPregenRadius(true);
    }

    public static int getPregenArea() {
        return FLMath.getSquareArea(false, FLMath.parseMinMax(FLMath.getPregenRadius(), FLMath.getRadiusBound().max(), FLMath.getRadiusBound().min()), false);
    }

    public static int getProgressArea() {
        return FLMath.getSquareArea(true, FLMath.parseMinMax(FLMath.getPregenRadius(), FLMath.getRadiusBound().max(), FLMath.getRadiusBound().min()), false);
    }

    public static Integer getPreRenderArea() {
        int i = FLMath.getPreRenderRadius() / 2;
        return FLMath.getCircleArea(FLMath.getPreRenderRadius()).intValue() - i * i;
    }

    public static Boolean getCloseUnsafe() {
        return FLConfig.getCloseLoadingScreenUnsafely();
    }

    public static Boolean getCloseSafe() {
        return FLMath.getPreRenderRadius() > 0;
    }

    public static Boolean getForceLoadSafe() {
        return FLMath.getChunkTryLimit() >= 1000;
    }
}

