/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.init;

import io.github.bumblesoftware.fastload.config.init.DefaultConfig;
import io.github.bumblesoftware.fastload.config.init.FLConfig;
import io.github.bumblesoftware.fastload.config.init.FLMath;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastLoad
implements ModInitializer {
    public static final String NAMESPACE = "Fastload";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Fastload");

    private static String loggableString(String key) {
        return key.toUpperCase() + ": ";
    }

    private static String loggableString(String key, String extra) {
        return key.toUpperCase() + "_" + extra.toUpperCase() + ": ";
    }

    public void onInitialize() {
        FLConfig.loadClass();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.tryLimit()) + FLMath.getChunkTryLimit());
            LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.unsafeClose()) + FLMath.getCloseUnsafe().toString().toUpperCase());
            LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.render(true), "radius") + FLMath.getPreRenderRadius());
            LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.render(true), "area") + FLMath.getPreRenderArea());
        }
        LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.debug()) + FLMath.getDebug().toString().toUpperCase());
        LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.pregen(true), "radius") + FLMath.getPregenRadius(true));
        LOGGER.info(FastLoad.loggableString(DefaultConfig.propertyKeys.pregen(true), "area") + FLMath.getPregenArea());
    }
}

