/*
 * Decompiled with CFR 0.152.
 */
package io.github.bumblesoftware.fastload.mixin.mixins.client;

import io.github.bumblesoftware.fastload.config.init.FLMath;
import io.github.bumblesoftware.fastload.config.screen.BuildingTerrainScreen;
import io.github.bumblesoftware.fastload.mixin.intercomm.client.MinecraftClientMixinInterface;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_4184;
import net.minecraft.class_433;
import net.minecraft.class_434;
import net.minecraft.class_435;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_310.class})
public abstract class MinecraftClientMixin
implements MinecraftClientMixinInterface {
    @Shadow
    private boolean field_1695;
    @Shadow
    private volatile boolean field_1698;
    @Shadow
    @Nullable
    public class_638 field_1687;
    @Shadow
    @Final
    public class_761 field_1769;
    @Shadow
    @Final
    public class_315 field_1690;
    @Shadow
    @Final
    public class_757 field_1773;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    @Final
    private static Logger field_1762;
    private boolean justLoaded = false;
    private boolean shouldLoad = false;
    private boolean playerJoined = false;
    private boolean showRDDOnce = false;
    private boolean isBuilding = false;
    private boolean closeBuild = false;
    private final int chunkTryLimit = FLMath.getChunkTryLimit();
    private Float oldPitch = null;
    private Integer oldChunkLoadedCountStorage = null;
    private Integer oldChunkBuildCountStorage = null;
    private int preparationWarnings = 0;
    private int buildingWarnings = 0;
    private final int timeDownGoal = 10;
    private int timeDown = 10;

    @Shadow
    public void method_1507(@Nullable class_437 screen) {
    }

    @Override
    public void canPlayerLoad() {
        this.shouldLoad = true;
    }

    @Override
    public void gameJoined() {
        this.playerJoined = true;
    }

    private class_4184 getCamera() {
        return this.field_1773.method_19418();
    }

    private static void log(String toLog) {
        field_1762.info(toLog);
    }

    private static void logRenderDistanceDifference() {
        if (!FLMath.getPreRenderRadius().equals(FLMath.getPreRenderRadius(true))) {
            MinecraftClientMixin.log("Pre-rendering radius changed to " + FLMath.getPreRenderRadius() + " from " + FLMath.getPreRenderRadius(true) + " to protect from chunks not loading past your given render distance. To resolve this, please adjust your render distance accordingly");
        }
    }

    private void logPreRendering(int chunkLoadedCount) {
        MinecraftClientMixin.log("Goal (Loaded Chunks): " + FLMath.getPreRenderArea());
        MinecraftClientMixin.log("Loaded Chunks: " + chunkLoadedCount);
    }

    private void logBuilding(int chunkBuildCount, int chunkBuildCountGoal) {
        MinecraftClientMixin.log("Goal (Built Chunks): " + chunkBuildCountGoal);
        MinecraftClientMixin.log("Chunk Build Count: " + chunkBuildCount);
    }

    private void stopBuilding(int chunkLoadedCount, int chunkBuildCount, int chunkBuildCountGoal) {
        if (this.playerJoined) {
            this.closeBuild = true;
            if (FLMath.getDebug().booleanValue()) {
                this.logBuilding(chunkBuildCount, chunkBuildCountGoal);
                this.logPreRendering(chunkLoadedCount);
            }
            this.isBuilding = false;
            if (!this.field_1695) {
                this.timeDown = 0;
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Temporarily Cancelling Pause Menu to enable Renderer");
                }
            }
            assert (this.field_1724 != null);
            if (this.oldPitch != null) {
                this.getCamera().method_19325(this.field_1724.method_36454(), this.oldPitch.floatValue());
                if (this.field_1724.method_36455() != this.oldPitch.floatValue()) {
                    this.field_1724.method_36457(this.oldPitch.floatValue());
                }
                this.oldPitch = null;
            }
            this.playerJoined = false;
            this.oldChunkLoadedCountStorage = 0;
            this.oldChunkBuildCountStorage = 0;
            this.method_1507(null);
        }
    }

    @Inject(method={"setScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void setScreen(class_437 screen, CallbackInfo ci) {
        if (screen == null) {
            this.isBuilding = false;
            this.shouldLoad = false;
            this.justLoaded = false;
            this.showRDDOnce = false;
            this.oldPitch = null;
        }
        if (this.timeDown < 10 && screen instanceof class_433 && !this.field_1695) {
            ci.cancel();
            this.method_1507(null);
        }
        if (screen instanceof BuildingTerrainScreen && FLMath.getDebug().booleanValue()) {
            MinecraftClientMixin.log("Successfully Initiated Building Terrain");
        }
        if (screen instanceof class_435 && FLMath.getCloseUnsafe().booleanValue()) {
            ci.cancel();
            if (FLMath.getDebug().booleanValue()) {
                MinecraftClientMixin.log("Progress Screen Successfully Cancelled");
            }
        }
        if (screen instanceof class_434 && this.shouldLoad && this.playerJoined && this.field_1698) {
            if (FLMath.getDebug().booleanValue()) {
                MinecraftClientMixin.log("Downloading Terrain Accessed!");
            }
            this.shouldLoad = false;
            this.justLoaded = true;
            this.showRDDOnce = true;
            if (FLMath.getCloseSafe().booleanValue()) {
                ci.cancel();
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Preparing to replace Download Terrain with Building Terrain");
                }
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Goal (Loaded Chunks): " + FLMath.getPreRenderArea());
                }
                this.justLoaded = true;
                this.isBuilding = true;
                this.method_1507(new BuildingTerrainScreen());
            } else if (FLMath.getCloseUnsafe().booleanValue()) {
                this.playerJoined = false;
                ci.cancel();
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Successfully Skipped Downloading Terrain Screen!");
                }
                this.timeDown = 0;
                this.method_1507(null);
            }
        }
    }

    @Inject(method={"openPauseMenu"}, at={@At(value="HEAD")}, cancellable=true)
    private void cancelOpenPauseMenu(boolean pause, CallbackInfo ci) {
        if (this.justLoaded) {
            if (this.field_1695) {
                this.justLoaded = false;
            } else if (this.field_1698) {
                this.justLoaded = false;
                ci.cancel();
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Pause Menu Cancelled");
                }
            }
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void onRender(boolean tick, CallbackInfo ci) {
        if (this.showRDDOnce) {
            MinecraftClientMixin.logRenderDistanceDifference();
            this.showRDDOnce = false;
        }
        if (this.isBuilding) {
            if (this.field_1687 != null) {
                assert (this.field_1724 != null);
                if (this.oldPitch == null) {
                    this.oldPitch = Float.valueOf(this.field_1724.method_36455());
                }
                this.field_1724.method_36457(0.0f);
                if (FLMath.getDebug().booleanValue()) {
                    MinecraftClientMixin.log("Pitch:" + this.oldPitch);
                }
                int chunkLoadedCount = this.field_1687.method_2935().method_14151();
                int chunkBuildCount = this.field_1769.method_3246();
                double FOV = ((Integer)this.field_1690.method_41808().method_41753()).intValue();
                double chunkBuildCountGoal = FOV / 360.0 * FLMath.getPreRenderArea().doubleValue();
                int oldPreparationWarningCache = this.preparationWarnings;
                int oldBuildingWarningCache = this.buildingWarnings;
                if (FLMath.getDebug().booleanValue()) {
                    this.logPreRendering(chunkLoadedCount);
                    this.logBuilding(chunkBuildCount, (int)chunkBuildCountGoal);
                }
                if (this.oldChunkLoadedCountStorage != null && this.oldChunkBuildCountStorage != null) {
                    if (this.oldChunkLoadedCountStorage == chunkLoadedCount) {
                        ++this.preparationWarnings;
                    }
                    if (this.oldChunkBuildCountStorage == chunkBuildCount) {
                        ++this.buildingWarnings;
                    }
                    if (!(this.buildingWarnings < this.chunkTryLimit && this.preparationWarnings < this.chunkTryLimit || FLMath.getForceLoadSafe().booleanValue())) {
                        this.buildingWarnings = 0;
                        this.preparationWarnings = 0;
                        MinecraftClientMixin.log("Pre-loading is taking too long! Stopping...");
                        this.stopBuilding(chunkLoadedCount, chunkBuildCount, (int)chunkBuildCountGoal);
                    }
                    if (!this.closeBuild) {
                        int spamLimit = 2;
                        if (this.preparationWarnings > 0) {
                            if (oldPreparationWarningCache == this.preparationWarnings && this.preparationWarnings > 2) {
                                MinecraftClientMixin.log("FL_WARN# Same prepared chunk count returned " + this.preparationWarnings + " time(s) in a row! Had it be " + this.chunkTryLimit + " time(s) in a row, chunk preparation would've stopped");
                                if (FLMath.getDebug().booleanValue()) {
                                    this.logPreRendering(chunkLoadedCount);
                                }
                            }
                            if (chunkLoadedCount > this.oldChunkLoadedCountStorage) {
                                this.preparationWarnings = 0;
                            }
                        }
                        if (this.buildingWarnings > 0) {
                            if (oldBuildingWarningCache == this.buildingWarnings && this.buildingWarnings > 2) {
                                MinecraftClientMixin.log("FL_WARN# Same built chunk count returned " + this.buildingWarnings + " time(s) in a row! Had it be " + this.chunkTryLimit + " time(s) in a row, chunk building would've stopped");
                                if (FLMath.getDebug().booleanValue()) {
                                    this.logPreRendering(chunkLoadedCount);
                                }
                            }
                            if (chunkBuildCount > this.oldChunkBuildCountStorage) {
                                this.buildingWarnings = 0;
                            }
                        }
                    }
                }
                this.oldChunkLoadedCountStorage = chunkLoadedCount;
                this.oldChunkBuildCountStorage = chunkBuildCount;
                if (chunkLoadedCount >= FLMath.getPreRenderArea() && (double)chunkBuildCount >= chunkBuildCountGoal) {
                    this.stopBuilding(chunkLoadedCount, chunkBuildCount, (int)chunkBuildCountGoal);
                    MinecraftClientMixin.log("Successfully pre-loaded the world! Stopping...");
                }
            }
        } else if (this.timeDown < 10) {
            ++this.timeDown;
            if (FLMath.getDebug().booleanValue()) {
                MinecraftClientMixin.log("" + this.timeDown);
            }
        }
    }
}

