/*
 * Decompiled with CFR 0.152.
 */
package glitchcore.forge.mixin.impl;

import glitchcore.network.CustomPacket;
import glitchcore.network.PacketHandler;
import java.util.Optional;
import net.jodah.typetools.TypeResolver;
import net.minecraft.client.Minecraft;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PacketHandler.class}, remap=false)
public abstract class MixinPacketHandler {
    @Unique
    private static final PacketDistributor<ServerGamePacketListenerImpl> HANDLER_DISTRIBUTOR = new PacketDistributor((distributor, handler) -> arg_0 -> ((ServerGamePacketListenerImpl)handler).send(arg_0));
    @Shadow
    @Final
    private ResourceLocation channelName;
    @Unique
    private SimpleChannel channel;

    @Overwrite
    public <T extends CustomPacket<T>> void register(ResourceLocation name, CustomPacket<T> packet) {
        Class dataType = TypeResolver.resolveRawArgument(CustomPacket.class, packet.getClass());
        if (dataType == TypeResolver.Unknown.class) {
            throw new IllegalStateException("Failed to resolve packet data type: " + String.valueOf(packet));
        }
        this.channel.messageBuilder(dataType).encoder(CustomPacket::encode).decoder(packet::decode).consumerMainThread((data, forgeContext) -> {
            forgeContext.enqueueWork(() -> packet.handle(data, new CustomPacket.Context(){
                final /* synthetic */ CustomPayloadEvent.Context val$forgeContext;
                {
                    this.val$forgeContext = context;
                }

                @Override
                public boolean isClientSide() {
                    return this.val$forgeContext.isClientSide();
                }

                @Override
                public Optional<Player> getPlayer() {
                    return Optional.ofNullable(this.val$forgeContext.getSender()).or(() -> this.isClientSide() ? Optional.ofNullable(Minecraft.getInstance().player) : Optional.empty());
                }
            }));
            forgeContext.setPacketHandled(true);
        }).add();
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToPlayer(T data, ServerPlayer player) {
        this.channel.send(data, PacketDistributor.PLAYER.with((Object)player));
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToAll(T packet, MinecraftServer server) {
        this.channel.send(packet, PacketDistributor.ALL.noArg());
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToHandler(T packet, ServerConfigurationPacketListenerImpl handler) {
        Connection connection = handler.getConnection();
        this.channel.send(packet, connection);
    }

    @Overwrite
    public <T extends CustomPacket<T>> void sendToServer(T data) {
        this.channel.send(data, PacketDistributor.SERVER.noArg());
    }

    @Overwrite
    private void init() {
        this.channel = ChannelBuilder.named((ResourceLocation)this.channelName).simpleChannel();
    }
}

