/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import java.util.ArrayList;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.util.Either;

public abstract class ModelAdapter {
    private Either<bau, csn> type;
    private String name;
    private float shadowSize;
    private String[] aliases;

    public ModelAdapter(bau entityType, String name, float shadowSize) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, null);
    }

    public ModelAdapter(bau entityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeLeft((Object)entityType), name, shadowSize, aliases);
    }

    public ModelAdapter(csn tileEntityType, String name, float shadowSize) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, null);
    }

    public ModelAdapter(csn tileEntityType, String name, float shadowSize, String[] aliases) {
        this(Either.makeRight((Object)tileEntityType), name, shadowSize, aliases);
    }

    public ModelAdapter(Either<bau, csn> type, String name, float shadowSize, String[] aliases) {
        this.type = type;
        this.name = name;
        this.shadowSize = shadowSize;
        this.aliases = aliases;
    }

    public Either<bau, csn> getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public float getShadowSize() {
        return this.shadowSize;
    }

    public abstract eqw makeModel();

    public abstract esv getModelRenderer(eqw var1, String var2);

    public abstract String[] getModelRendererNames();

    public abstract IEntityRenderer makeEntityRender(eqw var1, float var2);

    public boolean setTextureLocation(IEntityRenderer er, aaj textureLocation) {
        return false;
    }

    public esv[] getModelRenderers(eqw model) {
        String[] names = this.getModelRendererNames();
        ArrayList<esv> list = new ArrayList<esv>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            String name = names[i2];
            esv mr = this.getModelRenderer(model, name);
            if (mr == null) continue;
            list.add(mr);
        }
        esv[] mrs = list.toArray(new esv[list.size()]);
        return mrs;
    }

    public static esv bakeModelLayer(est loc) {
        return eev.G().ae().getContext().a(loc);
    }
}

