/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.config;

import java.util.function.ObjIntConsumer;
import java.util.function.ToIntFunction;
import net.optifine.Config;
import net.optifine.Lang;
import net.optifine.config.IPersitentOption;
import net.optifine.config.IteratableOptionOF;
import net.optifine.config.OptionValueInt;

public class IterableOptionInt
extends IteratableOptionOF
implements IPersitentOption {
    private String resourceKey;
    private OptionValueInt[] values;
    private ToIntFunction<fgs> getter;
    private ObjIntConsumer<fgs> setter;
    private String saveKey;

    public IterableOptionInt(String resourceKey, OptionValueInt[] values, ToIntFunction<fgs> getter, ObjIntConsumer<fgs> setter, String saveKey) {
        super(resourceKey);
        this.resourceKey = resourceKey;
        this.values = values;
        this.getter = getter;
        this.setter = setter;
        this.saveKey = saveKey;
    }

    public void nextOptionValue(int dirIn) {
        fgs opts = this.getOptions();
        int value = this.getter.applyAsInt(opts);
        int index = this.getValueIndex(value);
        int indexNext = index + dirIn;
        if (indexNext < this.getIndexMin() || indexNext > this.getIndexMax()) {
            indexNext = dirIn > 0 ? this.getIndexMin() : this.getIndexMax();
        }
        int valueNext = this.values[indexNext].getValue();
        this.setter.accept(opts, valueNext);
    }

    public wz getOptionText() {
        fgs opts = this.getOptions();
        String optionLabel = Lang.get((String)this.resourceKey) + ": ";
        int value = this.getter.applyAsInt(opts);
        OptionValueInt optionValue = this.getOptionValue(value);
        if (optionValue == null) {
            return wz.b((String)(optionLabel + "???"));
        }
        String valueLabel = Lang.get((String)optionValue.getResourceKey());
        String label = optionLabel + valueLabel;
        xn comp = wz.b((String)label);
        return comp;
    }

    public String getSaveKey() {
        return this.saveKey;
    }

    public void loadValue(fgs opts, String s) {
        int val = Config.parseInt((String)s, (int)-1);
        if (this.getOptionValue(val) == null) {
            val = this.values[0].getValue();
        }
        this.setter.accept(opts, val);
    }

    public String getSaveText(fgs opts) {
        int value = this.getter.applyAsInt(opts);
        return Integer.toString(value);
    }

    private OptionValueInt getOptionValue(int value) {
        int index = this.getValueIndex(value);
        if (index < 0) {
            return null;
        }
        return this.values[index];
    }

    private int getValueIndex(int value) {
        for (int i = 0; i < this.values.length; ++i) {
            OptionValueInt ovi = this.values[i];
            if (ovi.getValue() != value) continue;
            return i;
        }
        return -1;
    }

    private int getIndexMin() {
        return 0;
    }

    private int getIndexMax() {
        return this.values.length - 1;
    }
}

