/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;
import net.optifine.IRandomEntity;
import net.optifine.Log;
import net.optifine.RandomEntities;
import net.optifine.RandomEntityContext;
import net.optifine.RandomEntityProperties;
import net.optifine.entity.model.CustomEntityModelParser;
import net.optifine.entity.model.CustomEntityRenderer;
import net.optifine.entity.model.CustomModelRegistry;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.IEntityRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.RendererCache;
import net.optifine.entity.model.VirtualEntityRenderer;
import net.optifine.entity.model.anim.IModelRendererVariable;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IModelVariable;
import net.optifine.entity.model.anim.ModelResolver;
import net.optifine.entity.model.anim.ModelUpdater;
import net.optifine.entity.model.anim.ModelVariableUpdater;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.Either;
import net.optifine.util.StrUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomEntityModels {
    private static boolean active = false;
    private static Map<bsx, RandomEntityProperties<IEntityRenderer>> mapEntityProperties = new HashMap();
    private static Map<dqj, RandomEntityProperties<IEntityRenderer>> mapBlockEntityProperties = new HashMap();
    private static int matchingRuleIndex;
    private static Map<bsx, gki> originalEntityRenderMap;
    private static Map<dqj, ggz> originalTileEntityRenderMap;
    private static Map<dnb.a, fxh> originalSkullModelMap;
    private static List<dqj> customTileEntityTypes;
    private static fus customBookModel;
    private static boolean debugModels;
    public static final String PREFIX_OPTIFINE_CEM = "optifine/cem/";
    public static final String SUFFIX_JEM = ".jem";
    public static final String SUFFIX_PROPERTIES = ".properties";

    public static void update() {
        Map entityRenderMap = CustomEntityModels.getEntityRenderMap();
        Map tileEntityRenderMap = CustomEntityModels.getTileEntityRenderMap();
        Map skullModelMap = CustomEntityModels.getSkullModelMap();
        if (entityRenderMap == null) {
            Config.warn((String)"Entity render map not found, custom entity models are DISABLED.");
            return;
        }
        if (tileEntityRenderMap == null) {
            Config.warn((String)"Tile entity render map not found, custom entity models are DISABLED.");
            return;
        }
        active = false;
        entityRenderMap.clear();
        tileEntityRenderMap.clear();
        skullModelMap.clear();
        customTileEntityTypes.clear();
        entityRenderMap.putAll(originalEntityRenderMap);
        tileEntityRenderMap.putAll(originalTileEntityRenderMap);
        skullModelMap.putAll(originalSkullModelMap);
        gem blockEntityRenderer = fgo.Q().ar().getBlockEntityRenderer();
        blockEntityRenderer.k = new fxp(ModelAdapter.bakeModelLayer((fyi)fyj.bJ));
        blockEntityRenderer.j = new fxb(ModelAdapter.bakeModelLayer((fyi)fyj.bk));
        gos.customParrotModel = null;
        customBookModel = null;
        ggz.CACHED_TYPES.clear();
        if (fgo.Q().r != null) {
            Iterable entities = fgo.Q().r.e();
            for (bsr entity : entities) {
                Map modelVariables = entity.ar().modelVariables;
                if (modelVariables == null) continue;
                modelVariables.clear();
            }
        }
        mapEntityProperties.clear();
        mapBlockEntityProperties.clear();
        if (!Config.isCustomEntityModels()) {
            return;
        }
        RandomEntityContext.Models context = new RandomEntityContext.Models();
        RendererCache rendererCache = context.getRendererCache();
        akr[] locs = CustomEntityModels.getModelLocations();
        for (int i = 0; i < locs.length; ++i) {
            akr loc = locs[i];
            Config.dbg((String)("CustomEntityModel: " + loc.a()));
            IEntityRenderer rc = CustomEntityModels.parseEntityRender((akr)loc, (RendererCache)rendererCache, (int)0);
            if (rc == null) continue;
            Either type = rc.getType();
            if (rc instanceof gki) {
                glw pr;
                fwk pm;
                gmw tr;
                fxp tm;
                entityRenderMap.put((bsx)type.getLeft().get(), (gki)rc);
                rendererCache.put((bsx)type.getLeft().get(), 0, (gki)rc);
                if (rc instanceof gmw && (tm = (fxp)Reflector.getFieldValue((Object)(tr = (gmw)rc), (ReflectorField)Reflector.RenderTrident_modelTrident)) != null) {
                    blockEntityRenderer.k = tm;
                }
                if (rc instanceof glw && (pm = (fwk)(pr = (glw)rc).a()) != null) {
                    gos.customParrotModel = pm;
                }
            } else if (rc instanceof ggz) {
                tileEntityRenderMap.put((dqj)type.getRight().get(), (ggz)rc);
                rendererCache.put((dqj)type.getRight().get(), 0, (ggz)rc);
                if (rc instanceof ghi) {
                    ghi etr = (ghi)rc;
                    fus bm = (fus)Reflector.getFieldValue((Object)etr, (ReflectorField)Reflector.TileEntityEnchantmentTableRenderer_modelBook);
                    CustomEntityModels.setEnchantmentScreenBookModel((fus)bm);
                }
                customTileEntityTypes.add((dqj)type.getRight().get());
            } else if (rc instanceof VirtualEntityRenderer) {
                VirtualEntityRenderer ver = (VirtualEntityRenderer)rc;
                if (ver.getModel() instanceof fxb) {
                    fxb sm;
                    blockEntityRenderer.j = sm = (fxb)ver.getModel();
                }
            } else {
                Config.warn((String)("Unknown renderer type: " + rc.getClass().getName()));
                continue;
            }
            active = true;
        }
        CustomEntityModels.updateRandomProperties((RandomEntityContext.Models)context);
    }

    private static void updateRandomProperties(RandomEntityContext.Models context) {
        String[] prefixes = new String[]{"optifine/cem/"};
        String[] suffixes = new String[]{".jem", ".properties"};
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
            Either type = modelAdapter.getType();
            RandomEntityProperties props = CustomEntityModels.makeProperties((String)name, (RandomEntityContext.Models)context);
            if (props == null) {
                props = CustomEntityModels.makeProperties((String)(name + "/" + name), (RandomEntityContext.Models)context);
            }
            if (props == null) continue;
            if (type != null && type.getLeft().isPresent()) {
                mapEntityProperties.put((bsx)type.getLeft().get(), props);
            }
            if (type == null || !type.getRight().isPresent()) continue;
            mapBlockEntityProperties.put((dqj)type.getRight().get(), props);
        }
    }

    private static RandomEntityProperties makeProperties(String name, RandomEntityContext.Models context) {
        RandomEntityProperties props;
        akr locJem = new akr("optifine/cem/" + name + ".jem");
        akr locProps = new akr("optifine/cem/" + name + ".properties");
        if (Config.hasResource((akr)locProps) && (props = RandomEntityProperties.parse((akr)locProps, (akr)locJem, (RandomEntityContext)context)) != null) {
            return props;
        }
        if (!Config.hasResource((akr)locJem)) {
            return null;
        }
        int[] variants = RandomEntities.getLocationsVariants((akr)locJem, (boolean)false, (RandomEntityContext)context);
        if (variants == null) {
            return null;
        }
        RandomEntityProperties props2 = new RandomEntityProperties(locJem.a(), locJem, variants, (RandomEntityContext)context);
        if (!props2.isValid(locJem.a())) {
            return null;
        }
        return props2;
    }

    private static void setEnchantmentScreenBookModel(fus bookModel) {
        customBookModel = bookModel;
    }

    private static Map<bsx, gki> getEntityRenderMap() {
        gkh rm = fgo.Q().ap();
        Map entityRenderMap = rm.getEntityRenderMap();
        if (entityRenderMap == null) {
            return null;
        }
        if (originalEntityRenderMap == null) {
            originalEntityRenderMap = new HashMap(entityRenderMap);
        }
        return entityRenderMap;
    }

    private static Map<dqj, ggz> getTileEntityRenderMap() {
        ggy blockEntityRenderDispatcher = fgo.Q().aq();
        Map tileEntityRenderMap = blockEntityRenderDispatcher.getBlockEntityRenderMap();
        if (originalTileEntityRenderMap == null) {
            originalTileEntityRenderMap = new HashMap(tileEntityRenderMap);
        }
        return tileEntityRenderMap;
    }

    private static Map<dnb.a, fxh> getSkullModelMap() {
        HashMap skullModelMap = gho.models;
        if (skullModelMap == null) {
            Config.warn((String)"Field not found: SkullBlockRenderer.MODELS");
            skullModelMap = new HashMap();
        }
        if (originalSkullModelMap == null) {
            originalSkullModelMap = new HashMap(skullModelMap);
        }
        return skullModelMap;
    }

    private static akr[] getModelLocations() {
        String prefix = "optifine/cem/";
        String suffix = ".jem";
        ArrayList<akr> resourceLocations = new ArrayList<akr>();
        String[] names = CustomModelRegistry.getModelNames();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String path = prefix + name + suffix;
            akr loc = new akr(path);
            if (!Config.hasResource((akr)loc) && !debugModels) continue;
            resourceLocations.add(loc);
        }
        akr[] locs = resourceLocations.toArray(new akr[resourceLocations.size()]);
        return locs;
    }

    public static IEntityRenderer parseEntityRender(akr location, RendererCache rendererCache, int index) {
        try {
            if (debugModels && index == 0) {
                return CustomEntityModels.makeDebugEntityRenderer((akr)location, (RendererCache)rendererCache, (int)index);
            }
            JsonObject jo2 = CustomEntityModelParser.loadJson((akr)location);
            IEntityRenderer render = CustomEntityModels.parseEntityRender((JsonObject)jo2, (String)location.a(), (RendererCache)rendererCache, (int)index);
            return render;
        }
        catch (IOException e2) {
            Config.error((String)(e2.getClass().getName() + ": " + e2.getMessage()));
            return null;
        }
        catch (JsonParseException e3) {
            Config.error((String)(((Object)((Object)e3)).getClass().getName() + ": " + e3.getMessage()));
            return null;
        }
        catch (Exception e4) {
            Log.warn((String)("Error loading CEM: " + String.valueOf(location)), (Throwable)e4);
            return null;
        }
    }

    private static IEntityRenderer makeDebugEntityRenderer(akr loc, RendererCache rendererCache, int index) {
        String path = loc.a();
        String nameJem = StrUtils.removePrefix((String)path, (String)"optifine/cem/");
        String name = StrUtils.removeSuffix((String)nameJem, (String)".jem");
        ModelAdapter ma = CustomModelRegistry.getModelAdapter((String)name);
        fwg model = ma.makeModel();
        cti[] colors = cti.values();
        int offset = Math.abs(loc.hashCode()) % 256;
        String[] partNames = ma.getModelRendererNames();
        for (int i = 0; i < partNames.length; ++i) {
            String partName = partNames[i];
            fyk part = ma.getModelRenderer(model, partName);
            if (part == null) continue;
            cti col = colors[(i + offset) % colors.length];
            akr locTexture = new akr("textures/block/" + col.c() + "_stained_glass.png");
            part.setTextureLocation(locTexture);
            Config.dbg((String)("  " + partName + ": " + col.c()));
        }
        IEntityRenderer er = ma.makeEntityRender(model, ma.getShadowSize(), rendererCache, index);
        if (er == null) {
            return null;
        }
        er.setType(ma.getType());
        return er;
    }

    private static IEntityRenderer parseEntityRender(JsonObject obj, String path, RendererCache rendererCache, int index) {
        CustomEntityRenderer cer = CustomEntityModelParser.parseEntityRender((JsonObject)obj, (String)path);
        String name = cer.getName();
        name = StrUtils.trimTrailing((String)name, (String)"0123456789");
        ModelAdapter modelAdapter = CustomModelRegistry.getModelAdapter((String)name);
        CustomEntityModels.checkNull((Object)modelAdapter, (String)("Entity not found: " + name));
        Either type = modelAdapter.getType();
        IEntityRenderer render = CustomEntityModels.makeEntityRender((ModelAdapter)modelAdapter, (CustomEntityRenderer)cer, (RendererCache)rendererCache, (int)index);
        if (render == null) {
            return null;
        }
        render.setType(type);
        return render;
    }

    private static IEntityRenderer makeEntityRender(ModelAdapter modelAdapter, CustomEntityRenderer cer, RendererCache rendererCache, int index) {
        fwg model;
        akr textureLocation = cer.getTextureLocation();
        CustomModelRenderer[] modelRenderers = cer.getCustomModelRenderers();
        float shadowSize = cer.getShadowSize();
        if (shadowSize < 0.0f) {
            shadowSize = modelAdapter.getShadowSize();
        }
        if ((model = modelAdapter.makeModel()) == null) {
            return null;
        }
        ModelResolver mr = new ModelResolver(modelAdapter, model, modelRenderers);
        if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fwg)model, (CustomModelRenderer[])modelRenderers, (ModelResolver)mr)) {
            return null;
        }
        IEntityRenderer r = modelAdapter.makeEntityRender(model, shadowSize, rendererCache, index);
        if (r == null) {
            throw new JsonParseException("Entity renderer is null, model: " + modelAdapter.getName() + ", adapter: " + modelAdapter.getClass().getName());
        }
        if (textureLocation != null) {
            CustomEntityModels.setTextureLocation((ModelAdapter)modelAdapter, (fwg)model, (IEntityRenderer)r, (akr)textureLocation);
        }
        return r;
    }

    private static void setTextureLocation(ModelAdapter modelAdapter, fwg model, IEntityRenderer er, akr textureLocation) {
        if (modelAdapter.setTextureLocation(er, textureLocation)) {
            return;
        }
        if (er instanceof glk) {
            er.setLocationTextureCustom(textureLocation);
            return;
        }
        CustomEntityModels.setTextureTopModelRenderers((ModelAdapter)modelAdapter, (fwg)model, (akr)textureLocation);
    }

    public static void setTextureTopModelRenderers(ModelAdapter modelAdapter, fwg model, akr textureLocation) {
        String[] parts = modelAdapter.getModelRendererNames();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            fyk modelRenderer = modelAdapter.getModelRenderer(model, part);
            if (modelRenderer == null || modelRenderer.getTextureLocation() != null) continue;
            modelRenderer.setTextureLocation(textureLocation);
        }
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fwg model, CustomModelRenderer[] modelRenderers, ModelResolver mr) {
        int i;
        ArrayList<ModelVariableUpdater> listVariableUpdaters = new ArrayList<ModelVariableUpdater>();
        for (int i2 = 0; i2 < modelRenderers.length; ++i2) {
            CustomModelRenderer cmr = modelRenderers[i2];
            if (!CustomEntityModels.modifyModel((ModelAdapter)modelAdapter, (fwg)model, (CustomModelRenderer)cmr, (ModelResolver)mr)) {
                return false;
            }
            if (cmr.getModelRenderer().getModelUpdater() == null) continue;
            listVariableUpdaters.addAll(Arrays.asList(cmr.getModelRenderer().getModelUpdater().getModelVariableUpdaters()));
        }
        ModelVariableUpdater[] mvus = listVariableUpdaters.toArray(new ModelVariableUpdater[listVariableUpdaters.size()]);
        ModelUpdater globvalUpdater = new ModelUpdater(mvus);
        for (i = 0; i < modelRenderers.length; ++i) {
            CustomModelRenderer cmr = modelRenderers[i];
            if (cmr.getModelRenderer().getModelUpdater() == null) continue;
            cmr.getModelRenderer().setModelUpdater(globvalUpdater);
        }
        for (i = 0; i < mvus.length; ++i) {
            ModelVariableUpdater mvu = mvus[i];
            IModelVariable mv = mvu.getModelVariable();
            if (!(mv instanceof IModelRendererVariable)) continue;
            IModelRendererVariable mrv = (IModelRendererVariable)mv;
            mrv.getModelRenderer().setModelUpdater(globvalUpdater);
        }
        return true;
    }

    private static boolean modifyModel(ModelAdapter modelAdapter, fwg model, CustomModelRenderer customModelRenderer, ModelResolver modelResolver) {
        String modelPart = customModelRenderer.getModelPart();
        fyk parent = modelAdapter.getModelRenderer(model, modelPart);
        if (parent == null) {
            Config.warn((String)("Model part not found: " + modelPart + ", model: " + String.valueOf(model)));
            return false;
        }
        if (!customModelRenderer.isAttach()) {
            if (parent.m != null) {
                parent.m.clear();
            }
            if (parent.spriteList != null) {
                parent.spriteList.clear();
            }
            if (parent.n != null) {
                fyk[] mrs = modelAdapter.getModelRenderers(model);
                Set setMrs = Collections.newSetFromMap(new IdentityHashMap());
                setMrs.addAll(Arrays.asList(mrs));
                HashSet childModelKeys = new HashSet(parent.n.keySet());
                for (String key : childModelKeys) {
                    fyk mr = (fyk)parent.n.get(key);
                    if (setMrs.contains(mr)) continue;
                    parent.n.remove(key);
                }
            }
        }
        String childName = parent.getUniqueChildModelName("CEM-" + modelPart);
        parent.addChildModel(childName, customModelRenderer.getModelRenderer());
        ModelUpdater mu = customModelRenderer.getModelUpdater();
        if (mu != null) {
            modelResolver.setThisModelRenderer(customModelRenderer.getModelRenderer());
            modelResolver.setPartModelRenderer(parent);
            if (!mu.initialize((IModelResolver)modelResolver)) {
                return false;
            }
            customModelRenderer.getModelRenderer().setModelUpdater(mu);
        }
        return true;
    }

    private static void checkNull(Object obj, String msg) {
        if (obj == null) {
            throw new JsonParseException(msg);
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static boolean isCustomModel(dtc blockStateIn) {
        for (int i = 0; i < customTileEntityTypes.size(); ++i) {
            dqj type = (dqj)customTileEntityTypes.get(i);
            if (!type.a(blockStateIn)) continue;
            return true;
        }
        return false;
    }

    public static void onRenderScreen(fod screen) {
        if (customBookModel != null && screen instanceof fpn) {
            fpn es = (fpn)screen;
            Reflector.GuiEnchantment_bookModel.setValue((Object)es, (Object)customBookModel);
        }
    }

    public static gki getEntityRenderer(bsr entityIn, gki renderer) {
        if (mapEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomEntity((bsr)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapEntityProperties.get(entityIn.am());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof gki)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        gki er = (gki)ier;
        return er;
    }

    public static ggz getBlockEntityRenderer(dqh entityIn, ggz renderer) {
        if (mapBlockEntityProperties.isEmpty()) {
            return renderer;
        }
        IRandomEntity randomEntity = RandomEntities.getRandomBlockEntity((dqh)entityIn);
        if (randomEntity == null) {
            return renderer;
        }
        RandomEntityProperties props = (RandomEntityProperties)mapBlockEntityProperties.get(entityIn.r());
        if (props == null) {
            return renderer;
        }
        IEntityRenderer ier = (IEntityRenderer)props.getResource(randomEntity, (Object)renderer);
        if (!(ier instanceof ggz)) {
            return null;
        }
        matchingRuleIndex = props.getMatchingRuleIndex();
        ggz ber = (ggz)ier;
        return ber;
    }

    public static int getMatchingRuleIndex() {
        return matchingRuleIndex;
    }

    static {
        originalEntityRenderMap = null;
        originalTileEntityRenderMap = null;
        originalSkullModelMap = null;
        customTileEntityTypes = new ArrayList();
        debugModels = Boolean.getBoolean("cem.debug.models");
    }
}

