/*
 * Decompiled with CFR 0.152.
 */
package patinapipeworks.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import patinapipeworks.block.CopperPipeBlock;
import patinapipeworks.block.CopperPipeValveBlock;
import patinapipeworks.block.WeatheringCopperPP;
import patinapipeworks.init.ModTags;

public class CopperPipeBaseBlock
extends Block
implements WeatheringCopperPP {
    private final WeatheringCopper.WeatherState weatherState;
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public CopperPipeBaseBlock(WeatheringCopper.WeatherState p_154925_, BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.weatherState = p_154925_;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_7820_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.isPowered(context.m_43725_(), context.m_8083_(), direction)));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return WeatheringCopperPP.honeycombAndAxeInteraction(state, worldIn, pos, player, handIn, hit);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        Direction facing;
        boolean powered;
        if (!world.f_46443_ && (powered = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) != this.isPowered(world, pos, facing = (Direction)state.m_61143_((Property)FACING))) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 3);
        }
    }

    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        Direction facing;
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (powered != this.isPowered((Level)world, pos, facing = (Direction)state.m_61143_((Property)FACING))) {
            world.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 3);
        }
    }

    public boolean isSidePowered(BlockState state, BlockPos pos, BlockGetter reader, Direction direction) {
        BlockState powered_state = reader.m_8055_(pos.m_142300_((Direction)state.m_61143_((Property)FACING)));
        if (powered_state.m_60620_(ModTags.Blocks.copper_pipe_valves)) {
            if (powered_state.m_61143_((Property)FACING) == reader.m_8055_(pos).m_61143_((Property)FACING)) {
                int rotation = (Integer)powered_state.m_61143_((Property)CopperPipeValveBlock.ROTATION);
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                if (direction == facing.m_122424_()) {
                    return false;
                }
                if (facing == Direction.UP) {
                    if (direction == Direction.NORTH) {
                        return rotation > 0;
                    }
                    if (direction == Direction.WEST) {
                        return rotation > 1;
                    }
                    if (direction == facing) {
                        return rotation > 2;
                    }
                    if (direction == Direction.EAST) {
                        return rotation > 3;
                    }
                    if (direction == Direction.SOUTH) {
                        return rotation > 4;
                    }
                } else if (facing == Direction.DOWN) {
                    if (direction == Direction.SOUTH) {
                        return rotation > 0;
                    }
                    if (direction == Direction.WEST) {
                        return rotation > 1;
                    }
                    if (direction == facing) {
                        return rotation > 2;
                    }
                    if (direction == Direction.EAST) {
                        return rotation > 3;
                    }
                    if (direction == Direction.NORTH) {
                        return rotation > 4;
                    }
                } else {
                    if (direction == Direction.DOWN) {
                        return rotation > 0;
                    }
                    if (direction == facing.m_122428_()) {
                        return rotation > 1;
                    }
                    if (direction == facing) {
                        return rotation > 2;
                    }
                    if (direction == facing.m_122427_()) {
                        return rotation > 3;
                    }
                    if (direction == Direction.UP) {
                        return rotation > 4;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public boolean isPowered(Level world, BlockPos pos, Direction direction) {
        if (this.isAdjacentToWater(world, pos) || this.isAdjacentToFilledCauldron(world, pos)) {
            if (world.m_46681_(pos.m_142300_(direction), direction) > 0) {
                return true;
            }
            if (world.m_8055_(pos.m_142300_(direction)).m_60620_(ModTags.Blocks.copper_pipe_valves) && world.m_8055_(pos.m_142300_(direction)).m_61143_((Property)FACING) == direction && (Integer)world.m_8055_(pos.m_142300_(direction)).m_61143_((Property)CopperPipeValveBlock.ROTATION) > 0) {
                return true;
            }
        }
        return world.m_8055_(pos.m_142300_(direction)).m_60620_(ModTags.Blocks.copper_pipes) && (Integer)world.m_8055_(pos.m_142300_(direction)).m_61143_((Property)CopperPipeBlock.STRENGTH) > 0;
    }

    public boolean isAdjacentToWater(Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            FluidState fluidstate = world.m_6425_(pos.m_142300_(direction));
            if (!fluidstate.m_76153_((Tag)FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdjacentToFilledCauldron(Level world, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            BlockState blockstate = world.m_8055_(pos.m_142300_(direction));
            if (blockstate.m_60734_() != Blocks.f_152476_ || (Integer)blockstate.m_61143_((Property)LayeredCauldronBlock.f_153514_) <= 0) continue;
            return true;
        }
        return false;
    }

    public boolean m_7899_(BlockState p_149744_1_) {
        return true;
    }

    public int m_6378_(BlockState state, BlockGetter reader, BlockPos pos, Direction direction) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue() && direction != ((Direction)state.m_61143_((Property)FACING)).m_122424_()) {
            return this.isSidePowered(state, pos, reader, direction) ? 15 : 0;
        }
        return 0;
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.m_61124_((Property)FACING, (Comparable)p_185499_2_.m_55954_((Direction)p_185499_1_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.m_60717_(p_185471_2_.m_54846_((Direction)p_185471_1_.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builderIn) {
        builderIn.m_61104_(new Property[]{FACING, POWERED});
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random rand) {
        this.m_153041_(state, world, pos, rand);
        boolean powered = (Boolean)state.m_61143_((Property)POWERED);
        if (powered && this.isAdjacentToFilledCauldron((Level)world, pos) && rand.nextInt(8) == 0) {
            for (Direction direction : Direction.values()) {
                BlockState blockstate = world.m_8055_(pos.m_142300_(direction));
                if (blockstate.m_60734_() != Blocks.f_152476_) continue;
                LayeredCauldronBlock.m_153559_((BlockState)blockstate, (Level)world, (BlockPos)pos.m_142300_(direction));
                break;
            }
        }
    }

    public boolean m_6724_(BlockState p_154935_) {
        return true;
    }

    public WeatheringCopper.WeatherState getAge() {
        return this.weatherState;
    }
}

