/*
 * Decompiled with CFR 0.152.
 */
package patinapipeworks.tileentity;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ticket.AABBTicket;
import patinapipeworks.api.PPBlocks;
import patinapipeworks.block.CopperPipeBlock;

public class CopperPipeBlockEntity
extends BlockEntity {
    private AABBTicket ticket;
    private static int aabbSize = 1;

    public CopperPipeBlockEntity(BlockPos p_155301_, BlockState p_155302_) {
        super(PPBlocks.COPPER_PIPE_BLOCK_ENTITY, p_155301_, p_155302_);
    }

    public void onLoad() {
        BlockState state;
        if (!this.f_58857_.f_46443_ && ((Boolean)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)CopperPipeBlock.OPENED)).booleanValue() && (Integer)state.m_61143_((Property)CopperPipeBlock.STRENGTH) > 0 && !((Boolean)state.m_61143_((Property)CopperPipeBlock.f_55153_)).booleanValue() && !((Boolean)state.m_61143_((Property)CopperPipeBlock.WATERLOGGED)).booleanValue()) {
            BlockPos groundPos = this.f_58858_.m_7495_();
            for (int i = 1; i < 16; ++i) {
                if (!this.f_58857_.m_8055_(this.f_58858_.m_6625_(i)).m_60838_((BlockGetter)this.f_58857_, this.f_58858_.m_6625_(i))) continue;
                groundPos = this.f_58858_.m_6625_(i);
                break;
            }
            AABB box = new AABB(groundPos);
            box = box.m_82400_((double)aabbSize);
            this.ticket = FarmlandWaterManager.addAABBTicket((Level)this.f_58857_, (AABB)box);
            this.ticket.validate();
        }
    }

    public void onChunkUnloaded() {
        if (!this.f_58857_.f_46443_ && this.ticket != null) {
            this.ticket.invalidate();
        }
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, CopperPipeBlockEntity pipe) {
        if (world != null) {
            if (((Boolean)state.m_61143_((Property)CopperPipeBlock.WATERLOGGED)).booleanValue()) {
                Random random = world.f_46441_;
                if (random.nextInt(3) == 0) {
                    CopperPipeBlock.makeParticles((ParticleOptions)ParticleTypes.f_123795_, world, pos, state, random);
                }
            } else {
                for (int i = 0; i < 2; ++i) {
                    Random random = world.f_46441_;
                    CopperPipeBlock.makeParticles((ParticleOptions)ParticleTypes.f_123804_, world, pos, state, random);
                }
            }
        }
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, CopperPipeBlockEntity pipe) {
        if (world != null) {
            if (((Boolean)state.m_61143_((Property)CopperPipeBlock.OPENED)).booleanValue() && (Integer)state.m_61143_((Property)CopperPipeBlock.STRENGTH) > 0 && !((Boolean)state.m_61143_((Property)CopperPipeBlock.f_55153_)).booleanValue() && !((Boolean)state.m_61143_((Property)CopperPipeBlock.WATERLOGGED)).booleanValue()) {
                int level;
                BlockState aboveBlock;
                BlockPos groundPos = pos.m_7495_();
                for (int i = 1; i < 16; ++i) {
                    if (!world.m_8055_(pos.m_6625_(i)).m_60838_((BlockGetter)world, pos.m_6625_(i))) continue;
                    groundPos = pos.m_6625_(i);
                    break;
                }
                if ((aboveBlock = world.m_8055_(groundPos.m_7494_())).m_60734_() == Blocks.f_50256_ && world.m_5822_().nextInt(256) == 0) {
                    world.m_46597_(groundPos.m_7494_(), Blocks.f_152476_.m_49966_());
                }
                if (aboveBlock.m_60734_() == Blocks.f_152476_ && world.m_5822_().nextInt(256) == 0 && (level = ((Integer)aboveBlock.m_61143_((Property)LayeredCauldronBlock.f_153514_)).intValue()) < 3) {
                    world.m_46597_(groundPos.m_7494_(), (BlockState)Blocks.f_152476_.m_49966_().m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(level + 1)));
                }
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        int ii;
                        BlockPos waterPos = groundPos.m_142082_(j, 0, k);
                        BlockState ground = world.m_8055_(waterPos);
                        BlockState blockstate = world.m_8055_(waterPos.m_7494_());
                        if (blockstate.m_60620_((Tag)BlockTags.f_13076_) && !ground.isFireSource((LevelReader)world, waterPos, Direction.UP) && world.m_5822_().nextInt(24) == 0) {
                            world.m_7471_(waterPos.m_7494_(), false);
                        }
                        if (!blockstate.m_60620_((Tag)BlockTags.f_13073_)) continue;
                        boolean flag = false;
                        IntegerProperty integerproperty = null;
                        if (blockstate.m_60734_() instanceof CropBlock) {
                            CropBlock crop = (CropBlock)blockstate.m_60734_();
                            if (!crop.m_52307_(blockstate)) {
                                flag = true;
                                integerproperty = crop.m_7959_();
                            }
                        } else if (blockstate.m_60734_() instanceof StemBlock && (ii = ((Integer)blockstate.m_61143_((Property)StemBlock.f_57013_)).intValue()) < 7) {
                            flag = true;
                            integerproperty = StemBlock.f_57013_;
                        }
                        if (!flag || world.m_5822_().nextInt(1024) != 0) continue;
                        world.m_46597_(waterPos.m_7494_(), (BlockState)blockstate.m_61124_((Property)integerproperty, (Comparable)Integer.valueOf((Integer)blockstate.m_61143_((Property)integerproperty) + 1)));
                    }
                }
                if (pipe.ticket == null) {
                    AABB box = new AABB(groundPos);
                    box = box.m_82400_((double)aabbSize);
                    pipe.ticket = FarmlandWaterManager.addAABBTicket((Level)world, (AABB)box);
                    pipe.ticket.validate();
                }
            } else if (pipe.ticket != null) {
                pipe.ticket.invalidate();
            }
        }
    }
}

