/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import glitchcore.event.Event;
import glitchcore.event.EventManager;
import glitchcore.event.TickEvent;
import glitchcore.event.player.PlayerEvent;
import glitchcore.network.CustomPacket;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonChangedEvent;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModPackets;
import sereneseasons.init.ModTags;
import sereneseasons.network.SyncSeasonCyclePacket;
import sereneseasons.season.SeasonHandlerClient;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class SeasonHandler
implements SeasonHelper.ISeasonDataProvider {
    public static final HashMap<Level, Long> lastDayTimes = new HashMap();
    public static final HashMap<Level, Integer> updateTicks = new HashMap();
    public static final HashMap<ResourceKey<Level>, Integer> prevServerSeasonCycleTicks = new HashMap();

    public static void onLevelTick(TickEvent.Level event) {
        MinecraftServer server;
        Level level = event.getLevel();
        if (event.getPhase() != TickEvent.Phase.START || level.isClientSide() || !ModConfig.seasons.isDimensionWhitelisted((ResourceKey<Level>)level.dimension())) {
            return;
        }
        long dayTime = level.getDayTime();
        long lastDayTime = lastDayTimes.getOrDefault(level, dayTime);
        lastDayTimes.put(level, dayTime);
        if (!level.getGameRules().getBoolean(SSGameRules.RULE_DOSEASONCYCLE)) {
            return;
        }
        if (!ModConfig.seasons.progressSeasonWhileOffline && (server = level.getServer()) != null && server.getPlayerList().getPlayerCount() == 0) {
            return;
        }
        long difference = dayTime - lastDayTime;
        if (difference == 0L) {
            return;
        }
        if (difference < 0L) {
            difference += 24000L;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        savedData.seasonCycleTicks = Mth.positiveModulo((int)(savedData.seasonCycleTicks + (int)difference), (int)SeasonTime.ZERO.getCycleDuration());
        int ticks = updateTicks.getOrDefault(level, 0);
        if (ticks >= 20) {
            SeasonHandler.sendSeasonUpdate(level);
            ticks %= 20;
        }
        updateTicks.put(level, ticks + 1);
        savedData.setDirty();
    }

    public static void onJoinLevel(PlayerEvent.JoinLevel event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Level level = player2.level();
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        ModPackets.HANDLER.sendToPlayer((CustomPacket)new SyncSeasonCyclePacket((ResourceKey<Level>)level.dimension(), savedData.seasonCycleTicks), player2);
    }

    public static void sendSeasonUpdate(Level level) {
        if (level.isClientSide()) {
            return;
        }
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(level);
        SeasonTime newTime = new SeasonTime(savedData.seasonCycleTicks);
        SeasonTime prevTime = new SeasonTime(prevServerSeasonCycleTicks.computeIfAbsent((ResourceKey<Level>)level.dimension(), key -> newTime.getSeasonCycleTicks()));
        Season.SubSeason prevSeason = prevTime.getSubSeason();
        Season.TropicalSeason prevTropicalSeason = prevTime.getTropicalSeason();
        Season.SubSeason newSeason = newTime.getSubSeason();
        Season.TropicalSeason newTropicalSeason = newTime.getTropicalSeason();
        prevServerSeasonCycleTicks.put((ResourceKey<Level>)level.dimension(), newTime.getSeasonCycleTicks());
        if (!prevSeason.equals(newSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Standard(level, prevSeason, newSeason));
        }
        if (!prevTropicalSeason.equals(newTropicalSeason)) {
            EventManager.fire((Event)new SeasonChangedEvent.Tropical(level, prevTropicalSeason, newTropicalSeason));
        }
        ModPackets.HANDLER.sendToAll((CustomPacket)new SyncSeasonCyclePacket((ResourceKey<Level>)level.dimension(), savedData.seasonCycleTicks), ((ServerLevel)level).getServer());
    }

    public static SeasonSavedData getSeasonSavedData(Level w) {
        if (w.isClientSide() || !(w instanceof ServerLevel)) {
            return null;
        }
        ServerLevel world = (ServerLevel)w;
        DimensionDataStorage saveDataManager = world.getChunkSource().getDataStorage();
        Supplier<SeasonSavedData> defaultSaveDataSupplier = () -> {
            SeasonSavedData savedData = new SeasonSavedData();
            int startingSeason = ModConfig.seasons.startingSubSeason;
            if (startingSeason == 0) {
                savedData.seasonCycleTicks = world.random.nextInt(12) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            if (startingSeason > 0) {
                savedData.seasonCycleTicks = (startingSeason - 1) * SeasonTime.ZERO.getSubSeasonDuration();
            }
            savedData.setDirty();
            return savedData;
        };
        return (SeasonSavedData)saveDataManager.computeIfAbsent(new SavedData.Factory(defaultSaveDataSupplier, SeasonSavedData::load, DataFixTypes.LEVEL), "seasons");
    }

    @Override
    public ISeasonState getServerSeasonState(Level world) {
        SeasonSavedData savedData = SeasonHandler.getSeasonSavedData(world);
        return new SeasonTime(savedData.seasonCycleTicks);
    }

    @Override
    public ISeasonState getClientSeasonState(Level level) {
        int time = level != null ? SeasonHandlerClient.clientSeasonCycleTicks.getOrDefault(level.dimension(), 0) : 0;
        return new SeasonTime(time);
    }

    @Override
    public boolean usesTropicalSeasons(Holder<Biome> biome) {
        return biome.is(ModTags.Biomes.TROPICAL_BIOMES);
    }
}

