/*
 * Decompiled with CFR 0.152.
 */
package com.dainxt.weaponthrow.handlers;

import com.dainxt.weaponthrow.capabilities.ThrowProvider;
import com.dainxt.weaponthrow.config.WeaponThrowConfig;
import com.dainxt.weaponthrow.events.WeaponThrowEvent;
import com.dainxt.weaponthrow.handlers.KeyBindingHandler;
import com.dainxt.weaponthrow.handlers.PacketHandler;
import com.dainxt.weaponthrow.interfaces.IThrowPower;
import com.dainxt.weaponthrow.packets.CPacketThrow;
import com.dainxt.weaponthrow.packets.SPacketThrow;
import com.dainxt.weaponthrow.projectile.WeaponThrowEntity;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import harmonised.pmmo.config.JType;
import harmonised.pmmo.skills.Skill;
import harmonised.pmmo.util.XP;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;

public class EventsHandler {
    public static final ResourceLocation THROWPOWER = new ResourceLocation("weaponthrow", "throw_power");
    public boolean wasPressed = false;

    public static void onThrowItem(ServerPlayer playerentity, CPacketThrow.State action) {
        Level worldIn = playerentity.f_19853_;
        ItemStack stack = playerentity.m_21205_();
        boolean isThrowable = (Boolean)WeaponThrowConfig.COMMON.shouldThrowItemsToo.get();
        for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
            if (!stack.m_41720_().equals(item)) continue;
            isThrowable = true;
        }
        if (ModList.get().isLoaded("pmmo") && ((Boolean)WeaponThrowConfig.COMMON.enablePMMOIntegration.get()).booleanValue()) {
            int combatLevel;
            ResourceLocation resLoc = stack.m_41720_().getRegistryName();
            Map weaponReq = XP.getJsonMap((ResourceLocation)resLoc, (JType)JType.REQ_WEAPON);
            double reqLevel = 0.0;
            if (weaponReq.containsKey(Skill.COMBAT.name.toLowerCase())) {
                reqLevel = (Double)weaponReq.get(Skill.COMBAT.name.toLowerCase());
            }
            if (reqLevel > (double)(combatLevel = Skill.getLevel((String)Skill.COMBAT.name.toLowerCase(), (UUID)playerentity.m_142081_())) && reqLevel > 0.0) {
                playerentity.m_5661_((Component)new TranslatableComponent("weaponthrow.pmmo.requirementThrowing", new Object[]{reqLevel}), true);
                return;
            }
        }
        WeaponThrowEvent.TestThrow testEvent = new WeaponThrowEvent.TestThrow(stack, (Player)playerentity);
        boolean isCancelled = MinecraftForge.EVENT_BUS.post((Event)testEvent);
        Multimap multimap = stack.m_41638_(EquipmentSlot.MAINHAND);
        boolean haveAttributes = multimap.containsKey((Object)Attributes.f_22281_) || multimap.containsKey((Object)Attributes.f_22283_);
        IThrowPower provider = (IThrowPower)playerentity.getCapability(ThrowProvider.THROW_POWER).resolve().get();
        if ((isThrowable || haveAttributes) && !isCancelled && !stack.m_41619_()) {
            boolean cdConfig = (Boolean)WeaponThrowConfig.COMMON.notUseWhenCooldown.get();
            if (!(playerentity.m_36335_().m_41521_(stack.m_41720_(), 1.0f) > 0.0f) || !cdConfig) {
                provider.setAction(action);
                if (action.equals((Object)CPacketThrow.State.START) && provider.getChargeTime() <= 0) {
                    provider.startCharging(stack, (Player)playerentity);
                }
                if (action.equals((Object)CPacketThrow.State.FINISH) && provider.getChargeTime() >= 0) {
                    float baseThrow = 0.0f;
                    float baseExhaustion = 0.05f;
                    float modThrow = 1.0f;
                    if (Math.signum(ThrowProvider.getMaximumCharge((Player)playerentity)) != 0.0f) {
                        modThrow = 1.0f - (float)provider.getChargeTime() / (float)ThrowProvider.getMaximumCharge((Player)playerentity);
                    }
                    provider.resetCharging();
                    double defaultVelocity = (Double)WeaponThrowConfig.COMMON.baseVelocityDefault.get();
                    if (((Boolean)WeaponThrowConfig.COMMON.shouldThrowItemsToo.get()).booleanValue()) {
                        baseThrow = (float)defaultVelocity;
                    } else if (!WeaponThrowConfig.COMMON.whiteList.get().isEmpty()) {
                        for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
                            if (!stack.m_41720_().equals(item)) continue;
                            baseThrow = (float)defaultVelocity;
                        }
                    }
                    if (haveAttributes) {
                        baseThrow = 20.0f / playerentity.m_36333_();
                        baseExhaustion = playerentity.m_36333_() / 20.0f;
                    }
                    if (baseThrow > 0.0f) {
                        double defaultDamage = (Double)WeaponThrowConfig.COMMON.baseDamageDefault.get();
                        boolean shouldDestroy = (double)modThrow > 0.99;
                        float baseDamage = 0.0f;
                        double toolMultiplier = 0.0;
                        if (((Boolean)WeaponThrowConfig.COMMON.shouldThrowItemsToo.get()).booleanValue()) {
                            baseDamage = (float)defaultDamage;
                        } else if (!WeaponThrowConfig.COMMON.whiteList.get().isEmpty()) {
                            for (Item item : WeaponThrowConfig.COMMON.whiteList.get()) {
                                if (!stack.m_41720_().equals(item)) continue;
                                baseDamage = (float)defaultDamage;
                            }
                        }
                        if (haveAttributes) {
                            baseDamage = (float)playerentity.m_21133_(Attributes.f_22281_);
                            int types = 0;
                            if (stack.canPerformAction(ToolActions.AXE_DIG)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.axeMultiplier.get()).doubleValue();
                                ++types;
                            }
                            if (stack.canPerformAction(ToolActions.HOE_DIG)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.hoeMultiplier.get()).doubleValue();
                                ++types;
                            }
                            if (stack.canPerformAction(ToolActions.PICKAXE_DIG)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.pickaxeMultiplier.get()).doubleValue();
                                ++types;
                            }
                            if (stack.canPerformAction(ToolActions.SHOVEL_DIG)) {
                                toolMultiplier += ((Double)WeaponThrowConfig.COMMON.shovelMultiplier.get()).doubleValue();
                                ++types;
                            }
                            if (stack.canPerformAction(ToolActions.SWORD_DIG)) {
                                toolMultiplier = (Double)WeaponThrowConfig.COMMON.swordMultiplier.get();
                                ++types;
                            }
                            toolMultiplier /= (double)(types > 0 ? types : 1);
                        }
                        if (toolMultiplier == 0.0) {
                            toolMultiplier = 1.0;
                        }
                        int size = playerentity.m_6047_() ? stack.m_41613_() : 1;
                        double bDamageMul = (Double)WeaponThrowConfig.COMMON.baseDamageMultiplier.get();
                        double sDamageMul = (Double)WeaponThrowConfig.COMMON.stackDamageMultiplier.get();
                        double mDamageMul = (Double)WeaponThrowConfig.COMMON.modifiedDamageMultiplier.get();
                        double totalDamage = (double)baseDamage * (1.0 * bDamageMul + (double)modThrow * mDamageMul) + (double)size * sDamageMul;
                        totalDamage *= toolMultiplier;
                        double bVelocityMul = (Double)WeaponThrowConfig.COMMON.baseVelocityMultiplier.get();
                        double sVelocityMul = (Double)WeaponThrowConfig.COMMON.stackVelocityMultiplier.get();
                        double mVelocityMul = (Double)WeaponThrowConfig.COMMON.modifiedVelocityMultiplier.get();
                        double totalVelocity = (double)baseThrow * (1.0 * bVelocityMul + (double)modThrow * mVelocityMul) - (double)size * sVelocityMul;
                        double bExhaustionMul = (Double)WeaponThrowConfig.COMMON.baseExhaustionMultiplier.get();
                        double sExhaustionMul = (Double)WeaponThrowConfig.COMMON.stackExhaustionMultiplier.get();
                        double mExhaustionMul = (Double)WeaponThrowConfig.COMMON.modifiedExhaustionMultiplier.get();
                        double totalExhaustion = (double)baseExhaustion * (1.0 * bExhaustionMul + (double)modThrow * mExhaustionMul) + (double)size * sExhaustionMul;
                        WeaponThrowEvent.OnThrow onThrowEvent = new WeaponThrowEvent.OnThrow(stack, (Player)playerentity, totalDamage, totalVelocity *= toolMultiplier, totalExhaustion *= toolMultiplier);
                        MinecraftForge.EVENT_BUS.post((Event)onThrowEvent);
                        WeaponThrowEntity throwedEntity = new WeaponThrowEntity(worldIn, (LivingEntity)playerentity, shouldDestroy, (float)onThrowEvent.totalDamage, stack.m_41620_(size));
                        throwedEntity.m_37251_((Entity)playerentity, playerentity.m_146909_(), playerentity.m_146908_(), 0.0f, (float)onThrowEvent.totalVelocity, 1.0f);
                        playerentity.m_36399_((float)onThrowEvent.totalExhaustion);
                        worldIn.m_7967_((Entity)throwedEntity);
                        SoundEvent soundevent = SoundEvents.f_11877_;
                        throwedEntity.m_5496_(soundevent, 1.0f, 0.5f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
    }

    @SubscribeEvent
    public void onPlayerToss(ItemTossEvent event) {
        event.getPlayer().getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
            if (!cap.getAction().equals((Object)CPacketThrow.State.NONE)) {
                event.setCanceled(true);
            }
        });
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Player)) {
            return;
        }
        event.addCapability(THROWPOWER, (ICapabilityProvider)new ThrowProvider());
    }

    @SubscribeEvent
    public void onCapabilityRegistration(RegisterCapabilitiesEvent event) {
        event.register(IThrowPower.class);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            event.player.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
                if (!event.player.f_19853_.f_46443_) {
                    boolean changedItem;
                    boolean attacked = event.player.m_36403_(0.0f) < 1.0f;
                    boolean cdConfig = (Boolean)WeaponThrowConfig.COMMON.notUseWhenCooldown.get();
                    boolean bl = changedItem = !cap.getChargingStack().equals(event.player.m_21205_());
                    if (attacked && cdConfig || changedItem) {
                        cap.resetCharging();
                    }
                    if (cap.getChargeTime() > 0) {
                        cap.setChargeTime(cap.getChargeTime() - 1);
                    }
                    if (cap.getAction().equals((Object)CPacketThrow.State.START) || cap.getAction().equals((Object)CPacketThrow.State.FINISH)) {
                        PacketHandler.sendToAll(new SPacketThrow(event.player.m_142081_(), ThrowProvider.getMaximumCharge(event.player), cap.getAction().equals((Object)CPacketThrow.State.START)));
                        if (cap.getAction().equals((Object)CPacketThrow.State.FINISH)) {
                            cap.setAction(CPacketThrow.State.NONE);
                        }
                    }
                    if (cap.getAction().equals((Object)CPacketThrow.State.START)) {
                        cap.setAction(CPacketThrow.State.DURING);
                    }
                } else if (cap.getChargeTime() > 0) {
                    cap.setChargeTime(cap.getChargeTime() - 1);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onSeverUpdate(UUID playerUUID, int chargeTime, boolean isCharging) {
        Player playerentity = Minecraft.m_91087_().f_91073_.m_46003_(playerUUID);
        if (playerentity != null) {
            playerentity.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
                cap.setMaxChargeTime(chargeTime);
                if (isCharging) {
                    cap.setChargeTime(chargeTime);
                }
                cap.setAction(isCharging ? CPacketThrow.State.DURING : CPacketThrow.State.NONE);
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderView(RenderGameOverlayEvent.Post event) {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void updateFov(FOVModifierEvent event) {
        Optional optionalCapability = Minecraft.m_91087_().f_91074_.getCapability(ThrowProvider.THROW_POWER).resolve();
        if (optionalCapability.isPresent()) {
            int maxChargeTime = ((IThrowPower)optionalCapability.get()).getMaxChargeTime();
            int chargeTime = ((IThrowPower)optionalCapability.get()).getChargeTime();
            boolean isCharging = ((IThrowPower)optionalCapability.get()).getAction().equals((Object)CPacketThrow.State.DURING);
            if (isCharging) {
                float f = event.getFov();
                float f1 = 1.0f;
                if (Math.signum(maxChargeTime) != 0.0f && chargeTime > 0) {
                    float lerp = Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)(chargeTime + 1), (float)chargeTime);
                    f1 = Mth.m_14036_((float)(1.0f - lerp / (float)maxChargeTime), (float)0.0f, (float)1.0f);
                }
                f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                event.setNewfov(f *= 1.0f + f1 * 0.15f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHandAnimation(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemInHandRenderer renderer = Minecraft.m_91087_().m_91292_();
        if (!player.m_150108_()) {
            player.getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
                if (cap.getAction().equals((Object)CPacketThrow.State.DURING)) {
                    PoseStack matrices = event.getPoseStack();
                    boolean flag = event.getHand() == InteractionHand.MAIN_HAND;
                    HumanoidArm humanoidarm = flag ? player.m_5737_() : player.m_5737_().m_20828_();
                    int i = humanoidarm == HumanoidArm.RIGHT ? 1 : -1;
                    boolean flag3 = humanoidarm == HumanoidArm.RIGHT;
                    float preProgress = 1.0f;
                    if (Math.signum(cap.getMaxChargeTime()) != 0.0f && cap.getChargeTime() > 0) {
                        float lerp = Mth.m_14179_((float)event.getPartialTicks(), (float)(cap.getChargeTime() + 1), (float)cap.getChargeTime());
                        preProgress = 1.0f - lerp / (float)cap.getMaxChargeTime();
                    }
                    float progress = Mth.m_14036_((float)preProgress, (float)0.0f, (float)1.0f);
                    matrices.m_85836_();
                    matrices.m_85837_((double)((float)i * 0.56f), (double)(-0.52f + event.getEquipProgress() * -0.6f), (double)-0.72f);
                    matrices.m_85837_(0.0, (double)(progress * 0.66f), (double)(progress * 0.3f));
                    matrices.m_85845_(Vector3f.f_122227_.m_122240_(progress * 10.0f));
                    matrices.m_85845_(Vector3f.f_122223_.m_122240_(progress * 30.0f));
                    renderer.m_109322_((LivingEntity)player, event.getItemStack(), flag3 ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND, !flag3, matrices, event.getMultiBufferSource(), event.getPackedLight());
                    matrices.m_85849_();
                    event.setCanceled(true);
                }
            });
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent event) {
        event.getEntity().getCapability(ThrowProvider.THROW_POWER).ifPresent(cap -> {
            if (cap.getAction().equals((Object)CPacketThrow.State.DURING) && event.getEntity() instanceof AbstractClientPlayer) {
                HumanoidArm hand = ((AbstractClientPlayer)event.getEntity()).m_5737_();
                if (hand == HumanoidArm.RIGHT) {
                    ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.THROW_SPEAR;
                } else {
                    ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.THROW_SPEAR;
                }
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void inputUpdate(MovementInputUpdateEvent event) {
        boolean isCharging;
        Optional optionalCapability = Minecraft.m_91087_().f_91074_.getCapability(ThrowProvider.THROW_POWER).resolve();
        if (optionalCapability.isPresent() && (isCharging = ((IThrowPower)optionalCapability.get()).getAction().equals((Object)CPacketThrow.State.DURING))) {
            event.getInput().f_108566_ *= 0.2f;
            event.getInput().f_108567_ *= 0.2f;
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        this.handleInputs((InputEvent)event);
    }

    @SubscribeEvent
    public void onClickInputEvent(InputEvent.MouseInputEvent event) {
        this.handleInputs((InputEvent)event);
    }

    public void handleInputs(InputEvent event) {
        KeyModifier keyModifier = KeyBindingHandler.KEYBINDING.getKeyModifier();
        boolean isPrincipalModifier = keyModifier.equals((Object)KeyModifier.NONE) ? true : keyModifier.equals((Object)KeyModifier.getActiveModifier());
        boolean pressed = KeyBindingHandler.KEYBINDING.m_90857_();
        if (pressed && isPrincipalModifier) {
            if (!this.wasPressed) {
                PacketHandler.sendToServer(new CPacketThrow(CPacketThrow.State.START));
                this.wasPressed = true;
            }
        } else if (this.wasPressed) {
            PacketHandler.sendToServer(new CPacketThrow(CPacketThrow.State.FINISH));
            this.wasPressed = false;
        }
    }
}

