/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.util.LazyOptional;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;

public class WorldDataHandler {
    private WorldDataReader worldDataReader;
    private ServerLevel worldServer;
    private Path worldDir;

    public WorldDataHandler(WorldDataReader worldDataReader) {
        this.worldDataReader = worldDataReader;
    }

    public void prepareSingleplayer(Level world, MapProcessor mapProcessor) {
        String worldId = mapProcessor.getCurrentWorldId();
        if (world != null && !mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(worldId), worldId)) {
            this.worldServer = Minecraft.m_91087_().m_91092_().m_129880_(world.m_46472_());
            if (this.worldServer != null) {
                Path overworldDir = this.worldServer.m_7654_().m_129843_(LevelResource.f_78182_);
                this.worldDir = DimensionType.m_196975_((ResourceKey)this.worldServer.m_46472_(), (Path)overworldDir);
            } else {
                this.worldDir = null;
            }
        } else {
            this.worldServer = null;
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, Level world, HolderLookup<Block> blockLookup, Registry<Block> blockRegistry, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldServer == null) {
            WorldMap.LOGGER.info("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        LazyOptional capabilityValue = this.worldServer.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            boolean shouldCancel = false;
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                if (loadedCap.loaded) {
                    boolean buildResult = this.worldDataReader.buildRegion(region, this.worldServer, world, blockLookup, blockRegistry, loading, chunkCountDest);
                    Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                    return result;
                }
                shouldCancel = true;
            }
            if (shouldCancel) {
                WorldMap.LOGGER.info("Tried loading a region for an unloaded server world!");
                return Result.CANCEL;
            }
        }
        WorldMap.LOGGER.info("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onServerWorldUnload(ServerLevel sw) {
        LazyOptional capabilityValue = sw.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap;
            ServerWorldLoaded serverWorldLoaded = loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            synchronized (serverWorldLoaded) {
                loadedCap.loaded = false;
            }
        }
    }

    public ServerLevel getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.worldDataReader;
    }

    public Path getWorldDir() {
        return this.worldDir;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

