/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import xaero.map.WorldMap;
import xaero.map.animation.SlowingAnimation;
import xaero.map.element.MapElementRenderer;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.GuiMap;
import xaero.map.icon.XaeroIcon;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportXaeroMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointReader;
import xaero.map.mods.gui.WaypointRenderContext;
import xaero.map.mods.gui.WaypointRenderProvider;
import xaero.map.mods.gui.WaypointSymbolCreator;

public final class WaypointRenderer
extends MapElementRenderer<Waypoint, WaypointRenderContext, WaypointRenderer> {
    private final SupportXaeroMinimap minimap;
    private final WaypointSymbolCreator symbolCreator;

    private WaypointRenderer(WaypointRenderContext context, WaypointRenderProvider provider, WaypointReader reader, SupportXaeroMinimap minimap, WaypointSymbolCreator symbolCreator) {
        super(context, provider, reader);
        this.minimap = minimap;
        this.symbolCreator = symbolCreator;
    }

    public WaypointSymbolCreator getSymbolCreator() {
        return this.symbolCreator;
    }

    @Override
    public void renderElementPre(int location, Waypoint w, boolean hovered, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        matrixStack.m_85837_(partialX, partialY, 0.0);
        matrixStack.m_85841_(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, 1.0f);
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        matrixStack.m_252880_(-14.0f, -41.0f, 0.0f);
        MapRenderHelper.blitIntoExistingBuffer(matrixStack.m_85850_().m_252922_(), ((WaypointRenderContext)this.context).regularUIObjectConsumer, 0, 19, 0, 117, 41, 22, 0.0f, 0.0f, 0.0f, brightness * visibilityAlpha / ((WaypointRenderContext)this.context).worldmapWaypointsScale);
    }

    @Override
    public boolean shouldRender(int location, boolean pre) {
        return WorldMap.settings.renderWaypoints && (!pre || WorldMap.settings.waypointBackgrounds);
    }

    @Override
    public boolean renderElement(int location, Waypoint w, boolean hovered, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, int elementIndex, double optionalDepth, float optionalScale, double partialX, double partialY, boolean cave, float partialTicks) {
        int symbolFrameWidth;
        boolean renderBackground = hovered || WorldMap.settings.waypointBackgrounds;
        matrixStack.m_85837_(partialX, partialY, 0.0);
        matrixStack.m_85841_(optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, optionalScale * ((WaypointRenderContext)this.context).worldmapWaypointsScale, 1.0f);
        matrixStack.m_85836_();
        float visibilityAlpha = w.isDisabled() ? 0.3f : 1.0f;
        int color = w.getColor();
        String symbol = w.getSymbol();
        int type = w.getType();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int flagU = 35;
        int flagV = 34;
        int flagW = 30;
        int flagH = 43;
        if (symbol.length() > 1) {
            flagU += 35;
            flagW += 13;
        }
        if (w.isTemporary()) {
            flagU += 83;
        }
        matrixStack.m_252880_((float)(-flagW) / 2.0f, (float)(-flagH + 1), 0.0f);
        if (renderBackground) {
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_252922_(), ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer, 0.0f, 0.0f, flagU, flagV, flagW, flagH, red * visibilityAlpha, green * visibilityAlpha, blue * visibilityAlpha, visibilityAlpha, textureManager.m_118506_(WorldMap.guiTextures).m_117963_());
        }
        matrixStack.m_85849_();
        float oldDestAlpha = w.getDestAlpha();
        if (hovered) {
            w.setDestAlpha(255.0f);
        } else {
            w.setDestAlpha(0.0f);
        }
        if (oldDestAlpha != w.getDestAlpha()) {
            w.setAlphaAnim(new SlowingAnimation(w.getAlpha(), w.getDestAlpha(), 0.8, 1.0));
        }
        if (w.getAlphaAnim() != null) {
            w.setAlpha((float)w.getAlphaAnim().getCurrent());
        }
        float alpha = w.getAlpha();
        XaeroIcon symbolIcon = null;
        int symbolVerticalOffset = 0;
        int symbolWidth = 0;
        int stringWidth = fontRenderer.m_92895_(symbol);
        int n = symbolFrameWidth = stringWidth / 2 > 4 ? 62 : 32;
        if (type != 1 && alpha < 200.0f) {
            symbolVerticalOffset = 5;
            symbolWidth = (stringWidth - 1) * 3;
            symbolIcon = this.symbolCreator.getSymbolTexture(symbol);
        } else if (type == 1) {
            symbolVerticalOffset = 3;
            symbolWidth = 27;
            symbolIcon = this.symbolCreator.getDeathSymbolTexture();
        }
        if (symbolIcon != null) {
            matrixStack.m_85836_();
            matrixStack.m_252880_(-1.0f - (float)symbolWidth / 2.0f, (float)(62 + (renderBackground ? -43 + symbolVerticalOffset - 1 : -12)), 0.0f);
            matrixStack.m_85841_(1.0f, -1.0f, 1.0f);
            MapRenderHelper.blitIntoMultiTextureRenderer(matrixStack.m_85850_().m_252922_(), ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer, 0.0f, 0.0f, symbolIcon.getOffsetX() + 1, symbolIcon.getOffsetY() + 1, symbolFrameWidth, 62, visibilityAlpha, visibilityAlpha, visibilityAlpha, visibilityAlpha, symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getWidth(), symbolIcon.getTextureAtlas().getTextureId());
            matrixStack.m_85849_();
        }
        if ((int)alpha > 0) {
            int tc = (int)alpha << 24 | 0xFFFFFF;
            String name = w.getName();
            int len = fontRenderer.m_92895_(name);
            matrixStack.m_252880_(0.0f, (float)(renderBackground ? -38 : -11), 0.0f);
            matrixStack.m_85841_(3.0f, 3.0f, 1.0f);
            int bgLen = Math.max(len + 2, 10);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_252922_(), ((WaypointRenderContext)this.context).textBGConsumer, -bgLen / 2, -1, bgLen / 2, 9, red, green, blue, alpha / 255.0f);
            MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_252922_(), ((WaypointRenderContext)this.context).textBGConsumer, -bgLen / 2, -1, bgLen / 2, 8, 0.0f, 0.0f, 0.0f, alpha / 255.0f * 200.0f / 255.0f);
            if ((int)alpha > 3) {
                matrixStack.m_252880_(0.0f, 0.0f, 1.0f);
                Misc.drawNormalText(matrixStack, name, (float)(-(len - 1)) / 2.0f, 0.0f, tc, false, renderTypeBuffers);
            }
        }
        return false;
    }

    @Override
    public void beforeRender(int location, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        ((WaypointRenderContext)this.context).regularUIObjectConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.GUI_BILINEAR);
        ((WaypointRenderContext)this.context).textBGConsumer = renderTypeBuffers.m_6299_(CustomRenderTypes.MAP_ELEMENT_TEXT_BG);
        ((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.GUI_BILINEAR_PREMULTIPLIED);
        ((WaypointRenderContext)this.context).deathpoints = this.minimap.getDeathpoints();
        ((WaypointRenderContext)this.context).userScale = mc.f_91080_ != null && mc.f_91080_ instanceof GuiMap ? ((GuiMap)mc.f_91080_).getUserScale() : 1.0;
    }

    @Override
    public void afterRender(int location, Minecraft mc, PoseStack matrixStack, double cameraX, double cameraZ, double mouseX, double mouseZ, float brightness, double scale, double screenSizeBasedScale, TextureManager textureManager, Font fontRenderer, MultiBufferSource.BufferSource renderTypeBuffers, MultiTextureRenderTypeRendererProvider rendererProvider, boolean pre) {
        rendererProvider.draw(((WaypointRenderContext)this.context).uniqueTextureUIObjectRenderer);
        renderTypeBuffers.m_109911_();
    }

    @Override
    public int getOrder() {
        return 200;
    }

    public static final class Builder {
        private SupportXaeroMinimap minimap;
        private WaypointSymbolCreator symbolCreator;

        private Builder() {
        }

        private Builder setDefault() {
            this.setMinimap(null);
            this.setSymbolCreator(null);
            return this;
        }

        public Builder setMinimap(SupportXaeroMinimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public Builder setSymbolCreator(WaypointSymbolCreator symbolCreator) {
            this.symbolCreator = symbolCreator;
            return this;
        }

        public WaypointRenderer build() {
            if (this.minimap == null || this.symbolCreator == null) {
                throw new IllegalStateException();
            }
            return new WaypointRenderer(new WaypointRenderContext(), new WaypointRenderProvider(this.minimap), new WaypointReader(), this.minimap, this.symbolCreator);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

