/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.biome.BlockTintProvider;
import xaero.map.region.MapBlock;
import xaero.map.region.MapPixel;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;

public class Overlay
extends MapPixel {
    private short opacity;
    private float transparency;

    public Overlay(BlockState state, float transparency, byte light, boolean glowing) {
        this.write(state, transparency, light, glowing);
    }

    public void write(BlockState state, float transparency, byte light, boolean glowing) {
        this.opacity = 0;
        this.state = state;
        this.transparency = transparency;
        this.light = light;
        this.glowing = glowing;
    }

    public boolean isWater() {
        return this.state.m_60734_() == Blocks.f_49990_;
    }

    public int getParametres() {
        int parametres = 0;
        parametres |= !this.isWater() ? 1 : 0;
        parametres |= this.opacity > 1 ? 8 : 0;
        return parametres |= this.light << 4;
    }

    public void getPixelColour(MapBlock block, int[] result_dest, MapWriter mapWriter, Level world, Registry<Block> blockRegistry, MapTileChunk tileChunk, MapTileChunk prevChunk, MapTileChunk prevChunkDiagonal, MapTileChunk prevChunkHorisontal, MapTile mapTile, int x, int z, BlockPos.MutableBlockPos mutableGlobalPos, Registry<Biome> biomeRegistry, float shadowR, float shadowG, float shadowB, BlockTintProvider blockTintProvider, MapProcessor mapProcessor, OverlayManager overlayManager) {
        super.getPixelColours(result_dest, mapWriter, world, blockRegistry, tileChunk, prevChunk, prevChunkDiagonal, prevChunkHorisontal, mapTile, x, z, block, -1, null, mutableGlobalPos, biomeRegistry, shadowR, shadowG, shadowB, blockTintProvider, mapProcessor, overlayManager, null);
    }

    public String toRenderString() {
        return "(S: " + this.getState() + ", A: " + this.transparency + ", O: " + this.opacity + ", L: " + this.light + ")";
    }

    public boolean equals(Overlay p) {
        return p != null && this.opacity == p.opacity && this.transparency == p.transparency && this.light == p.light && this.getState() == p.getState();
    }

    void fillManagerKeyHolder(Object[] keyHolder) {
        keyHolder[0] = this.state;
        keyHolder[1] = this.light;
        keyHolder[2] = this.opacity;
    }

    public void increaseOpacity(int toAdd) {
        this.opacity = (short)(this.opacity + toAdd);
    }

    public int getOpacity() {
        return this.opacity;
    }

    public float getTransparency() {
        return this.transparency;
    }
}

