/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingStage;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.CrashHandler;
import xaero.map.MapLimiter;
import xaero.map.MapRunner;
import xaero.map.WorldMapClient;
import xaero.map.cache.UnknownBlockStateCache;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.controls.ControlsRegister;
import xaero.map.effects.EffectsRegister;
import xaero.map.element.MapElementRenderHandler;
import xaero.map.events.Events;
import xaero.map.events.FMLEvents;
import xaero.map.events.ModCommonEvents;
import xaero.map.events.ModEvents;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.PNGExporter;
import xaero.map.graphics.GLObjectDeleter;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.message.LevelMapPropertiesCoder;
import xaero.map.message.LevelMapPropertiesConsumer;
import xaero.map.misc.Internet;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.patreon.Patreon;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.pool.buffer.TextureDirectBufferPool;
import xaero.map.region.OverlayManager;
import xaero.map.server.WorldMapServer;
import xaero.map.server.core.XaeroWorldMapServerCore;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;

@Mod(value="xaeroworldmap")
public class WorldMap {
    public static int MINIMAP_COMPATIBILITY_VERSION = 18;
    public static Logger LOGGER = LogManager.getLogger();
    private static final String versionID_minecraft = "1.19.3";
    private static final String versionID_mod = "1.28.8";
    public static final String versionID = "1.19.3_1.28.8";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static String latestVersionMD5;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ControlsRegister controlsRegister;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static ByteBufferDeallocator bufferDeallocator;
    public static TextureUploadBenchmark textureUploadBenchmark;
    public static OverlayManager overlayManager;
    public static OldFormatSupport oldFormatSupport;
    public static PNGExporter pngExporter;
    public static TextureUploadPool.Normal normalTextureUploadPool;
    public static TextureUploadPool.Compressed compressedTextureUploadPool;
    public static TextureUploadPool.BranchUpdate branchUpdatePool;
    public static TextureUploadPool.BranchUpdate branchUpdateAllocatePool;
    public static TextureUploadPool.BranchDownload branchDownloadPool;
    public static TextureUploadPool.SubsequentNormal subsequentNormalTextureUploadPool;
    public static TextureDirectBufferPool textureDirectBufferPool;
    public static MapTilePool tilePool;
    public static MapLimiter mapLimiter;
    public static UnknownBlockStateCache unknownBlockStateCache;
    public static GLObjectDeleter glObjectDeleter;
    public static MapRunner mapRunner;
    public static Thread mapRunnerThread;
    public static CrashHandler crashHandler;
    public static final ResourceLocation guiTextures;
    public static ModSettings settings;
    public static int globalVersion;
    public static WorldMapClient worldMapClient;
    public static MapElementRenderHandler mapElementRenderHandler;
    public static final SimpleChannel network;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;

    public WorldMap() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadCommon);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadServer);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModCommonEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ServerWorldCapabilities::registerCapabilities);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            this.registerClientEvents();
        }
        new EffectsRegister().registerEffects();
    }

    private void registerClientEvents() {
        events = new Events();
        fmlEvents = new FMLEvents();
        ModEvents modEvents = new ModEvents();
        MinecraftForge.EVENT_BUS.register((Object)events);
        MinecraftForge.EVENT_BUS.register((Object)fmlEvents);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)modEvents);
    }

    private void loadClient(FMLClientSetupEvent event) {
        LOGGER.info("Loading Xaero's World Map - Stage 1/2");
        try {
            Object patreonEntry;
            ModOptions.init();
            String modId = this.getClass().getAnnotation(Mod.class).value();
            ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modId).get();
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById(modId).getFile();
            worldMapClient = new WorldMapClient();
            worldMapClient.preInit(event, modId);
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                modJAR = modFile.getFilePath().toFile();
            }
            Path gameDir = FMLPaths.GAMEDIR.get();
            configFolder = FMLPaths.CONFIGDIR.get().toFile();
            optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
            saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
            Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
            File oldOptionsFile = gameDir.resolve("xaeroworldmap.txt").toFile();
            File oldSaveFolder = gameDir.resolve("mods").resolve("XaeroWorldMap").toFile();
            File oldSaveFolder2 = gameDir.resolve("config").resolve("XaeroWorldMap").toFile();
            if (oldOptionsFile.exists() && !optionsFile.exists()) {
                Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder2.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
            }
            if (!saveFolder.exists()) {
                Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
            }
            Patreon.checkPatreon();
            Patreon.setRendersCapes(fileLayoutID);
            settings = new ModSettings();
            settings.loadSettings();
            Internet.checkModVersion();
            if (isOutdated && (patreonEntry = Patreon.getMods().get(fileLayoutID)) != null) {
                Patreon.setModInfo(patreonEntry, modJAR, versionID, latestVersion, latestVersionMD5, () -> {
                    ModSettings.ignoreUpdate = newestUpdateID;
                    try {
                        settings.saveSettings();
                    }
                    catch (IOException e) {
                        LOGGER.error("suppressed exception", (Throwable)e);
                    }
                });
                Patreon.addOutdatedMod(patreonEntry);
            }
            waypointSymbolCreator = new WaypointSymbolCreator();
            bufferDeallocator = new ByteBufferDeallocator();
            tilePool = new MapTilePool();
            overlayManager = new OverlayManager();
            oldFormatSupport = new OldFormatSupport();
            pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
            mapLimiter = new MapLimiter();
            normalTextureUploadPool = new TextureUploadPool.Normal(256);
            compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
            branchUpdatePool = new TextureUploadPool.BranchUpdate(256, false);
            branchUpdateAllocatePool = new TextureUploadPool.BranchUpdate(256, true);
            branchDownloadPool = new TextureUploadPool.BranchDownload(256);
            textureDirectBufferPool = new TextureDirectBufferPool();
            subsequentNormalTextureUploadPool = new TextureUploadPool.SubsequentNormal(256);
            textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512, 256, 256, 256, 256);
            unknownBlockStateCache = new UnknownBlockStateCache();
            glObjectDeleter = new GLObjectDeleter();
            crashHandler = new CrashHandler();
            mapRunner = new MapRunner();
            mapRunnerThread = new Thread(mapRunner);
            mapRunnerThread.start();
            ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, this::loadLater);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadLater() {
        LOGGER.info("Loading Xaero's World Map - Stage 2/2");
        try {
            settings.findMapItem();
            worldMapClient.postInit();
            settings.updateRegionCacheHashCode();
            LevelMapPropertiesCoder levelMapPropertiesCoder = new LevelMapPropertiesCoder();
            network.registerMessage(0, LevelMapProperties.class, (BiConsumer)levelMapPropertiesCoder, (Function)((Object)levelMapPropertiesCoder), (BiConsumer)new LevelMapPropertiesConsumer());
            SupportMods.load();
            mapElementRenderHandler = MapElementRenderHandler.Builder.begin().build();
            oldFormatSupport.loadStates();
        }
        catch (Throwable e) {
            crashHandler.setCrashedBy(e);
        }
    }

    private void loadCommon(FMLCommonSetupEvent event) {
    }

    private void loadServer(FMLDedicatedServerSetupEvent event) {
        String modId = this.getClass().getAnnotation(Mod.class).value();
        ModContainer modContainer = (ModContainer)ModList.get().getModContainerById(modId).get();
        WorldMapServer worldmapServer = new WorldMapServer();
        worldmapServer.load(event);
        XaeroWorldMapServerCore.worldmapServer = worldmapServer;
        ModLoadingStage.SIDED_SETUP.getDeferredWorkQueue().enqueueWork(modContainer, worldmapServer::loadLater);
    }

    public static void onSessionFinalized() {
        mapLimiter.onSessionFinalized();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.onSessionFinalized();
        }
    }

    static {
        isOutdated = true;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        globalVersion = 1;
        network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("xaeroworldmap", "main"), () -> "1.0", s -> true, s -> true);
        modJAR = null;
    }
}

