/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.task.GetServerDetailsTask;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.patreon.GuiUpdateAll;
import xaero.map.patreon.Patreon;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;

    @SubscribeEvent
    public void guiOpen(ScreenEvent.Opening event) {
        if (event.getNewScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                GetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    try {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("f_88773_");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("task");
                    }
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    try {
                        this.realmsTaskServerField = GetServerDetailsTask.class.getDeclaredField("f_90327_");
                    }
                    catch (NoSuchFieldException nsfe) {
                        this.realmsTaskServerField = GetServerDetailsTask.class.getDeclaredField("server");
                    }
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)event.getNewScreen())) instanceof GetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (GetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.f_87473_ != this.latestRealm.f_87473_)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        WorldMapSession worldmapSession;
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END) {
            WorldMap.glObjectDeleter.work();
        }
        if (mc.f_91074_ != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.phase == TickEvent.Phase.END) {
                mapProcessor.onRenderProcess(mc);
                mc.f_91079_ = false;
                mapProcessor.resetRenderStartTime();
                Queue<Runnable> minecraftScheduledTasks = mapProcessor.getMinecraftScheduledTasks();
                Runnable task = mapProcessor.getRenderStartTimeUpdater();
                Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
                minecraftScheduledTasks.clear();
                minecraftScheduledTasks.add(task);
                for (Runnable t : currentTasks) {
                    minecraftScheduledTasks.add(t);
                }
            } else if (event.phase == TickEvent.Phase.START) {
                if (!SupportMods.vivecraft && Misc.screenShouldSkipWorldRender(mc.f_91080_, true)) {
                    RenderSystem.m_69482_();
                    mc.f_91063_.m_109093_(1.0f, Util.m_137569_(), false);
                    mc.f_91079_ = true;
                }
                if (mapProcessor != null) {
                    mapProcessor.setMainValues();
                }
            }
        }
    }

    @SubscribeEvent
    public void renderTick(ScreenEvent.Render.Post event) {
        if (Patreon.needsNotification() && event.getScreen() instanceof TitleScreen && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.m_91087_().m_91152_((Screen)new GuiUpdateAll());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    public void spawnSet(Level world, BlockPos spawn) {
        WorldMapSession worldmapSession;
        if (world instanceof ClientLevel && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.updateWorldSpawn(spawn, (ClientLevel)world);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<Level> event) {
        if (event.getObject() instanceof ServerLevel) {
            ServerWorldCapabilities capabilityProvider = new ServerWorldCapabilities();
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)capabilityProvider);
            event.addListener(capabilityProvider::invalidateCaps);
        }
    }

    @SubscribeEvent
    public void worldUnload(LevelEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.m_91087_().f_91074_ != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.getLevel() == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.getLevel() instanceof ServerLevel) {
            ServerLevel sw = (ServerLevel)event.getLevel();
            WorldDataHandler.onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }

    @SubscribeEvent
    public void handleRenderPlayerEventPost(RenderPlayerEvent.Post event) {
        if (SupportMods.optifine) {
            Patreon.renderCapeFallback(WorldMap.fileLayoutID, event);
        }
    }
}

