/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.exception.OpenGLException;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.graphics.shader.MapShaders;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.LeafRegionTexture;

public class PNGExporter {
    private Path destinationPath;
    private PoseStack matrixStack;

    public PNGExporter(Path destinationPath) {
        this.destinationPath = destinationPath;
        this.matrixStack = new PoseStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(MapProcessor mapProcessor) throws IllegalArgumentException, IllegalAccessException, OpenGLException {
        BufferedImage image;
        long maxExportSizeInRegions;
        int n;
        if (!mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
            WorldMap.LOGGER.info("Can't export the PNG just yet!");
            return;
        }
        List<LeveledRegion<?>> list = mapProcessor.getMapWorld().getCurrentDimension().getMapRegions().getUnsyncedList();
        if (list.isEmpty()) {
            return;
        }
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (LeveledRegion<?> leveledRegion : list) {
            if (leveledRegion.getLevel() != 0 || !((MapRegion)leveledRegion).hasHadTerrain()) continue;
            if (minX == null || leveledRegion.getRegionX() < minX) {
                minX = leveledRegion.getRegionX();
            }
            if (maxX == null || leveledRegion.getRegionX() > maxX) {
                maxX = leveledRegion.getRegionX();
            }
            if (minZ == null || leveledRegion.getRegionZ() < minZ) {
                minZ = leveledRegion.getRegionZ();
            }
            if (maxZ != null && leveledRegion.getRegionZ() <= maxZ) continue;
            maxZ = leveledRegion.getRegionZ();
        }
        for (Hashtable hashtable : mapProcessor.getMapWorld().getCurrentDimension().getDetectedRegions().values()) {
            for (RegionDetection regionDetection : hashtable.values()) {
                if (!regionDetection.isHasHadTerrain()) continue;
                if (minX == null || regionDetection.getRegionX() < minX) {
                    minX = regionDetection.getRegionX();
                }
                if (maxX == null || regionDetection.getRegionX() > maxX) {
                    maxX = regionDetection.getRegionX();
                }
                if (minZ == null || regionDetection.getRegionZ() < minZ) {
                    minZ = regionDetection.getRegionZ();
                }
                if (maxZ != null && regionDetection.getRegionZ() <= maxZ) continue;
                maxZ = regionDetection.getRegionZ();
            }
        }
        int exportWidthInRegions = maxX - minX + 1;
        long exportSizeInRegions = (long)exportWidthInRegions * (long)(n = maxZ - minZ + 1);
        if (exportSizeInRegions > (maxExportSizeInRegions = 0x6400000L)) {
            WorldMap.LOGGER.info("Can't export PNG because the map is too big: " + exportSizeInRegions);
            return;
        }
        float scale = exportSizeInRegions < 400L ? 1.0f : (float)(20.0 / Math.sqrt(exportSizeInRegions));
        float regionSize = 512.0f * scale;
        int exportWidth = (int)((float)exportWidthInRegions * regionSize);
        int exportHeight = (int)((float)n * regionSize);
        int maxTextureSize = GL11.glGetInteger((int)3379);
        OpenGLException.checkGLError();
        int frameWidth = Math.min(1024, Math.min(maxTextureSize, exportWidth));
        int frameHeight = Math.min(1024, Math.min(maxTextureSize, exportHeight));
        int horizontalFrames = (int)Math.ceil((double)exportWidth / (double)frameWidth);
        int verticalFrames = (int)Math.ceil((double)exportHeight / (double)frameHeight);
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("Exporting PNG of size %dx%d using a framebuffer of size %dx%d.", exportWidth, exportHeight, frameWidth, frameHeight));
        }
        try {
            image = new BufferedImage(exportWidth, exportHeight, 1);
        }
        catch (OutOfMemoryError oome) {
            WorldMap.LOGGER.info("Can't export PNG because java heap is out of memory. Required: " + (long)exportWidth * (long)exportHeight * 4L + " bytes");
            return;
        }
        ImprovedFramebuffer exportFrameBuffer = new ImprovedFramebuffer(frameWidth, frameHeight, false);
        ByteBuffer frameDataBuffer = BufferUtils.createByteBuffer((int)(frameWidth * frameHeight * 4));
        int[] bufferArray = new int[frameWidth * frameHeight];
        if (exportFrameBuffer.f_83920_ == -1) {
            WorldMap.LOGGER.info("Can't export PNG because FBOs are not supported.");
            return;
        }
        Lighting.m_84930_();
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)frameWidth, 0.0f, (float)frameHeight, 0.0f, 1000.0f);
        RenderSystem.m_252934_((Matrix4f)ortho);
        PoseStack matrixStack = this.matrixStack;
        BlockStateShortShapeCache shortShapeCache = mapProcessor.getBlockStateShortShapeCache();
        BlockTintProvider blockTintProvider = mapProcessor.getWorldBlockTintProvider();
        OverlayManager overlayManager = mapProcessor.getOverlayManager();
        MapSaveLoad mapSaveLoad = mapProcessor.getMapSaveLoad();
        MultiTextureRenderTypeRendererProvider rendererProvider = mapProcessor.getMultiTextureRenderTypeRenderers();
        PoseStack shaderMatrixStack = RenderSystem.m_157191_();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.m_157182_();
        matrixStack.m_85836_();
        exportFrameBuffer.m_83947_(true);
        matrixStack.m_85841_(scale, scale, 1.0f);
        boolean[] justMetaDest = new boolean[1];
        for (int i = 0; i < horizontalFrames; ++i) {
            for (int j = 0; j < verticalFrames; ++j) {
                RenderSystem.m_69396_((int)0);
                RenderSystem.m_157453_((int)0, (int)0);
                RenderSystem.m_69424_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.m_69421_((int)16640, (boolean)Minecraft.f_91002_);
                matrixStack.m_85836_();
                float frameLeft = (float)minX.intValue() * 512.0f + (float)(i * frameWidth) / scale;
                float frameRight = (float)minX.intValue() * 512.0f + (float)((i + 1) * frameWidth) / scale;
                float frameTop = (float)minZ.intValue() * 512.0f + (float)(j * frameHeight) / scale;
                float frameBottom = (float)minZ.intValue() * 512.0f + (float)((j + 1) * frameHeight) / scale;
                int minTileChunkX = (int)Math.floor(frameLeft) >> 6;
                int maxTileChunkX = (int)Math.floor(frameRight) >> 6;
                int minTileChunkZ = (int)Math.floor(frameTop) >> 6;
                int maxTileChunkZ = (int)Math.floor(frameBottom) >> 6;
                int minRegionX = minTileChunkX >> 3;
                int minRegionZ = minTileChunkZ >> 3;
                int maxRegionX = maxTileChunkX >> 3;
                int maxRegionZ = maxTileChunkZ >> 3;
                matrixStack.m_85837_((double)(-frameLeft) + 0.1, (double)(-frameTop), 0.0);
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
                    for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                        boolean loadingFromCache;
                        MapRegion originalRegion = mapProcessor.getMapRegion(regionX, regionZ, false);
                        MapRegionInfo regionInfo = originalRegion;
                        if (originalRegion == null && mapProcessor.regionDetectionExists(regionX, regionZ)) {
                            regionInfo = mapProcessor.getRegionDetection(regionX, regionZ);
                        }
                        if (regionInfo == null) continue;
                        File cacheFile = regionInfo.getCacheFile();
                        boolean bl = loadingFromCache = originalRegion == null || !originalRegion.isBeingWritten() || originalRegion.getLoadState() != 2;
                        if (loadingFromCache && cacheFile == null) {
                            if (!regionInfo.hasLookedForCache()) {
                                try {
                                    cacheFile = mapSaveLoad.getCacheFile(regionInfo, true, false);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (cacheFile == null) continue;
                        }
                        MapRegion region = new MapRegion("png", "null", null, null, regionX, regionZ, 0, false, null);
                        if (loadingFromCache) {
                            region.setShouldCache(true, "png");
                            region.setHasHadTerrain();
                            region.setCacheFile(cacheFile);
                            region.loadCacheTextures(mapProcessor, false, null, 0, null, justMetaDest, 1);
                        } else {
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk originalTileChunk = originalRegion.getChunk(o, p);
                                    if (originalTileChunk == null || !originalTileChunk.hasHadTerrain()) continue;
                                    MapTileChunk tileChunk = region.createTexture(o, p).getTileChunk();
                                    for (int tx = 0; tx < 4; ++tx) {
                                        for (int tz = 0; tz < 4; ++tz) {
                                            tileChunk.setTile(tx, tz, originalTileChunk.getTile(tx, tz), shortShapeCache);
                                        }
                                    }
                                    tileChunk.setLoadState((byte)2);
                                    tileChunk.updateBuffers(mapProcessor, blockTintProvider, overlayManager, WorldMap.settings.detailed_debug, shortShapeCache);
                                }
                            }
                        }
                        MultiTextureRenderTypeRenderer renderer = rendererProvider.getRenderer(t -> RenderSystem.m_157453_((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                        IntArrayList texturesToDelete = new IntArrayList();
                        for (int localChunkX = 0; localChunkX < 8; ++localChunkX) {
                            for (int localChunkZ = 0; localChunkZ < 8; ++localChunkZ) {
                                MapTileChunk tileChunk = region.getChunk(localChunkX, localChunkZ);
                                if (tileChunk == null) continue;
                                LeafRegionTexture tileChunkTexture = tileChunk.getLeafTexture();
                                if (tileChunk.getX() < minTileChunkX || tileChunk.getX() > maxTileChunkX || tileChunk.getZ() < minTileChunkZ || tileChunk.getZ() > maxTileChunkZ) {
                                    tileChunkTexture.deleteColorBuffer();
                                    continue;
                                }
                                int textureId = tileChunkTexture.bindColorTexture(true);
                                if (tileChunkTexture.isColorBufferCompressed()) {
                                    GL13.glCompressedTexImage2D((int)3553, (int)0, (int)tileChunkTexture.getColorBufferFormat(), (int)64, (int)64, (int)0, (ByteBuffer)tileChunkTexture.getDirectColorBuffer());
                                } else {
                                    int internalFormat = tileChunkTexture.getColorBufferFormat() == -1 ? 32856 : tileChunkTexture.getColorBufferFormat();
                                    GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)tileChunkTexture.getDirectColorBuffer());
                                }
                                tileChunkTexture.deleteColorBuffer();
                                if (textureId == -1) continue;
                                GL11.glTexParameteri((int)3553, (int)33085, (int)9);
                                RenderSystem.m_69937_((int)3553, (int)33083, (int)9);
                                exportFrameBuffer.generateMipmaps();
                                RenderSystem.m_69937_((int)3553, (int)10241, (int)9987);
                                MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, tileChunk.getX() * 64, tileChunk.getZ() * 64, 0, 0, 64, 64, 64, 64, textureId);
                                texturesToDelete.add(textureId);
                            }
                        }
                        MapShaders.WORLD_MAP.setBrightness(1.0f);
                        MapShaders.WORLD_MAP.setWithLight(false);
                        rendererProvider.draw(renderer);
                        GL11.glDeleteTextures((int[])texturesToDelete.toIntArray());
                        RenderSystem.m_69396_((int)0);
                    }
                }
                matrixStack.m_85849_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                exportFrameBuffer.m_83956_();
                frameDataBuffer.clear();
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (ByteBuffer)frameDataBuffer);
                frameDataBuffer.asIntBuffer().get(bufferArray);
                int actualFrameWidth = Math.min(frameWidth, exportWidth - i * frameWidth);
                int actualFrameHeight = Math.min(frameHeight, exportHeight - j * frameWidth);
                image.setRGB(i * frameWidth, j * frameHeight, actualFrameWidth, actualFrameHeight, bufferArray, 0, frameWidth);
            }
        }
        exportFrameBuffer.m_83970_();
        Minecraft mc = Minecraft.m_91087_();
        exportFrameBuffer.bindDefaultFramebuffer(mc);
        RenderSystem.m_69481_();
        matrixStack.m_85849_();
        shaderMatrixStack.m_85849_();
        RenderSystem.m_157182_();
        Misc.minecraftOrtho(mc, SupportMods.vivecraft);
        RenderSystem.m_69396_((int)0);
        exportFrameBuffer.m_83930_();
        mapProcessor.getBufferDeallocator().deallocate(frameDataBuffer, WorldMap.settings.debug);
        Stream<Path> exports = null;
        try {
            Object[] exportsArray;
            if (!Files.exists(this.destinationPath, new LinkOption[0])) {
                Files.createDirectories(this.destinationPath, new FileAttribute[0]);
            }
            int exportNumber = 1;
            exports = Files.list(this.destinationPath);
            if (exports == null) {
                return;
            }
            for (Object o : exportsArray = exports.toArray()) {
                Path path = (Path)o;
                if (!path.getFileName().toString().endsWith("png")) continue;
                try {
                    int currentNumber = Integer.parseInt(path.getFileName().toString().split("\\.")[0].split("_")[1]);
                    if (currentNumber < exportNumber) continue;
                    exportNumber = currentNumber + 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ImageIO.write((RenderedImage)image, "png", this.destinationPath.resolve("export_" + exportNumber + ".png").toFile());
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("Failed to export PNG: ", (Throwable)e1);
        }
        finally {
            if (exports != null) {
                exports.close();
            }
            image.flush();
        }
    }
}

