/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.pac.gui;

import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import xaero.map.WorldMap;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.MapElementRenderer;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.pac.SupportOpenPartiesAndClaims;
import xaero.map.mods.pac.gui.PartyPlayerIconRenderer;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMapElement;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMenuRenderContext;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderProvider;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderer;

public final class PlayerDynamicInfoMapElementMenuRenderer
extends MapElementMenuRenderer<PlayerDynamicInfoMapElement, PlayerDynamicInfoMenuRenderContext> {
    private final SupportOpenPartiesAndClaims pac;
    private final PartyPlayerIconRenderer iconRenderer;
    private final PlayerDynamicInfoRenderer renderer;

    private PlayerDynamicInfoMapElementMenuRenderer(PlayerDynamicInfoRenderer renderer, PartyPlayerIconRenderer iconRenderer, SupportOpenPartiesAndClaims pac, PlayerDynamicInfoMenuRenderContext context, PlayerDynamicInfoRenderProvider<PlayerDynamicInfoMenuRenderContext> provider) {
        super(context, provider);
        this.pac = pac;
        this.iconRenderer = iconRenderer;
        this.renderer = renderer;
    }

    @Override
    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height) {
        super.onMapInit(screen, mc, width, height);
        CursorBox showPlayersTooltip = new CursorBox((Component)Component.m_237110_((String)(WorldMap.settings.pacPlayers ? "gui.xaero_box_showing_pac_players" : "gui.xaero_box_hiding_pac_players"), (Object[])new Object[]{Component.m_237113_((String)Misc.getKeyName(SupportMods.xaeroPac.getPacPlayerKeyBinding())).m_130938_(s -> s.m_131140_(ChatFormatting.DARK_GREEN))}), true);
        screen.addButton(new GuiTexturedButton(width - 173, height - 33, 20, 20, WorldMap.settings.pacPlayers ? 197 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onShowPlayersButton(screen, width, height), () -> showPlayersTooltip));
    }

    public void onShowPlayersButton(GuiMap screen, int width, int height) {
        WorldMap.settings.pacPlayers = !WorldMap.settings.pacPlayers;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        screen.m_6575_(this.mc, width, height);
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }

    @Override
    public void renderInMenu(PlayerDynamicInfoMapElement element, GuiGraphics guiGraphics, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        PlayerDynamicInfoMapElement playerElement = element;
        PlayerInfo info = mc.m_91403_().m_104949_(playerElement.getPlayerId());
        if (info != null) {
            Player clientPlayer = mc.f_91073_.m_46003_(playerElement.getPlayerId());
            this.iconRenderer.renderIcon(guiGraphics, clientPlayer, this.pac.getPartyPlayerIconManager().getPlayerSkin(clientPlayer, info));
        }
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 1;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_players_by_name";
    }

    @Override
    protected MapElementRenderer<? super PlayerDynamicInfoMapElement, ?, ?> getRenderer(PlayerDynamicInfoMapElement element) {
        return this.renderer;
    }

    public static final class Builder {
        private SupportOpenPartiesAndClaims pac;
        private PlayerDynamicInfoRenderer renderer;

        private Builder() {
        }

        private Builder setDefault() {
            this.setPac(null);
            return this;
        }

        public Builder setPac(SupportOpenPartiesAndClaims pac) {
            this.pac = pac;
            return this;
        }

        public Builder setRenderer(PlayerDynamicInfoRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public PlayerDynamicInfoMapElementMenuRenderer build() {
            if (this.pac == null || this.renderer == null) {
                throw new IllegalStateException();
            }
            return new PlayerDynamicInfoMapElementMenuRenderer(this.renderer, new PartyPlayerIconRenderer(), this.pac, new PlayerDynamicInfoMenuRenderContext(), new PlayerDynamicInfoRenderProvider<PlayerDynamicInfoMenuRenderContext>(this.pac));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

