/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.pac.gui;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.language.I18n;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.element.MapElementReader;
import xaero.map.gui.IRightClickableElement;
import xaero.map.gui.dropdown.rightclick.RightClickOption;
import xaero.map.mods.SupportMods;
import xaero.map.mods.pac.gui.PlayerDynamicInfoMapElement;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderContext;
import xaero.map.mods.pac.gui.PlayerDynamicInfoRenderer;

public class PlayerDynamicInfoReader
extends MapElementReader<PlayerDynamicInfoMapElement, PlayerDynamicInfoRenderContext, PlayerDynamicInfoRenderer> {
    @Override
    public boolean isHidden(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context) {
        return !Minecraft.m_91087_().f_91073_.m_46472_().m_135782_().equals((Object)element.getSyncable().getDimension());
    }

    @Override
    public double getRenderX(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return element.getSyncable().getX();
    }

    @Override
    public double getRenderZ(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return element.getSyncable().getZ();
    }

    @Override
    public int getInteractionBoxLeft(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return -10;
    }

    @Override
    public int getInteractionBoxRight(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return 10;
    }

    @Override
    public int getInteractionBoxTop(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return -10;
    }

    @Override
    public int getInteractionBoxBottom(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return 10;
    }

    @Override
    public int getRenderBoxLeft(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxRight(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getRenderBoxTop(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return -20;
    }

    @Override
    public int getRenderBoxBottom(PlayerDynamicInfoMapElement element, PlayerDynamicInfoRenderContext context, float partialTicks) {
        return 20;
    }

    @Override
    public int getLeftSideLength(PlayerDynamicInfoMapElement element, Minecraft mc) {
        PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(element.getSyncable().getPlayerId());
        if (info == null) {
            return 9;
        }
        return 9 + mc.f_91062_.m_92895_(info.m_105312_().getName());
    }

    @Override
    public String getMenuName(PlayerDynamicInfoMapElement element) {
        PlayerInfo info = Minecraft.m_91087_().m_91403_().m_104949_(element.getSyncable().getPlayerId());
        if (info == null) {
            return "" + element.getSyncable().getPlayerId();
        }
        return info.m_105312_().getName();
    }

    @Override
    public String getFilterName(PlayerDynamicInfoMapElement element) {
        return this.getMenuName(element);
    }

    @Override
    public int getMenuTextFillLeftPadding(PlayerDynamicInfoMapElement element) {
        return 0;
    }

    @Override
    public int getRightClickTitleBackgroundColor(PlayerDynamicInfoMapElement element) {
        return -11184641;
    }

    @Override
    public boolean shouldScaleBoxWithOptionalScale() {
        return true;
    }

    @Override
    public boolean isRightClickValid(PlayerDynamicInfoMapElement element) {
        return SupportMods.xaeroPac.playerExists(element.getPlayerId());
    }

    @Override
    public ArrayList<RightClickOption> getRightClickOptions(final PlayerDynamicInfoMapElement element, IRightClickableElement target) {
        ArrayList<RightClickOption> rightClickOptions = new ArrayList<RightClickOption>();
        rightClickOptions.add(new RightClickOption(this.getMenuName(element), rightClickOptions.size(), target){

            @Override
            public void onAction(Screen screen) {
            }
        });
        rightClickOptions.add(new RightClickOption("", rightClickOptions.size(), target){

            @Override
            public String getName() {
                return I18n.m_118938_((String)(SupportMods.xaeroPac.isFromParty(element.getPlayerId()) ? "gui.xaero_wm_player_same_party" : "gui.xaero_wm_player_ally_party"), (Object[])new Object[0]);
            }

            @Override
            public void onAction(Screen screen) {
            }
        });
        rightClickOptions.add(new RightClickOption("", rightClickOptions.size(), target){

            @Override
            public String getName() {
                if (!WorldMap.settings.coordinates) {
                    return "hidden";
                }
                return String.format("X: %d, Y: %s, Z: %d", (int)Math.floor(element.getSyncable().getX()), (int)Math.floor(element.getSyncable().getY()), (int)Math.floor(element.getSyncable().getZ()));
            }

            @Override
            public void onAction(Screen screen) {
            }
        });
        rightClickOptions.add(new RightClickOption("gui.xaero_right_click_player_teleport", rightClickOptions.size(), target){

            @Override
            public void onAction(Screen screen) {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                SupportMods.xaeroPac.teleportToPlayer(screen, session.getMapProcessor().getMapWorld(), element);
            }
        }.setNameFormatArgs("T"));
        rightClickOptions.add(new RightClickOption("gui.xaero_right_click_player_config", rightClickOptions.size(), target){

            @Override
            public void onAction(Screen screen) {
                SupportMods.xaeroPac.openPlayerConfigScreen(screen, screen, element);
            }

            @Override
            public boolean isActive() {
                return Minecraft.m_91087_().f_91074_.m_20310_(2) && Minecraft.m_91087_().m_91403_().m_104949_(element.getSyncable().getPlayerId()) != null;
            }
        }.setNameFormatArgs("C"));
        return rightClickOptions;
    }

    @Override
    public boolean isInteractable(int location, PlayerDynamicInfoMapElement element) {
        return true;
    }
}

