/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.export;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BlockTintProvider;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.exception.OpenGLException;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.RegionDetection;
import xaero.map.file.export.PNGExportResult;
import xaero.map.file.export.PNGExportResultType;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.graphics.shader.MapShaders;
import xaero.map.gui.GuiMap;
import xaero.map.gui.MapTileSelection;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.region.ExportMapRegion;
import xaero.map.region.ExportMapTileChunk;
import xaero.map.region.LeveledRegion;
import xaero.map.region.MapLayer;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;
import xaero.map.region.texture.ExportLeafRegionTexture;
import xaero.map.world.MapDimension;

public class PNGExporter {
    private final Calendar calendar = Calendar.getInstance();
    private Path destinationPath;
    private PoseStack matrixStack;

    public PNGExporter(Path destinationPath) {
        this.destinationPath = destinationPath;
        this.matrixStack = new PoseStack();
    }

    public PNGExportResult export(MapProcessor mapProcessor, Registry<Biome> biomeRegistry, MapTileSelection selection, OldFormatSupport oldFormatSupport) throws IllegalArgumentException, IllegalAccessException, OpenGLException {
        int[] bufferArray;
        ByteBuffer frameDataBuffer;
        ImprovedFramebuffer exportFrameBuffer;
        BufferedImage image;
        int pixelCount;
        boolean multipleImages;
        long maxExportAreaSizeInRegions;
        int scaleDownSquareSquared;
        int n;
        if (!mapProcessor.getMapSaveLoad().isRegionDetectionComplete()) {
            return new PNGExportResult(PNGExportResultType.NOT_PREPARED, null);
        }
        int exportedLayer = mapProcessor.getCurrentCaveLayer();
        MapDimension dim = mapProcessor.getMapWorld().getCurrentDimension();
        List<LeveledRegion<?>> list = dim.getLayeredMapRegions().getUnsyncedList();
        if (list.isEmpty()) {
            return new PNGExportResult(PNGExportResultType.EMPTY, null);
        }
        boolean multipleImagesSetting = WorldMap.settings.multipleImagesExport;
        boolean nightExportSetting = WorldMap.settings.nightExport;
        int exportScaleDownSquareSetting = WorldMap.settings.exportScaleDownSquare;
        boolean includingHighlights = WorldMap.settings.highlightsExport;
        boolean full = selection == null;
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        MapLayer mapLayer = dim.getLayeredMapRegions().getLayer(exportedLayer);
        if (full) {
            for (LeveledRegion<?> region : list) {
                if (region.getLevel() != 0 || !((MapRegion)region).hasHadTerrain() || region.getCaveLayer() != exportedLayer) continue;
                if (minX == null || region.getRegionX() < minX) {
                    minX = region.getRegionX();
                }
                if (maxX == null || region.getRegionX() > maxX) {
                    maxX = region.getRegionX();
                }
                if (minZ == null || region.getRegionZ() < minZ) {
                    minZ = region.getRegionZ();
                }
                if (maxZ != null && region.getRegionZ() <= maxZ) continue;
                maxZ = region.getRegionZ();
            }
            Iterable<Hashtable<Integer, RegionDetection>> regionDetectionIterable = !dim.isUsingWorldSave() ? mapLayer.getDetectedRegions().values() : dim.getWorldSaveDetectedRegions();
            for (Hashtable hashtable : regionDetectionIterable) {
                for (RegionDetection regionDetection : hashtable.values()) {
                    if (!regionDetection.isHasHadTerrain()) continue;
                    if (minX == null || regionDetection.getRegionX() < minX) {
                        minX = regionDetection.getRegionX();
                    }
                    if (maxX == null || regionDetection.getRegionX() > maxX) {
                        maxX = regionDetection.getRegionX();
                    }
                    if (minZ == null || regionDetection.getRegionZ() < minZ) {
                        minZ = regionDetection.getRegionZ();
                    }
                    if (maxZ != null && regionDetection.getRegionZ() <= maxZ) continue;
                    maxZ = regionDetection.getRegionZ();
                }
            }
        } else {
            minX = selection.getLeft() >> 5;
            minZ = selection.getTop() >> 5;
            maxX = selection.getRight() >> 5;
            maxZ = selection.getBottom() >> 5;
        }
        int minBlockX = minX * 512;
        int minBlockZ = minZ * 512;
        int n2 = (maxX + 1) * 512 - 1;
        int maxBlockZ = (maxZ + 1) * 512 - 1;
        if (!full) {
            minBlockX = Math.max(minBlockX, selection.getLeft() << 4);
            minBlockZ = Math.max(minBlockZ, selection.getTop() << 4);
            n = Math.min(n2, (selection.getRight() << 4) + 15);
            maxBlockZ = Math.min(maxBlockZ, (selection.getBottom() << 4) + 15);
        }
        int exportAreaWidthInRegions = maxX - minX + 1;
        int exportAreaHeightInRegions = maxZ - minZ + 1;
        long exportAreaSizeInRegions = (long)exportAreaWidthInRegions * (long)exportAreaHeightInRegions;
        int exportAreaWidth = exportAreaWidthInRegions * 512;
        int exportAreaHeight = exportAreaHeightInRegions * 512;
        if (!full) {
            exportAreaWidth = n - minBlockX + 1;
            exportAreaHeight = maxBlockZ - minBlockZ + 1;
        }
        float scale = exportAreaSizeInRegions < (long)(scaleDownSquareSquared = exportScaleDownSquareSetting * exportScaleDownSquareSetting) || multipleImagesSetting || scaleDownSquareSquared <= 0 ? 1.0f : (float)((double)exportScaleDownSquareSetting / Math.sqrt(exportAreaSizeInRegions));
        int exportImageWidth = (int)((float)exportAreaWidth * scale);
        int exportImageHeight = (int)((float)exportAreaHeight * scale);
        if (!multipleImagesSetting && scaleDownSquareSquared > 0 && (long)exportAreaWidth * (long)exportAreaHeight / 512L / 512L > (maxExportAreaSizeInRegions = (long)scaleDownSquareSquared * 262144L)) {
            return new PNGExportResult(PNGExportResultType.TOO_BIG, null);
        }
        int maxTextureSize = GL11.glGetInteger((int)3379);
        OpenGLException.checkGLError();
        int frameWidth = Math.min(1024, Math.min(maxTextureSize, exportImageWidth));
        int frameHeight = Math.min(1024, Math.min(maxTextureSize, exportImageHeight));
        int horizontalFrames = (int)Math.ceil((double)exportImageWidth / (double)frameWidth);
        int verticalFrames = (int)Math.ceil((double)exportImageHeight / (double)frameHeight);
        boolean bl = multipleImages = multipleImagesSetting && horizontalFrames * verticalFrames > 1;
        if (multipleImages) {
            exportImageWidth = frameWidth;
            exportImageHeight = frameHeight;
        }
        if ((pixelCount = exportImageWidth * exportImageHeight) == Integer.MAX_VALUE || pixelCount / exportImageHeight != exportImageWidth) {
            return new PNGExportResult(PNGExportResultType.IMAGE_TOO_BIG, null);
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("Exporting PNG of size %dx%d using a framebuffer of size %dx%d.", exportImageWidth, exportImageHeight, frameWidth, frameHeight));
        }
        try {
            image = new BufferedImage(exportImageWidth, exportImageHeight, 1);
            exportFrameBuffer = new ImprovedFramebuffer(frameWidth, frameHeight, false);
            frameDataBuffer = BufferUtils.createByteBuffer((int)(frameWidth * frameHeight * 4));
            bufferArray = new int[frameWidth * frameHeight];
        }
        catch (OutOfMemoryError oome) {
            return new PNGExportResult(PNGExportResultType.OUT_OF_MEMORY, null);
        }
        if (exportFrameBuffer.f_83920_ == -1) {
            return new PNGExportResult(PNGExportResultType.BAD_FBO, null);
        }
        Lighting.m_84930_();
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)frameWidth, 0.0f, (float)frameHeight, 0.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (VertexSorting)VertexSorting.f_276633_);
        PoseStack matrixStack = this.matrixStack;
        BlockStateShortShapeCache shortShapeCache = mapProcessor.getBlockStateShortShapeCache();
        BlockTintProvider blockTintProvider = mapProcessor.getWorldBlockTintProvider();
        OverlayManager overlayManager = mapProcessor.getOverlayManager();
        MapSaveLoad mapSaveLoad = mapProcessor.getMapSaveLoad();
        MultiTextureRenderTypeRendererProvider rendererProvider = mapProcessor.getMultiTextureRenderTypeRenderers();
        PoseStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.m_85836_();
        shaderMatrixStack.m_166856_();
        RenderSystem.applyModelViewMatrix();
        matrixStack.m_85836_();
        exportFrameBuffer.m_83947_(true);
        matrixStack.m_85841_(scale, scale, 1.0f);
        boolean[] justMetaDest = new boolean[1];
        Path imageDestination = this.destinationPath;
        if (multipleImages) {
            imageDestination = this.destinationPath.resolve(this.getExportBaseName());
        }
        boolean empty = true;
        PNGExportResultType resultType = PNGExportResultType.SUCCESS;
        for (int i = 0; i < horizontalFrames; ++i) {
            for (int j = 0; j < verticalFrames; ++j) {
                PNGExportResultType saveResult;
                boolean renderedSomething = false;
                RenderSystem.bindTexture((int)0);
                RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.clear((int)16640, (boolean)Minecraft.f_91002_);
                matrixStack.m_85836_();
                float frameLeft = (float)minBlockX + (float)(i * frameWidth) / scale;
                float frameRight = (float)minBlockX + (float)((i + 1) * frameWidth) / scale - 1.0f;
                float frameTop = (float)minBlockZ + (float)(j * frameHeight) / scale;
                float frameBottom = (float)minBlockZ + (float)((j + 1) * frameHeight) / scale - 1.0f;
                if (!full) {
                    if ((float)n < frameRight) {
                        frameRight = n;
                    }
                    if ((float)maxBlockZ < frameBottom) {
                        frameBottom = maxBlockZ;
                    }
                }
                int minTileChunkX = (int)Math.floor(frameLeft) >> 6;
                int maxTileChunkX = (int)Math.floor(frameRight) >> 6;
                int minTileChunkZ = (int)Math.floor(frameTop) >> 6;
                int maxTileChunkZ = (int)Math.floor(frameBottom) >> 6;
                int minRegionX = minTileChunkX >> 3;
                int minRegionZ = minTileChunkZ >> 3;
                int maxRegionX = maxTileChunkX >> 3;
                int maxRegionZ = maxTileChunkZ >> 3;
                matrixStack.m_85837_(0.1, 0.0, 0.0);
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
                    for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                        boolean loadingFromCache;
                        boolean regionHasHighlightsIfUndiscovered;
                        MapRegion originalRegion = mapProcessor.getMapRegion(exportedLayer, regionX, regionZ, false);
                        MapRegionInfo regionInfo = originalRegion;
                        if (originalRegion == null && mapLayer.regionDetectionExists(regionX, regionZ)) {
                            regionInfo = mapLayer.getRegionDetection(regionX, regionZ);
                        }
                        boolean bl2 = regionHasHighlightsIfUndiscovered = includingHighlights && dim.getHighlightHandler().shouldApplyRegionHighlights(regionX, regionZ, false);
                        if (regionInfo == null && !regionHasHighlightsIfUndiscovered) continue;
                        File cacheFile = null;
                        boolean bl3 = loadingFromCache = regionInfo != null && (originalRegion == null || !originalRegion.isBeingWritten() || originalRegion.getLoadState() != 2);
                        if (loadingFromCache) {
                            cacheFile = regionInfo.getCacheFile();
                            if (cacheFile == null && !regionInfo.hasLookedForCache()) {
                                try {
                                    cacheFile = mapSaveLoad.getCacheFile(regionInfo, exportedLayer, true, false);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            if (cacheFile == null) {
                                if (!regionHasHighlightsIfUndiscovered) continue;
                                loadingFromCache = false;
                            }
                        }
                        ExportMapRegion region = new ExportMapRegion(dim, regionX, regionZ, exportedLayer, biomeRegistry);
                        if (loadingFromCache) {
                            region.setShouldCache(true, "png");
                            region.setHasHadTerrain();
                            region.setCacheFile(cacheFile);
                            region.loadCacheTextures(mapProcessor, biomeRegistry, false, null, 0, null, justMetaDest, 1, oldFormatSupport);
                        } else if (originalRegion != null) {
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    MapTileChunk originalTileChunk = originalRegion.getChunk(o, p);
                                    if (originalTileChunk == null || !originalTileChunk.hasHadTerrain()) continue;
                                    MapTileChunk tileChunk = region.createTexture(o, p).getTileChunk();
                                    for (int tx = 0; tx < 4; ++tx) {
                                        for (int tz = 0; tz < 4; ++tz) {
                                            tileChunk.setTile(tx, tz, originalTileChunk.getTile(tx, tz), shortShapeCache);
                                        }
                                    }
                                    tileChunk.setLoadState((byte)2);
                                    tileChunk.updateBuffers(mapProcessor, blockTintProvider, overlayManager, WorldMap.settings.detailed_debug, shortShapeCache);
                                }
                            }
                        }
                        if (includingHighlights) {
                            mapProcessor.getMapRegionHighlightsPreparer().prepare(region, true);
                        }
                        MultiTextureRenderTypeRenderer rendererLight = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                        MultiTextureRenderTypeRenderer rendererNoLight = rendererProvider.getRenderer(t -> RenderSystem.setShaderTexture((int)0, (int)t), MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP);
                        IntArrayList texturesToDelete = new IntArrayList();
                        for (int localChunkX = 0; localChunkX < 8; ++localChunkX) {
                            for (int localChunkZ = 0; localChunkZ < 8; ++localChunkZ) {
                                ExportLeafRegionTexture tileChunkTexture;
                                ExportMapTileChunk tileChunk = region.getChunk(localChunkX, localChunkZ);
                                if (tileChunk == null || (tileChunkTexture = tileChunk.getLeafTexture()) == null) continue;
                                if (tileChunk.getX() < minTileChunkX || tileChunk.getX() > maxTileChunkX || tileChunk.getZ() < minTileChunkZ || tileChunk.getZ() > maxTileChunkZ) {
                                    tileChunkTexture.deleteColorBuffer();
                                    continue;
                                }
                                int textureId = tileChunkTexture.bindColorTexture(true);
                                if (tileChunkTexture.getColorBuffer() == null) {
                                    tileChunkTexture.prepareBuffer();
                                }
                                ByteBuffer colorBuffer = tileChunkTexture.getDirectColorBuffer();
                                if (includingHighlights) {
                                    tileChunkTexture.applyHighlights(dim.getHighlightHandler(), tileChunkTexture.getColorBuffer());
                                }
                                if (tileChunkTexture.isColorBufferCompressed()) {
                                    GL13.glCompressedTexImage2D((int)3553, (int)0, (int)tileChunkTexture.getColorBufferFormat(), (int)64, (int)64, (int)0, (ByteBuffer)colorBuffer);
                                } else {
                                    int internalFormat = tileChunkTexture.getColorBufferFormat() == -1 ? 32856 : tileChunkTexture.getColorBufferFormat();
                                    GL11.glTexImage2D((int)3553, (int)0, (int)internalFormat, (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)colorBuffer);
                                }
                                tileChunkTexture.deleteColorBuffer();
                                if (textureId == -1) continue;
                                GL11.glTexParameteri((int)3553, (int)33085, (int)9);
                                RenderSystem.texParameter((int)3553, (int)33083, (int)9);
                                exportFrameBuffer.generateMipmaps();
                                RenderSystem.texParameter((int)3553, (int)10241, (int)9987);
                                GuiMap.renderTexturedModalRectWithLighting3(matrix, (float)(tileChunk.getX() * 64) - frameLeft, (float)(tileChunk.getZ() * 64) - frameTop, 64.0f, 64.0f, textureId, tileChunkTexture.getBufferHasLight(), tileChunkTexture.getBufferHasLight() ? rendererLight : rendererNoLight);
                                renderedSomething = true;
                                texturesToDelete.add(textureId);
                            }
                        }
                        float brightness = nightExportSetting ? mapProcessor.getAmbientBrightness(mapProcessor.getWorld()) : mapProcessor.getBrightness(exportedLayer, mapProcessor.getWorld(), WorldMap.settings.lighting && exportedLayer != Integer.MAX_VALUE);
                        MapShaders.WORLD_MAP.setBrightness(brightness);
                        MapShaders.WORLD_MAP.setWithLight(true);
                        rendererProvider.draw(rendererLight);
                        MapShaders.WORLD_MAP.setWithLight(false);
                        rendererProvider.draw(rendererNoLight);
                        GL11.glDeleteTextures((int[])texturesToDelete.toIntArray());
                        RenderSystem.bindTexture((int)0);
                    }
                }
                matrixStack.m_85849_();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (!renderedSomething) continue;
                empty = false;
                exportFrameBuffer.m_83956_();
                frameDataBuffer.clear();
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (ByteBuffer)frameDataBuffer);
                frameDataBuffer.asIntBuffer().get(bufferArray);
                int insertOffsetX = i * frameWidth;
                int insertOffsetZ = j * frameHeight;
                if (multipleImages) {
                    insertOffsetX = 0;
                    insertOffsetZ = 0;
                }
                int actualFrameWidth = Math.min(frameWidth, exportImageWidth - insertOffsetX);
                int actualFrameHeight = Math.min(frameHeight, exportImageHeight - insertOffsetZ);
                image.setRGB(insertOffsetX, insertOffsetZ, actualFrameWidth, actualFrameHeight, bufferArray, 0, frameWidth);
                if (!multipleImages || (saveResult = this.saveImage(image, imageDestination, i + "_" + j, "_x" + (int)frameLeft + "_z" + (int)frameTop)) == PNGExportResultType.SUCCESS) continue;
                resultType = saveResult;
            }
        }
        exportFrameBuffer.m_83970_();
        Minecraft mc = Minecraft.m_91087_();
        exportFrameBuffer.bindDefaultFramebuffer(mc);
        RenderSystem.enableCull();
        matrixStack.m_85849_();
        shaderMatrixStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        Misc.minecraftOrtho(mc, SupportMods.vivecraft);
        RenderSystem.bindTexture((int)0);
        exportFrameBuffer.m_83930_();
        mapProcessor.getBufferDeallocator().deallocate(frameDataBuffer, WorldMap.settings.debug);
        if (empty) {
            return new PNGExportResult(PNGExportResultType.EMPTY, null);
        }
        if (multipleImages) {
            image.flush();
            return new PNGExportResult(resultType, imageDestination);
        }
        resultType = this.saveImage(image, imageDestination, null, "_x" + minBlockX + "_z" + minBlockZ);
        image.flush();
        return new PNGExportResult(resultType, imageDestination);
    }

    private PNGExportResultType saveImage(BufferedImage image, Path destinationPath, String baseName, String suffix) {
        if (baseName == null) {
            baseName = this.getExportBaseName();
        }
        baseName = (String)baseName + suffix;
        int additionalIndex = 1;
        try {
            if (!Files.exists(destinationPath, new LinkOption[0])) {
                Files.createDirectories(destinationPath, new FileAttribute[0]);
            }
            Path imagePath = destinationPath.resolve((String)baseName + ".png");
            while (Files.exists(imagePath, new LinkOption[0])) {
                imagePath = destinationPath.resolve((String)baseName + "_" + ++additionalIndex + ".png");
            }
            ImageIO.write((RenderedImage)image, "png", imagePath.toFile());
            return PNGExportResultType.SUCCESS;
        }
        catch (IOException e1) {
            WorldMap.LOGGER.error("IO exception while exporting PNG: ", (Throwable)e1);
            return PNGExportResultType.IO_EXCEPTION;
        }
    }

    private String getExportBaseName() {
        this.calendar.setTimeInMillis(System.currentTimeMillis());
        int year = this.calendar.get(1);
        int month = 1 + this.calendar.get(2);
        int day = this.calendar.get(5);
        int hours = this.calendar.get(11);
        int minutes = this.calendar.get(12);
        int seconds = this.calendar.get(13);
        return String.format("%d-%02d-%02d_%02d.%02d.%02d", year, month, day, hours, minutes, seconds);
    }
}

