/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.AxolotlModel;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.EndermiteModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.FrogModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.GoatModel;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.HoglinModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.PufferfishBigModel;
import net.minecraft.client.model.PufferfishMidModel;
import net.minecraft.client.model.PufferfishSmallModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.SalmonModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.WardenModel;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.CatRenderer;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.HorseRenderer;
import net.minecraft.client.renderer.entity.IronGolemRenderer;
import net.minecraft.client.renderer.entity.LlamaRenderer;
import net.minecraft.client.renderer.entity.PigRenderer;
import net.minecraft.client.renderer.entity.StriderRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.client.renderer.entity.ZombieVillagerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import org.joml.Vector3fc;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.misc.OptimizedMath;

public class EntityIconDefinitions {
    public static final Map<Markings, ResourceLocation> HORSE_MARKINGS = (Map)Util.m_137469_((Object)Maps.newEnumMap(Markings.class), map -> {
        map.put(Markings.NONE, null);
        map.put(Markings.WHITE, new ResourceLocation("textures/entity/horse/horse_markings_white.png"));
        map.put(Markings.WHITE_FIELD, new ResourceLocation("textures/entity/horse/horse_markings_whitefield.png"));
        map.put(Markings.WHITE_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_whitedots.png"));
        map.put(Markings.BLACK_DOTS, new ResourceLocation("textures/entity/horse/horse_markings_blackdots.png"));
    });
    static float slimeSquishBU;
    private static StringBuilder VARIANT_STRING_BUILDER;

    public static List<String> getMainModelPartFields(EntityRenderer<?> renderer, EntityModel<?> model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof BatModel) {
            String modelClassPath = BatModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_102184_"));
        } else if (model instanceof BlazeModel) {
            String modelClassPath = BlazeModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_102245_"));
        } else if (model instanceof SpiderModel) {
            String modelClassPath = SpiderModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103852_"));
        } else if (model instanceof CreeperModel) {
            String modelClassPath = CreeperModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_102451_"));
        } else if (model instanceof LlamaModel) {
            String modelClassPath = LlamaModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103031_"));
        } else if (model instanceof ParrotModel) {
            String modelClassPath = ParrotModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103188_"));
        } else if (model instanceof RabbitModel) {
            String modelClassPath = RabbitModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103523_"));
        } else if (model instanceof RavagerModel) {
            String modelClassPath = RavagerModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103598_"));
        } else if (model instanceof IronGolemModel) {
            String modelClassPath = IronGolemModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_102936_"));
        } else if (model instanceof SnowGolemModel) {
            String modelClassPath = SnowGolemModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103839_"));
        } else if (model instanceof EnderDragonRenderer.DragonModel) {
            String modelClassPath = EnderDragonRenderer.DragonModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_114235_"));
        } else if (model instanceof ShulkerModel) {
            String modelClassPath = ShulkerModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_103724_"));
        } else if (model instanceof SlimeModel) {
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("children['%s']", "cube")));
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("f_104213_['%s']", "cube")));
        } else if (model instanceof AxolotlModel) {
            String modelClassPath = AxolotlModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "head"));
            result.add(String.format("%s;%s", modelClassPath, "f_170365_"));
        } else if (model instanceof LavaSlimeModel) {
            result.add(String.format("%s;%s", ModelPart.class.getName(), "children['inside_cube']"));
            result.add(String.format("%s;%s", ModelPart.class.getName(), "f_104213_['inside_cube']"));
        } else if (model instanceof SquidModel || model instanceof GhastModel || model instanceof StriderModel || model instanceof PhantomModel) {
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("children['%s']", "body")));
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("f_104213_['%s']", "body")));
        } else if (model instanceof WardenModel || model instanceof FrogModel) {
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("children['%s']", "head")));
            result.add(String.format("%s;%s", ModelPart.class.getName(), String.format("f_104213_['%s']", "head")));
        }
        return result;
    }

    public static List<String> getSecondaryModelPartsFields(EntityRenderer<?> renderer, EntityModel<?> model, Entity entity) {
        ArrayList<String> result = new ArrayList<String>();
        if (model instanceof RabbitModel) {
            String modelClassPath = RabbitModel.class.getName();
            result.add(String.format("%s;%s", modelClassPath, "rightEar"));
            result.add(String.format("%s;%s", modelClassPath, "f_170877_"));
            result.add(String.format("%s;%s", modelClassPath, "leftEar"));
            result.add(String.format("%s;%s", modelClassPath, "f_170878_"));
            result.add(String.format("%s;%s", modelClassPath, "nose"));
            result.add(String.format("%s;%s", modelClassPath, "f_103527_"));
        }
        return result;
    }

    public static Object getModelRoot(EntityRenderer<?> entityRenderer, EntityModel<?> entityModel) {
        if (entityModel instanceof SquidModel || entityModel instanceof GhastModel || entityModel instanceof SlimeModel || entityModel instanceof PhantomModel || entityModel instanceof StriderModel || entityModel instanceof LavaSlimeModel) {
            return ((HierarchicalModel)entityModel).m_142109_();
        }
        if (entityModel instanceof WardenModel) {
            return ((HierarchicalModel)entityModel).m_142109_().m_171324_("bone").m_171324_("body");
        }
        if (entityModel instanceof FrogModel) {
            return ((HierarchicalModel)entityModel).m_142109_().m_171324_("body");
        }
        return entityModel;
    }

    public static boolean forceFieldCheck(EntityModel<?> entityModel) {
        return entityModel instanceof AxolotlModel;
    }

    static void customTransformation(PoseStack matrixStack, EntityModel em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof CodModel || em instanceof SalmonModel) {
            OptimizedMath.rotatePose(matrixStack, 90.0f, (Vector3fc)OptimizedMath.YP);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof ColorableHierarchicalModel) {
            OptimizedMath.rotatePose(matrixStack, 90.0f, (Vector3fc)OptimizedMath.YP);
        } else if (em instanceof BatModel) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof HorseModel) {
            OptimizedMath.rotatePose(matrixStack, 65.0f, (Vector3fc)OptimizedMath.XP);
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof DolphinModel || em instanceof GoatModel) {
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof GuardianModel || em instanceof SquidModel) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof HoglinModel) {
            OptimizedMath.rotatePose(matrixStack, 45.0f, (Vector3fc)OptimizedMath.XP);
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof LlamaModel) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            slimeSquishBU = slime.f_33584_;
            slime.f_33584_ = 0.0f;
        } else if (em instanceof GhastModel || em instanceof RavagerModel || em instanceof StriderModel || em instanceof EnderDragonRenderer.DragonModel) {
            matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        } else if (em instanceof WitherBossModel) {
            matrixStack.m_85841_(0.35f, 0.35f, 0.35f);
        } else if (em instanceof PhantomModel) {
            matrixStack.m_85841_(0.3f, 0.3f, 0.3f);
            OptimizedMath.rotatePose(matrixStack, 90.0f, (Vector3fc)OptimizedMath.XP);
        } else if (em instanceof PandaModel) {
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        } else if (em instanceof WardenModel) {
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
        }
    }

    public static void customPostRenderTransformation(PoseStack matrixStack, EntityModel entityModel, Entity entity) {
        if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            slime.f_33584_ = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(EntityModel em) {
        return em instanceof CodModel || em instanceof SalmonModel || em instanceof ColorableHierarchicalModel || em instanceof BeeModel || em instanceof DolphinModel || em instanceof GuardianModel || em instanceof EndermiteModel || em instanceof LavaSlimeModel || em instanceof SlimeModel || em instanceof PufferfishBigModel || em instanceof PufferfishMidModel || em instanceof PufferfishSmallModel || em instanceof SilverfishModel || em instanceof WitherBossModel;
    }

    public static EntityIconCustomRenderer getCustomLayer(EntityRenderer entityRenderer, Entity entity) {
        return null;
    }

    public static void buildVariantIdString(StringBuilder stringBuilder, EntityRenderer entityRenderer, Entity entity) {
        ResourceLocation entityTexture = entityRenderer.m_5478_(entity);
        if (entityTexture == null) {
            return;
        }
        stringBuilder.append(entityTexture);
        if (entityRenderer instanceof HorseRenderer) {
            stringBuilder.append("%").append(HORSE_MARKINGS.get(((Horse)entity).m_30724_()));
        } else if (entityRenderer instanceof VillagerRenderer || entityRenderer instanceof ZombieVillagerRenderer) {
            VillagerData villagerdata = ((VillagerDataHolder)entity).m_7141_();
            VillagerType villagertype = villagerdata.m_35560_();
            VillagerProfession villagerprofession = villagerdata.m_35571_();
            int villagerprofessionlevel = villagerdata.m_35576_();
            stringBuilder.append("%").append(((LivingEntity)entity).m_6162_()).append("%").append(villagertype).append("%").append(villagerprofession).append("%").append(villagerprofessionlevel);
        } else if (entityRenderer instanceof CatRenderer) {
            stringBuilder.append("%").append(((Cat)entity).m_21824_());
        } else if (entityRenderer instanceof WolfRenderer) {
            stringBuilder.append("%").append(((Wolf)entity).m_21824_());
        } else if (entityRenderer instanceof IronGolemRenderer) {
            IronGolem ironGolem = (IronGolem)entity;
            IronGolem.Crackiness cracks = ironGolem.m_28873_();
            stringBuilder.append("%").append(cracks);
        } else if (entityRenderer instanceof LlamaRenderer) {
            Llama llama = (Llama)entity;
            stringBuilder.append("%").append(llama.m_7565_()).append("%").append(llama.m_30826_());
        } else if (entityRenderer instanceof PigRenderer) {
            Pig pig = (Pig)entity;
            stringBuilder.append("%").append(pig.m_6254_());
        } else if (entityRenderer instanceof StriderRenderer) {
            Strider strider = (Strider)entity;
            stringBuilder.append("%").append(strider.m_6254_());
        } else if (entityRenderer instanceof TropicalFishRenderer) {
            TropicalFish fish = (TropicalFish)entity;
            stringBuilder.append("%").append(fish.m_262365_());
        }
    }

    public static String getVariantString(EntityRenderer entityRenderer, Entity entity) {
        StringBuilder stringBuilder = VARIANT_STRING_BUILDER;
        stringBuilder.setLength(0);
        EntityIconDefinitions.buildVariantIdString(stringBuilder, entityRenderer, entity);
        return stringBuilder.toString();
    }

    static {
        VARIANT_STRING_BUILDER = new StringBuilder();
    }
}

